/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.ui.HTMLTable;

public class FlexTable
extends HTMLTable {
    public FlexTable() {
        this.setCellFormatter(new FlexCellFormatter());
        this.setRowFormatter(new HTMLTable.RowFormatter(this));
        this.setColumnFormatter(new HTMLTable.ColumnFormatter(this));
    }

    public void addCell(int row) {
        this.insertCell(row, this.getCellCount(row));
    }

    @Override
    public int getCellCount(int row) {
        this.checkRowBounds(row);
        return this.getDOMCellCount(this.getBodyElement(), row);
    }

    public FlexCellFormatter getFlexCellFormatter() {
        return (FlexCellFormatter)this.getCellFormatter();
    }

    @Override
    public int getRowCount() {
        return this.getDOMRowCount();
    }

    @Override
    public void insertCell(int beforeRow, int beforeColumn) {
        super.insertCell(beforeRow, beforeColumn);
    }

    @Override
    public int insertRow(int beforeRow) {
        return super.insertRow(beforeRow);
    }

    public void removeAllRows() {
        int numRows = this.getRowCount();
        for (int i = 0; i < numRows; ++i) {
            this.removeRow(0);
        }
    }

    @Override
    public void removeCell(int row, int col) {
        super.removeCell(row, col);
    }

    public void removeCells(int row, int column, int num) {
        for (int i = 0; i < num; ++i) {
            this.removeCell(row, column);
        }
    }

    @Override
    public void removeRow(int row) {
        super.removeRow(row);
    }

    @Override
    protected void prepareCell(int row, int column) {
        this.prepareRow(row);
        if (column < 0) {
            throw new IndexOutOfBoundsException("Cannot create a column with a negative index: " + column);
        }
        int cellCount = this.getCellCount(row);
        int required = column + 1 - cellCount;
        if (required > 0) {
            this.addCells(this.getBodyElement(), row, required);
        }
    }

    @Override
    protected void prepareRow(int row) {
        int rowCount;
        if (row < 0) {
            throw new IndexOutOfBoundsException("Cannot create a row with a negative index: " + row);
        }
        for (int i = rowCount = this.getRowCount(); i <= row; ++i) {
            this.insertRow(i);
        }
    }

    public class FlexCellFormatter
    extends HTMLTable.CellFormatter {
        public FlexCellFormatter() {
            super(FlexTable.this);
        }

        public int getColSpan(int row, int column) {
            return this.getElement(row, column).getPropertyInt("colSpan");
        }

        public int getRowSpan(int row, int column) {
            return this.getElement(row, column).getPropertyInt("rowSpan");
        }

        public void setColSpan(int row, int column, int colSpan) {
            this.ensureElement(row, column).setPropertyInt("colSpan", colSpan);
        }

        public void setRowSpan(int row, int column, int rowSpan) {
            this.ensureElement(row, column).setPropertyInt("rowSpan", rowSpan);
        }
    }
}

