/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import com.google.gwt.core.client.Duration;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.impl.SchedulerImpl;

public final class Impl {
    private static final int WATCHDOG_ENTRY_DEPTH_CHECK_INTERVAL_MS = 2000;
    private static int entryDepth = 0;
    private static double watchdogEntryDepthLastScheduled;
    private static int watchdogEntryDepthTimerId;
    private static GWT.UncaughtExceptionHandler uncaughtExceptionHandlerForTest;

    public static native JavaScriptObject entry(JavaScriptObject var0);

    public static native String getHostPageBaseURL();

    public static native String getModuleBaseURL();

    public static native String getModuleBaseURLForStaticFiles();

    public static native String getModuleName();

    public static String getNameOf(String jsniIdent) {
        assert (!GWT.isScript()) : "ReplaceRebinds failed to replace this method";
        throw new UnsupportedOperationException("Impl.getNameOf() is unimplemented in Development Mode");
    }

    public static native String getPermutationStrongName();

    public static void setUncaughtExceptionHandlerForTest(GWT.UncaughtExceptionHandler handler) {
        uncaughtExceptionHandlerForTest = handler;
    }

    public static void reportUncaughtException(Throwable e) {
        GWT.UncaughtExceptionHandler handler;
        if (uncaughtExceptionHandlerForTest != null) {
            uncaughtExceptionHandlerForTest.onUncaughtException(e);
        }
        if ((handler = GWT.getUncaughtExceptionHandler()) != null) {
            if (handler == uncaughtExceptionHandlerForTest) {
                return;
            }
            handler.onUncaughtException(e);
            return;
        }
        if (GWT.isClient()) {
            Impl.reportToBrowser(e);
        } else {
            System.err.print("Uncaught exception ");
            e.printStackTrace(System.err);
        }
    }

    private static void reportToBrowser(Throwable e) {
        Impl.reportToBrowser(e instanceof JavaScriptException ? ((JavaScriptException)e).getThrown() : e);
    }

    private static native void reportToBrowser(Object var0);

    public static boolean isEntryOnStack() {
        return entryDepth > 0;
    }

    public static boolean isNestedEntry() {
        return entryDepth > 1;
    }

    public static native JavaScriptObject registerEntry();

    private static native Object apply(Object var0, Object var1, Object var2);

    private static boolean enter() {
        double now;
        assert (entryDepth >= 0) : "Negative entryDepth value at entry " + entryDepth;
        if (GWT.isScript() && entryDepth != 0 && (now = Duration.currentTimeMillis()) - watchdogEntryDepthLastScheduled > 2000.0) {
            watchdogEntryDepthLastScheduled = now;
            watchdogEntryDepthTimerId = Impl.watchdogEntryDepthSchedule();
        }
        if (entryDepth++ == 0) {
            SchedulerImpl.INSTANCE.flushEntryCommands();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Object entry0(Object jsFunction, Object thisObj, Object args) throws Throwable {
        boolean initialEntry = Impl.enter();
        try {
            if (GWT.getUncaughtExceptionHandler() != null) {
                try {
                    Object object = Impl.apply(jsFunction, thisObj, args);
                    return object;
                }
                catch (Throwable t) {
                    Impl.reportUncaughtException(t);
                    Object object = Impl.undefined();
                    Impl.exit(initialEntry);
                    return object;
                }
            }
            Object object = Impl.apply(jsFunction, thisObj, args);
            return object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Impl.exit(initialEntry);
        }
    }

    private static void exit(boolean initialEntry) {
        if (initialEntry) {
            SchedulerImpl.INSTANCE.flushFinallyCommands();
        }
        assert (--entryDepth >= 0) : "Negative entryDepth value at exit " + entryDepth;
        if (initialEntry) {
            assert (entryDepth == 0) : "Depth not 0" + entryDepth;
            if (GWT.isScript() && watchdogEntryDepthTimerId != -1) {
                Impl.watchdogEntryDepthCancel(watchdogEntryDepthTimerId);
                watchdogEntryDepthTimerId = -1;
            }
        }
    }

    private static native Object undefined();

    private static native void watchdogEntryDepthCancel(int var0);

    private static void watchdogEntryDepthRun() {
        if (GWT.isScript() && entryDepth != 0) {
            entryDepth = 0;
        }
        watchdogEntryDepthTimerId = -1;
    }

    private static native int watchdogEntryDepthSchedule();

    static {
        watchdogEntryDepthTimerId = -1;
    }
}

