/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.text.shared.ToStringRenderer;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasConstrainedValue;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import java.util.Collection;

public class ValuePicker<T>
extends Composite
implements HasConstrainedValue<T>,
IsEditor<LeafValueEditor<T>> {
    private T value;
    private final CellList<T> cellList;
    private SingleSelectionModel<T> smodel = new SingleSelectionModel();
    private LeafValueEditor<T> editor;

    public ValuePicker(CellList<T> cellList) {
        this.cellList = cellList;
        this.initWidget(cellList);
        cellList.setSelectionModel(this.smodel);
        this.smodel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            @Override
            public void onSelectionChange(SelectionChangeEvent event) {
                ValuePicker.this.setValue(ValuePicker.this.smodel.getSelectedObject(), true);
            }
        });
    }

    public ValuePicker(Renderer<? super T> renderer) {
        this(new CellList<T>(new DefaultCell<T>(renderer)));
    }

    public ValuePicker() {
        this(ToStringRenderer.instance());
    }

    @Override
    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<T> handler) {
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    @Override
    public LeafValueEditor<T> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of(this);
        }
        return this.editor;
    }

    @Override
    public ValuePicker<T> asWidget() {
        return this;
    }

    public int getPageSize() {
        return this.cellList.getPageSize();
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setAcceptableValues(Collection<T> values) {
        this.cellList.setRowData(new ArrayList<T>(values));
    }

    public void setPageSize(int size) {
        this.cellList.setPageSize(size);
    }

    @Override
    public void setValue(T value) {
        this.setValue(value, false);
    }

    @Override
    public void setValue(T value, boolean fireEvents) {
        T current = this.getValue();
        if (current == value || current != null && current.equals(value)) {
            return;
        }
        this.value = value;
        this.smodel.setSelected(value, true);
        if (fireEvents) {
            ValueChangeEvent.fire(this, value);
        }
    }

    private static class DefaultCell<T>
    extends AbstractCell<T> {
        private final Renderer<? super T> renderer;

        DefaultCell(Renderer<? super T> renderer) {
            super(new String[0]);
            this.renderer = renderer;
        }

        @Override
        public void render(Cell.Context context, T value, SafeHtmlBuilder sb) {
            sb.appendEscaped(this.renderer.render(value));
        }
    }
}

