/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.shared.impl;

import com.google.gwt.thirdparty.json.JSONObject;
import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.autobean.vm.impl.JsonSplittable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class StringQuoter {
    private static final String ISO8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSz";
    private static final DateFormat ISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz", Locale.getDefault());
    private static final String RFC2822_PATTERN = "EEE, d MMM yyyy HH:mm:ss Z";
    private static final DateFormat RFC2822 = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.getDefault());

    public static Splittable create(boolean value) {
        return JsonSplittable.create(String.valueOf(value));
    }

    public static Splittable create(double value) {
        return JsonSplittable.create(String.valueOf(value));
    }

    public static Splittable create(String value) {
        return JsonSplittable.create(StringQuoter.quote(value));
    }

    public static Splittable createIndexed() {
        return JsonSplittable.createIndexed();
    }

    public static Splittable createSplittable() {
        return JsonSplittable.create();
    }

    public static Splittable nullValue() {
        return JsonSplittable.createNull();
    }

    public static String quote(String raw) {
        return JSONObject.quote(raw);
    }

    public static Splittable split(String payload) {
        return JsonSplittable.create(payload);
    }

    public static Date tryParseDate(String date) {
        try {
            return new Date(Long.parseLong(date));
        }
        catch (NumberFormatException ignored) {
            if (date.endsWith("Z")) {
                date = date.substring(0, date.length() - 1) + "+0000";
            }
            try {
                return ISO8601.parse(date);
            }
            catch (ParseException ignored2) {
                try {
                    return RFC2822.parse(date);
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
        }
    }
}

