/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.ui.client.adapters.ValueBoxEditor;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.AutoDirectionHandler;
import com.google.gwt.i18n.client.BidiPolicy;
import com.google.gwt.i18n.client.BidiUtils;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.shared.DirectionEstimator;
import com.google.gwt.i18n.shared.HasDirectionEstimator;
import com.google.gwt.text.shared.Parser;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.impl.TextBoxImpl;
import java.text.ParseException;

public class ValueBoxBase<T>
extends FocusWidget
implements HasChangeHandlers,
HasName,
HasDirectionEstimator,
HasValue<T>,
HasText,
AutoDirectionHandler.Target,
IsEditor<ValueBoxEditor<T>> {
    private static TextBoxImpl impl = (TextBoxImpl)GWT.create(TextBoxImpl.class);
    private final AutoDirectionHandler autoDirHandler = AutoDirectionHandler.addTo((AutoDirectionHandler.Target)this, BidiPolicy.isBidiEnabled());
    private final Parser<T> parser;
    private final Renderer<T> renderer;
    private ValueBoxEditor<T> editor;
    private Event currentEvent;
    private boolean valueChangeHandlerInitialized;

    protected ValueBoxBase(Element elem, Renderer<T> renderer, Parser<T> parser) {
        super(elem);
        this.renderer = renderer;
        this.parser = parser;
    }

    @Override
    public HandlerRegistration addChangeHandler(ChangeHandler handler) {
        return this.addDomHandler(handler, ChangeEvent.getType());
    }

    @Override
    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<T> handler) {
        if (!this.valueChangeHandlerInitialized) {
            this.valueChangeHandlerInitialized = true;
            this.addChangeHandler(new ChangeHandler(){

                @Override
                public void onChange(ChangeEvent event) {
                    ValueChangeEvent.fire(ValueBoxBase.this, ValueBoxBase.this.getValue());
                }
            });
        }
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    @Override
    public ValueBoxEditor<T> asEditor() {
        if (this.editor == null) {
            this.editor = ValueBoxEditor.of(this);
        }
        return this.editor;
    }

    public void cancelKey() {
        if (this.currentEvent != null) {
            this.currentEvent.preventDefault();
        }
    }

    public int getCursorPos() {
        return impl.getCursorPos(this.getElement());
    }

    @Override
    public HasDirection.Direction getDirection() {
        return BidiUtils.getDirectionOnElement(this.getElement());
    }

    @Override
    public DirectionEstimator getDirectionEstimator() {
        return this.autoDirHandler.getDirectionEstimator();
    }

    @Override
    public String getName() {
        return this.getElement().getPropertyString("name");
    }

    public String getSelectedText() {
        int start = this.getCursorPos();
        if (start < 0) {
            return "";
        }
        int length = this.getSelectionLength();
        return this.getText().substring(start, start + length);
    }

    public int getSelectionLength() {
        return impl.getSelectionLength(this.getElement());
    }

    @Override
    public String getText() {
        return this.getElement().getPropertyString("value");
    }

    @Override
    public T getValue() {
        try {
            return this.getValueOrThrow();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public T getValueOrThrow() throws ParseException {
        String text = this.getText();
        T parseResult = this.parser.parse(text);
        if ("".equals(text)) {
            return null;
        }
        return parseResult;
    }

    public boolean isReadOnly() {
        return this.getElement().getPropertyBoolean("readOnly");
    }

    @Override
    public void onBrowserEvent(Event event) {
        int type = DOM.eventGetType(event);
        if ((type & 0x380) != 0) {
            this.currentEvent = event;
            super.onBrowserEvent(event);
            this.currentEvent = null;
        } else {
            super.onBrowserEvent(event);
        }
    }

    @Deprecated
    public void removeChangeListener(ChangeListener listener) {
        ListenerWrapper.WrappedChangeListener.remove(this, listener);
    }

    public void selectAll() {
        int length = this.getText().length();
        if (length > 0) {
            this.setSelectionRange(0, length);
        }
    }

    public void setAlignment(TextAlignment align) {
        this.getElement().getStyle().setProperty("textAlign", align.getTextAlignString());
    }

    public void setCursorPos(int pos) {
        this.setSelectionRange(pos, 0);
    }

    @Override
    public void setDirection(HasDirection.Direction direction) {
        BidiUtils.setDirectionOnElement(this.getElement(), direction);
    }

    @Override
    public void setDirectionEstimator(boolean enabled) {
        this.autoDirHandler.setDirectionEstimator(enabled);
    }

    @Override
    public void setDirectionEstimator(DirectionEstimator directionEstimator) {
        this.autoDirHandler.setDirectionEstimator(directionEstimator);
    }

    @Deprecated
    public void setKey(char key) {
        if (this.currentEvent != null) {
            DOM.eventSetKeyCode(this.currentEvent, key);
        }
    }

    @Override
    public void setName(String name) {
        this.getElement().setPropertyString("name", name);
    }

    public void setReadOnly(boolean readOnly) {
        this.getElement().setPropertyBoolean("readOnly", readOnly);
        String readOnlyStyle = "readonly";
        if (readOnly) {
            this.addStyleDependentName(readOnlyStyle);
        } else {
            this.removeStyleDependentName(readOnlyStyle);
        }
    }

    public void setSelectionRange(int pos, int length) {
        if (!this.isAttached()) {
            return;
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length must be a positive integer. Length: " + length);
        }
        if (pos < 0 || length + pos > this.getText().length()) {
            throw new IndexOutOfBoundsException("From Index: " + pos + "  To Index: " + (pos + length) + "  Text Length: " + this.getText().length());
        }
        impl.setSelectionRange(this.getElement(), pos, length);
    }

    @Override
    public void setText(String text) {
        this.getElement().setPropertyString("value", text != null ? text : "");
        this.autoDirHandler.refreshDirection();
    }

    @Override
    public void setValue(T value) {
        this.setValue(value, false);
    }

    @Override
    public void setValue(T value, boolean fireEvents) {
        Object oldValue = fireEvents ? (Object)this.getValue() : null;
        this.setText(this.renderer.render(value));
        if (fireEvents) {
            T newValue = this.getValue();
            ValueChangeEvent.fireIfNotEqual(this, oldValue, newValue);
        }
    }

    public String getPlaceholder() {
        return this.getElement().getPropertyString("placeholder");
    }

    public void setPlaceholder(String placeholder) {
        this.getElement().setPropertyString("placeholder", placeholder == null ? "" : placeholder);
    }

    protected TextBoxImpl getImpl() {
        return impl;
    }

    @Override
    protected void onLoad() {
        super.onLoad();
        this.autoDirHandler.refreshDirection();
    }

    public static enum TextAlignment {
        CENTER{

            @Override
            String getTextAlignString() {
                return "center";
            }
        }
        ,
        JUSTIFY{

            @Override
            String getTextAlignString() {
                return "justify";
            }
        }
        ,
        LEFT{

            @Override
            String getTextAlignString() {
                return "left";
            }
        }
        ,
        RIGHT{

            @Override
            String getTextAlignString() {
                return "right";
            }
        };


        abstract String getTextAlignString();
    }
}

