/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.event.dom.client;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.HasNativeEvent;
import com.google.gwt.event.dom.client.PrivateMap;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HasHandlers;
import java.util.ArrayList;
import java.util.List;

public abstract class DomEvent<H extends EventHandler>
extends GwtEvent<H>
implements HasNativeEvent {
    private static PrivateMap<List<Type<?>>> registered;
    private NativeEvent nativeEvent;
    private Element relativeElem;

    public static void fireNativeEvent(NativeEvent nativeEvent, HasHandlers handlerSource) {
        DomEvent.fireNativeEvent(nativeEvent, handlerSource, null);
    }

    public static void fireNativeEvent(NativeEvent nativeEvent, HasHandlers handlerSource, Element relativeElem) {
        List<Type<?>> types;
        assert (nativeEvent != null) : "nativeEvent must not be null";
        if (registered != null && (types = registered.unsafeGet(nativeEvent.getType())) != null) {
            for (Type<?> type : types) {
                NativeEvent currentNative = ((Type)type).flyweight.nativeEvent;
                Element currentRelativeElem = ((Type)type).flyweight.relativeElem;
                ((Type)type).flyweight.setNativeEvent(nativeEvent);
                ((Type)type).flyweight.setRelativeElement(relativeElem);
                handlerSource.fireEvent(((Type)type).flyweight);
                ((Type)type).flyweight.setNativeEvent(currentNative);
                ((Type)type).flyweight.setRelativeElement(currentRelativeElem);
            }
        }
    }

    static void init() {
        registered = new PrivateMap();
    }

    @Override
    public abstract Type<H> getAssociatedType();

    @Override
    public final NativeEvent getNativeEvent() {
        this.assertLive();
        return this.nativeEvent;
    }

    public final Element getRelativeElement() {
        this.assertLive();
        return this.relativeElem;
    }

    public void preventDefault() {
        this.assertLive();
        if (this.nativeEvent != null) {
            this.nativeEvent.preventDefault();
        }
    }

    public final void setNativeEvent(NativeEvent nativeEvent) {
        this.nativeEvent = nativeEvent;
    }

    public void setRelativeElement(Element relativeElem) {
        this.relativeElem = relativeElem;
    }

    public void stopPropagation() {
        this.assertLive();
        this.nativeEvent.stopPropagation();
    }

    public static class Type<H extends EventHandler>
    extends GwtEvent.Type<H> {
        private DomEvent<H> flyweight;
        private String name;

        public Type(String eventName, DomEvent<H> flyweight) {
            ArrayList<Type> types;
            this.flyweight = flyweight;
            if (registered == null) {
                DomEvent.init();
            }
            if ((types = (ArrayList<Type>)registered.unsafeGet(eventName)) == null) {
                types = new ArrayList<Type>();
                registered.unsafePut(eventName, types);
            }
            types.add(this);
            this.name = eventName;
        }

        public String getName() {
            return this.name;
        }
    }
}

