/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.debug;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;

public class JsoInspector {
    public static Object convertToInspectableObject(Object jso) {
        try {
            JsoBoxer boxer = (JsoBoxer)jso;
            return boxer.box();
        }
        catch (Throwable t) {
            GWT.log("GWT could not inspect the JavaScriptObject.", t);
            return "ERROR: Could not inspect the JavaScriptObject, see GWT log for details.";
        }
    }

    private static class JsoBoxer
    extends JavaScriptObject {
        protected JsoBoxer() {
        }

        public final native Object box();
    }

    public static class JsoProperty
    implements Comparable<JsoProperty> {
        public final String key;
        public final Object value;
        public final boolean isOwnProperty;

        private JsoProperty(String key, Object value, boolean isOwnProperty) {
            this.key = key;
            this.value = value;
            this.isOwnProperty = isOwnProperty;
        }

        @Override
        public int compareTo(JsoProperty o) {
            int keyComparison = this.key.compareTo(o.key);
            return keyComparison != 0 ? keyComparison : this.value.hashCode() - o.value.hashCode();
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            if (this.isOwnProperty) {
                s.append('*');
            }
            s.append(this.key).append(": ");
            if (this.value instanceof String) {
                s.append('\"').append(this.value).append('\"');
            } else {
                s.append(this.value);
            }
            return s.toString();
        }
    }
}

