/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.impl;

import com.google.gwt.editor.client.EditorContext;
import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.editor.client.EditorVisitor;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.ValueAwareEditor;
import com.google.gwt.editor.client.impl.AbstractEditorDelegate;
import java.util.Stack;

class Flusher
extends EditorVisitor {
    private final Stack<AbstractEditorDelegate<?, ?>> delegateStack = new Stack();

    Flusher() {
    }

    public <Q> void endVisit(EditorContext<Q> ctx) {
        ValueAwareEditor<Q> asValue = ctx.asValueAwareEditor();
        AbstractEditorDelegate<?, ?> delegate = ctx.getEditorDelegate() == null ? this.delegateStack.peek() : this.delegateStack.pop();
        assert (delegate != null);
        if (asValue != null && delegate.shouldFlush()) {
            asValue.flush();
        }
        LeafValueEditor<Q> asLeaf = ctx.asLeafValueEditor();
        if (delegate.shouldFlush() && asLeaf != null && ctx.canSetInModel()) {
            ctx.setInModel(asLeaf.getValue());
        }
    }

    public <Q> boolean visit(EditorContext<Q> ctx) {
        EditorDelegate<Q> editorDelegate = ctx.getEditorDelegate();
        if (editorDelegate != null) {
            this.delegateStack.push((AbstractEditorDelegate)editorDelegate);
        }
        return true;
    }
}

