/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.server;

import com.google.gwt.core.server.StackTraceDeobfuscator;
import com.google.gwt.logging.server.RemoteLoggingServiceUtil;
import com.google.gwt.logging.shared.RemoteLoggingService;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class RemoteLoggingServiceImpl
extends RemoteServiceServlet
implements RemoteLoggingService {
    private static Logger logger = Logger.getLogger(RemoteServiceServlet.class.getName());
    private StackTraceDeobfuscator deobfuscator = null;
    private String loggerNameOverride = null;

    @Override
    public final String logOnServer(LogRecord lr) {
        String strongName = this.getPermutationStrongName();
        try {
            RemoteLoggingServiceUtil.logOnServer(lr, strongName, this.deobfuscator, this.loggerNameOverride);
        }
        catch (RemoteLoggingServiceUtil.RemoteLoggingException e) {
            logger.log(Level.SEVERE, "Remote logging failed", e);
            return "Remote logging failed, check stack trace for details.";
        }
        return null;
    }

    public void setLoggerNameOverride(String override) {
        this.loggerNameOverride = override;
    }

    public void setSymbolMapsDirectory(String symbolMapsDir) {
        this.deobfuscator = StackTraceDeobfuscator.fromFileSystem(symbolMapsDir);
    }
}

