/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssExternalSelectors;
import com.google.gwt.resources.css.ast.CssSelector;
import com.google.gwt.resources.css.ast.CssStylesheet;
import com.google.gwt.resources.css.ast.CssVisitor;
import com.google.gwt.resources.rg.CssResourceGenerator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;

public class ExtractClassNamesVisitor
extends CssVisitor {
    private final Set<String> found = new HashSet<String>();
    private final SortedSet<String> ignoredPrefixes;

    public static Set<String> exec(CssStylesheet sheet) {
        return ExtractClassNamesVisitor.exec(sheet, new JClassType[0]);
    }

    public static Set<String> exec(CssStylesheet sheet, JClassType ... imports) {
        TreeSet<String> ignoredPrefixes = new TreeSet<String>();
        for (JClassType clazz : imports) {
            String prefix = CssResourceGenerator.getImportPrefix(clazz);
            ignoredPrefixes.add(prefix);
        }
        ExtractClassNamesVisitor v = new ExtractClassNamesVisitor(ignoredPrefixes);
        v.accept(sheet);
        return v.found;
    }

    ExtractClassNamesVisitor(SortedSet<String> ignoredPrefixes) {
        this.ignoredPrefixes = ignoredPrefixes;
    }

    @Override
    public void endVisit(CssExternalSelectors x, Context ctx) {
        this.addAll(x.getClasses());
    }

    @Override
    public void endVisit(CssSelector x, Context ctx) {
        Matcher m = CssSelector.CLASS_SELECTOR_PATTERN.matcher(x.getSelector());
        while (m.find()) {
            this.add(m.group(1));
        }
    }

    Set<String> getFoundClasses() {
        return this.found;
    }

    private void add(String selector) {
        SortedSet<String> headSet = this.ignoredPrefixes.headSet(selector);
        if (headSet.isEmpty() || !selector.startsWith(headSet.last())) {
            this.found.add(selector);
        }
    }

    private void addAll(Iterable<String> selectors) {
        for (String selector : selectors) {
            this.add(selector);
        }
    }
}

