/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import com.google.gwt.resources.gss.ast.CssDotPathNode;
import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCommentNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionArgumentsNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPropertyNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPropertyValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.List;

public class ImageSpriteCreator
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final String SPRITE_PROPERTY_NAME = "gwt-sprite";
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private final ResourceContext context;
    private final MethodByPathHelper methodByPathHelper;
    private final JClassType imageResourceType;
    private final String resourceThisPrefix;

    public ImageSpriteCreator(MutatingVisitController visitController, ResourceContext context, ErrorManager errorManager) {
        this(visitController, context, errorManager, new MethodByPathHelperImpl());
    }

    @VisibleForTesting
    ImageSpriteCreator(MutatingVisitController visitController, ResourceContext context, ErrorManager errorManager, MethodByPathHelper methodByPathHelper) {
        this.visitController = visitController;
        this.errorManager = errorManager;
        this.context = context;
        this.methodByPathHelper = methodByPathHelper;
        this.imageResourceType = context.getGeneratorContext().getTypeOracle().findType(ImageResource.class.getName());
        this.resourceThisPrefix = context.getImplementationSimpleSourceName() + ".this";
    }

    public boolean enterDeclaration(CssDeclarationNode declaration) {
        String propertyName = declaration.getPropertyName().getPropertyName();
        if (SPRITE_PROPERTY_NAME.equals(propertyName)) {
            this.createSprite(declaration);
            return true;
        }
        return super.enterDeclaration(declaration);
    }

    private void createSprite(CssDeclarationNode declaration) {
        String repeatText;
        JMethod imageMethod;
        List valuesNodes = declaration.getPropertyValue().getChildren();
        if (valuesNodes.size() != 1) {
            this.errorManager.report(new GssError("gwt-sprite must have exactly one value", declaration.getSourceCodeLocation()));
            return;
        }
        String imageResource = ((CssValueNode)valuesNodes.get(0)).getValue();
        try {
            imageMethod = this.methodByPathHelper.getMethodByPath(this.context, this.getPathElement(imageResource), (JType)this.imageResourceType);
        }
        catch (NotFoundException e) {
            this.errorManager.report(new GssError("Unable to find ImageResource method " + imageResource + " in " + this.context.getClientBundleType().getQualifiedSourceName() + " : " + e.getMessage(), declaration.getSourceCodeLocation()));
            return;
        }
        ImageResource.ImageOptions options = (ImageResource.ImageOptions)imageMethod.getAnnotation(ImageResource.ImageOptions.class);
        ImageResource.RepeatStyle repeatStyle = options != null ? options.repeatStyle() : ImageResource.RepeatStyle.None;
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        SourceCodeLocation sourceCodeLocation = declaration.getSourceCodeLocation();
        switch (repeatStyle) {
            case None: {
                repeatText = " no-repeat";
                listBuilder.add(this.buildHeightDeclaration(imageResource, sourceCodeLocation));
                listBuilder.add(this.buildWidthDeclaration(imageResource, sourceCodeLocation));
                break;
            }
            case Horizontal: {
                repeatText = " repeat-x";
                listBuilder.add(this.buildHeightDeclaration(imageResource, sourceCodeLocation));
                break;
            }
            case Vertical: {
                repeatText = " repeat-y";
                listBuilder.add(this.buildWidthDeclaration(imageResource, sourceCodeLocation));
                break;
            }
            case Both: {
                repeatText = " repeat";
                break;
            }
            default: {
                this.errorManager.report(new GssError("Unknown repeatStyle " + (Object)((Object)repeatStyle), sourceCodeLocation));
                return;
            }
        }
        listBuilder.add(this.buildOverflowDeclaration(sourceCodeLocation));
        listBuilder.add(this.buildBackgroundDeclaration(imageResource, repeatText, sourceCodeLocation));
        this.visitController.replaceCurrentBlockChildWith((List)((Object)listBuilder.build()), false);
    }

    private CssDeclarationNode buildBackgroundDeclaration(String imageResource, String repeatText, SourceCodeLocation location) {
        CssFunctionNode urlFunction = new CssFunctionNode(CssFunctionNode.Function.byName((String)"url"), location);
        CssDotPathNode imageUrl = new CssDotPathNode(this.resourceThisPrefix, imageResource + ".getSafeUri" + ".asString", null, null, location);
        CssFunctionArgumentsNode urlFunctionArguments = new CssFunctionArgumentsNode();
        urlFunctionArguments.addChildToBack((CssNode)imageUrl);
        urlFunction.setArguments(urlFunctionArguments);
        CssDotPathNode left = new CssDotPathNode(this.resourceThisPrefix, imageResource + ".getLeft", "-", "px", location);
        CssDotPathNode top = new CssDotPathNode(this.resourceThisPrefix, imageResource + ".getTop", "-", "px", location);
        CssLiteralNode repeat = new CssLiteralNode(repeatText, location);
        CssPropertyNode propertyNode = new CssPropertyNode("background", location);
        CssPropertyValueNode propertyValueNode = new CssPropertyValueNode(ImmutableList.of(urlFunction, left, top, repeat));
        propertyValueNode.setSourceCodeLocation(location);
        return this.createDeclarationNode(propertyNode, propertyValueNode, location, true);
    }

    private CssDeclarationNode buildHeightDeclaration(String imageResource, SourceCodeLocation location) {
        CssPropertyNode propertyNode = new CssPropertyNode("height", location);
        CssDotPathNode valueNode = new CssDotPathNode(this.resourceThisPrefix, imageResource + ".getHeight", null, "px", location);
        CssPropertyValueNode propertyValueNode = new CssPropertyValueNode(ImmutableList.of(valueNode));
        return this.createDeclarationNode(propertyNode, propertyValueNode, location, true);
    }

    private CssDeclarationNode buildOverflowDeclaration(SourceCodeLocation location) {
        CssPropertyNode propertyNode = new CssPropertyNode("overflow", location);
        CssLiteralNode valueNode = new CssLiteralNode("hidden", location);
        CssPropertyValueNode propertyValueNode = new CssPropertyValueNode(ImmutableList.of(valueNode));
        return this.createDeclarationNode(propertyNode, propertyValueNode, location, true);
    }

    private CssDeclarationNode buildWidthDeclaration(String imageResource, SourceCodeLocation location) {
        CssPropertyNode propertyNode = new CssPropertyNode("width", location);
        CssDotPathNode valueNode = new CssDotPathNode(this.resourceThisPrefix, imageResource + ".getWidth", null, "px", location);
        CssPropertyValueNode propertyValueNode = new CssPropertyValueNode(ImmutableList.of(valueNode));
        return this.createDeclarationNode(propertyNode, propertyValueNode, location, true);
    }

    private List<String> getPathElement(String imageResourcePath) {
        return Lists.newArrayList(imageResourcePath.split("\\."));
    }

    private CssDeclarationNode createDeclarationNode(CssPropertyNode propertyNode, CssPropertyValueNode propertyValueNode, SourceCodeLocation location, boolean useAlternate) {
        CssDeclarationNode replaceNode = new CssDeclarationNode(propertyNode, propertyValueNode);
        replaceNode.setSourceCodeLocation(location);
        if (useAlternate) {
            replaceNode.setComments(ImmutableList.of(new CssCommentNode("/* @alternate */", location)));
        }
        return replaceNode;
    }

    public void runPass() {
        this.visitController.startVisit((CssTreeVisitor)this);
    }

    private static class MethodByPathHelperImpl
    implements MethodByPathHelper {
        private MethodByPathHelperImpl() {
        }

        @Override
        public JMethod getMethodByPath(ResourceContext context, List<String> pathElements, JType expectedReturnType) throws NotFoundException {
            return ResourceGeneratorUtil.getMethodByPath(context.getClientBundleType(), pathElements, expectedReturnType);
        }
    }

    @VisibleForTesting
    static interface MethodByPathHelper {
        public JMethod getMethodByPath(ResourceContext var1, List<String> var2, JType var3) throws NotFoundException;
    }
}

