/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

public abstract class AbstractSerializationStream {
    public static final int DEFAULT_FLAGS = 0;
    public static final char RPC_SEPARATOR_CHAR = '|';
    public static final int SERIALIZATION_STREAM_MAX_VERSION = 8;
    public static final int SERIALIZATION_STREAM_VERSION = 7;
    public static final int SERIALIZATION_STREAM_MIN_VERSION = 5;
    public static final int SERIALIZATION_STREAM_JSON_VERSION = 8;
    public static final int FLAG_ELIDE_TYPE_NAMES = 1;
    public static final int FLAG_RPC_TOKEN_INCLUDED = 2;
    public static final int VALID_FLAGS_MASK = 3;
    private int flags = 0;
    private int version = 7;

    public final void addFlags(int flags) {
        this.flags |= flags;
    }

    public final boolean areFlagsValid() {
        return ((this.flags | 3) ^ 3) == 0;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final int getVersion() {
        return this.version;
    }

    public final boolean hasFlags(int flags) {
        return (this.getFlags() & flags) == flags;
    }

    public final void setFlags(int flags) {
        this.flags = flags;
    }

    protected final void setVersion(int version) {
        this.version = version;
    }

    static long longFromBase64(String value) {
        int pos = 0;
        long longVal = AbstractSerializationStream.base64Value(value.charAt(pos++));
        int len = value.length();
        while (pos < len) {
            longVal <<= 6;
            longVal |= (long)AbstractSerializationStream.base64Value(value.charAt(pos++));
        }
        return longVal;
    }

    static String longToBase64(long value) {
        int low = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        int high = (int)(value >> 32);
        StringBuilder sb = new StringBuilder();
        boolean haveNonZero = AbstractSerializationStream.base64Append(sb, high >> 28 & 0xF, false);
        haveNonZero = AbstractSerializationStream.base64Append(sb, high >> 22 & 0x3F, haveNonZero);
        haveNonZero = AbstractSerializationStream.base64Append(sb, high >> 16 & 0x3F, haveNonZero);
        haveNonZero = AbstractSerializationStream.base64Append(sb, high >> 10 & 0x3F, haveNonZero);
        haveNonZero = AbstractSerializationStream.base64Append(sb, high >> 4 & 0x3F, haveNonZero);
        int v = (high & 0xF) << 2 | low >> 30 & 3;
        haveNonZero = AbstractSerializationStream.base64Append(sb, v, haveNonZero);
        haveNonZero = AbstractSerializationStream.base64Append(sb, low >> 24 & 0x3F, haveNonZero);
        haveNonZero = AbstractSerializationStream.base64Append(sb, low >> 18 & 0x3F, haveNonZero);
        haveNonZero = AbstractSerializationStream.base64Append(sb, low >> 12 & 0x3F, haveNonZero);
        AbstractSerializationStream.base64Append(sb, low >> 6 & 0x3F, haveNonZero);
        AbstractSerializationStream.base64Append(sb, low & 0x3F, true);
        return sb.toString();
    }

    private static boolean base64Append(StringBuilder sb, int digit, boolean haveNonZero) {
        if (digit > 0) {
            haveNonZero = true;
        }
        if (haveNonZero) {
            int c = digit < 26 ? 65 + digit : (digit < 52 ? 97 + digit - 26 : (digit < 62 ? 48 + digit - 52 : (digit == 62 ? 36 : 95)));
            sb.append((char)c);
        }
        return haveNonZero;
    }

    private static int base64Value(char digit) {
        if (digit >= 'A' && digit <= 'Z') {
            return digit - 65;
        }
        if (digit >= 'a') {
            return digit - 97 + 26;
        }
        if (digit >= '0' && digit <= '9') {
            return digit - 48 + 52;
        }
        if (digit == '$') {
            return 62;
        }
        return 63;
    }
}

