/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "bg" locale.
 */
public class LocalizedNamesImpl_bg extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "BG",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "BQ",
        "CW",
        "SS",
        "SX",
        "AU",
        "AT",
        "AZ",
        "AX",
        "AL",
        "DZ",
        "AS",
        "AO",
        "AI",
        "AD",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AF",
        "BD",
        "BB",
        "BS",
        "BH",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BO",
        "BA",
        "BW",
        "BR",
        "VG",
        "IO",
        "BN",
        "CI",
        "BF",
        "BI",
        "BT",
        "BG",
        "VU",
        "VE",
        "VN",
        "GA",
        "GM",
        "GH",
        "GP",
        "GT",
        "GY",
        "GN",
        "GW",
        "DE",
        "GI",
        "GD",
        "GL",
        "GE",
        "GU",
        "GR",
        "DK",
        "CD",
        "DJ",
        "DG",
        "DM",
        "DO",
        "EU",
        "EG",
        "EC",
        "GQ",
        "SV",
        "ER",
        "EE",
        "ET",
        "ZM",
        "EH",
        "ZW",
        "IL",
        "TL",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "ES",
        "IT",
        "YE",
        "JO",
        "CV",
        "KZ",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "QA",
        "KE",
        "CY",
        "KG",
        "KI",
        "CN",
        "CC",
        "CO",
        "KM",
        "CG",
        "FX",
        "KR",
        "CR",
        "CU",
        "KW",
        "LV",
        "LS",
        "LR",
        "LY",
        "LB",
        "LT",
        "LI",
        "LU",
        "MR",
        "MU",
        "MG",
        "MO",
        "MK",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MH",
        "YT",
        "MX",
        "MM",
        "FM",
        "MZ",
        "MD",
        "MC",
        "MN",
        "MS",
        "NA",
        "LA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NZ",
        "NC",
        "NO",
        "GG",
        "JE",
        "AE",
        "GB",
        "QO",
        "OM",
        "BV",
        "AC",
        "CK",
        "IM",
        "TC",
        "CP",
        "CX",
        "NF",
        "HM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "RE",
        "RW",
        "RO",
        "RU",
        "WS",
        "SM",
        "ST",
        "SA",
        "US",
        "VI",
        "UM",
        "SJ",
        "SH",
        "VA",
        "KP",
        "MP",
        "BL",
        "VC",
        "KN",
        "LC",
        "MF",
        "SC",
        "SN",
        "PM",
        "EA",
        "SL",
        "SG",
        "SY",
        "SK",
        "SI",
        "SB",
        "SO",
        "SZ",
        "SD",
        "SR",
        "RS",
        "CS",
        "TJ",
        "TW",
        "TH",
        "TZ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "TM",
        "TR",
        "UG",
        "UZ",
        "UA",
        "HU",
        "WF",
        "UY",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "GF",
        "PF",
        "TF",
        "HT",
        "NL",
        "AN",
        "HK",
        "HN",
        "HR",
        "CF",
        "TD",
        "ME",
        "CZ",
        "CL",
        "CH",
        "SE",
        "LK",
        "ZA",
        "GS",
        "JM",
        "JP",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Земята");
    namesMap.put("002", "Африка");
    namesMap.put("003", "Северноамерикански континент");
    namesMap.put("005", "Южна Америка");
    namesMap.put("009", "Океания");
    namesMap.put("011", "Западна Афирка");
    namesMap.put("013", "Централна Америка");
    namesMap.put("014", "Източна Африка");
    namesMap.put("015", "Северна Африка");
    namesMap.put("017", "Централна Африка");
    namesMap.put("018", "Южноафрикански регион");
    namesMap.put("019", "Америка");
    namesMap.put("021", "Северна Америка");
    namesMap.put("029", "Карибски о-ви");
    namesMap.put("030", "Източна Азия");
    namesMap.put("034", "Южна Азия");
    namesMap.put("035", "Югоизточна Азия");
    namesMap.put("039", "Южна Европа");
    namesMap.put("053", "Австралия и Нова Зеландия");
    namesMap.put("054", "Меланезия");
    namesMap.put("057", "Микронезия");
    namesMap.put("061", "Полинезия");
    namesMap.put("142", "Азия");
    namesMap.put("143", "Централна Азия");
    namesMap.put("145", "Западна Азия");
    namesMap.put("150", "Европа");
    namesMap.put("151", "Източна Европа");
    namesMap.put("154", "Северна Европа");
    namesMap.put("155", "Западна Европа");
    namesMap.put("419", "Латинска Америка");
    namesMap.put("AC", "Остров Възнесение");
    namesMap.put("AD", "Андора");
    namesMap.put("AE", "Обединени арабски емирства");
    namesMap.put("AF", "Афганистан");
    namesMap.put("AG", "Антигуа и Барбуда");
    namesMap.put("AI", "Ангуила");
    namesMap.put("AL", "Албания");
    namesMap.put("AM", "Армения");
    namesMap.put("AN", "Холандски Антили");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктика");
    namesMap.put("AR", "Аржентина");
    namesMap.put("AS", "Американско Самоа");
    namesMap.put("AT", "Австрия");
    namesMap.put("AU", "Австралия");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аландски о-ви");
    namesMap.put("AZ", "Азербайджан");
    namesMap.put("BA", "Босна и Херцеговина");
    namesMap.put("BB", "Барбадос");
    namesMap.put("BD", "Бангладеш");
    namesMap.put("BE", "Белгия");
    namesMap.put("BF", "Буркина Фасо");
    namesMap.put("BG", "България");
    namesMap.put("BH", "Бахрейн");
    namesMap.put("BI", "Бурунди");
    namesMap.put("BJ", "Бенин");
    namesMap.put("BL", "Сейнт Бартоломей");
    namesMap.put("BM", "Бермуда");
    namesMap.put("BN", "Бруней Дарусалам");
    namesMap.put("BO", "Боливия");
    namesMap.put("BR", "Бразилия");
    namesMap.put("BS", "Бахами");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "Остров Буве");
    namesMap.put("BW", "Ботсуана");
    namesMap.put("BY", "Беларус");
    namesMap.put("BZ", "Белиз");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Кокосови [Кийлинг] острови");
    namesMap.put("CD", "Демократична република Конго");
    namesMap.put("CF", "Централноафриканска Република");
    namesMap.put("CG", "Конго");
    namesMap.put("CH", "Швейцария");
    namesMap.put("CI", "Бряг на слоновата кост");
    namesMap.put("CK", "Острови Кук");
    namesMap.put("CL", "Чили");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Китай");
    namesMap.put("CO", "Колумбия");
    namesMap.put("CP", "Остров Клипертон");
    namesMap.put("CR", "Коста Рика");
    namesMap.put("CS", "Сърбия и Черна гора");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Кабо Верде");
    namesMap.put("CX", "Остров Кристмас");
    namesMap.put("CY", "Кипър");
    namesMap.put("CZ", "Чешка република");
    namesMap.put("DE", "Германия");
    namesMap.put("DG", "Диего Гарсия");
    namesMap.put("DJ", "Джибути");
    namesMap.put("DK", "Дания");
    namesMap.put("DM", "Доминика");
    namesMap.put("DO", "Доминиканска република");
    namesMap.put("DZ", "Алжир");
    namesMap.put("EA", "Сеута и Мелия");
    namesMap.put("EC", "Еквадор");
    namesMap.put("EE", "Естония");
    namesMap.put("EG", "Египет");
    namesMap.put("EH", "Западна Сахара");
    namesMap.put("ER", "Еритрея");
    namesMap.put("ES", "Испания");
    namesMap.put("ET", "Етиопия");
    namesMap.put("EU", "Европейски съюз");
    namesMap.put("FI", "Финландия");
    namesMap.put("FJ", "Фиджи");
    namesMap.put("FK", "Фолклендски острови");
    namesMap.put("FM", "Микронезия, Обединени Щати");
    namesMap.put("FO", "Фарьорски острови");
    namesMap.put("FR", "Франция");
    namesMap.put("FX", "Континентална Франция");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Обединено кралство");
    namesMap.put("GD", "Гренада");
    namesMap.put("GE", "Грузия");
    namesMap.put("GF", "Френска Гвиана");
    namesMap.put("GG", "о. Гърнзи");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Гибралтар");
    namesMap.put("GL", "Гренландия");
    namesMap.put("GM", "Гамбия");
    namesMap.put("GN", "Гвинея");
    namesMap.put("GP", "Гваделупа");
    namesMap.put("GQ", "Екваториална Гвинея");
    namesMap.put("GR", "Гърция");
    namesMap.put("GS", "Южна Джорджия и Южни Сандвичеви Острови");
    namesMap.put("GT", "Гватемала");
    namesMap.put("GU", "Гуам");
    namesMap.put("GW", "Гвинея-Бисау");
    namesMap.put("GY", "Гвиана");
    namesMap.put("HK", "Хонг-Конг");
    namesMap.put("HM", "Остров Хърд и Острови Макдоналд");
    namesMap.put("HN", "Хондурас");
    namesMap.put("HR", "Хърватска");
    namesMap.put("HT", "Хаити");
    namesMap.put("HU", "Унгария");
    namesMap.put("IC", "Канарски острови");
    namesMap.put("ID", "Индонезия");
    namesMap.put("IE", "Ирландия");
    namesMap.put("IL", "Израел");
    namesMap.put("IM", "Острови Ман");
    namesMap.put("IN", "Индия");
    namesMap.put("IO", "Британски територии в Индийския океан");
    namesMap.put("IQ", "Ирак");
    namesMap.put("IR", "Иран, Ислямска република");
    namesMap.put("IS", "Исландия");
    namesMap.put("IT", "Италия");
    namesMap.put("JE", "о. Джързи");
    namesMap.put("JM", "Ямайка");
    namesMap.put("JO", "Йордания");
    namesMap.put("JP", "Япония");
    namesMap.put("KE", "Кения");
    namesMap.put("KG", "Киргизстан");
    namesMap.put("KH", "Камбоджа");
    namesMap.put("KI", "Кирибати");
    namesMap.put("KM", "Комори");
    namesMap.put("KN", "Сейнт Китс и Невис");
    namesMap.put("KP", "Северна Корея");
    namesMap.put("KR", "Корея, Южна");
    namesMap.put("KW", "Кувейт");
    namesMap.put("KY", "Кайманови острови");
    namesMap.put("KZ", "Казахстан");
    namesMap.put("LA", "Народна демократична република Лаос");
    namesMap.put("LB", "Ливан");
    namesMap.put("LC", "Сейнт Лусия");
    namesMap.put("LI", "Лихтенщайн");
    namesMap.put("LK", "Шри Ланка");
    namesMap.put("LR", "Либерия");
    namesMap.put("LS", "Лесото");
    namesMap.put("LT", "Литва");
    namesMap.put("LU", "Люксембург");
    namesMap.put("LV", "Латвия");
    namesMap.put("LY", "Либийска арабска джамахирия");
    namesMap.put("MA", "Мароко");
    namesMap.put("MC", "Монако");
    namesMap.put("MD", "Молдова, Република");
    namesMap.put("ME", "Черна гора");
    namesMap.put("MF", "Сейнт Мартин");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршалови острови");
    namesMap.put("MK", "Македония");
    namesMap.put("ML", "Мали");
    namesMap.put("MM", "Мианмар [Бирма]");
    namesMap.put("MN", "Монголия");
    namesMap.put("MO", "Макао");
    namesMap.put("MP", "Северни Мариански Острови");
    namesMap.put("MQ", "Мартиника");
    namesMap.put("MR", "Мавритания");
    namesMap.put("MS", "Монсерат");
    namesMap.put("MT", "Малта");
    namesMap.put("MU", "Мавриций");
    namesMap.put("MV", "Малдиви");
    namesMap.put("MW", "Малави");
    namesMap.put("MX", "Мексико");
    namesMap.put("MY", "Малайзия");
    namesMap.put("MZ", "Мозамбик");
    namesMap.put("NA", "Намибия");
    namesMap.put("NC", "Нова Каледония");
    namesMap.put("NE", "Нигер");
    namesMap.put("NF", "Остров Норфолк");
    namesMap.put("NG", "Нигерия");
    namesMap.put("NI", "Никарагуа");
    namesMap.put("NL", "Холандия");
    namesMap.put("NO", "Норвегия");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ниуе");
    namesMap.put("NZ", "Нова Зеландия");
    namesMap.put("OM", "Оман");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Френска Полинезия");
    namesMap.put("PG", "Папуа Нова Гвинея");
    namesMap.put("PH", "Филипини");
    namesMap.put("PK", "Пакистан");
    namesMap.put("PL", "Полша");
    namesMap.put("PM", "Сен Пиер и Мигелон");
    namesMap.put("PN", "Питкайрн");
    namesMap.put("PR", "Пуерто Рико");
    namesMap.put("PS", "Палестински територии");
    namesMap.put("PT", "Португалия");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Парагвай");
    namesMap.put("QA", "Катар");
    namesMap.put("QO", "Океания [QO]");
    namesMap.put("RE", "Реюниън");
    namesMap.put("RO", "Румъния");
    namesMap.put("RS", "Сърбия");
    namesMap.put("RU", "Руска федерация");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Саудитска Арабия");
    namesMap.put("SB", "Соломонови острови");
    namesMap.put("SC", "Сейшели");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Швеция");
    namesMap.put("SG", "Сингапур");
    namesMap.put("SH", "Света Елена");
    namesMap.put("SI", "Словения");
    namesMap.put("SJ", "Свалбард и Ян Майен");
    namesMap.put("SK", "Словакия");
    namesMap.put("SL", "Сиера Леоне");
    namesMap.put("SM", "Сан Марино");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Сомалия");
    namesMap.put("SR", "Суринам");
    namesMap.put("ST", "Сао Томе и Принципе");
    namesMap.put("SV", "Ел Салвадор");
    namesMap.put("SY", "Сирийска арабска република");
    namesMap.put("SZ", "Суазиленд");
    namesMap.put("TA", "Тристан да Куня");
    namesMap.put("TC", "Острови Туркс и Кайкос");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Френски южни територии");
    namesMap.put("TG", "Того");
    namesMap.put("TH", "Тайланд");
    namesMap.put("TJ", "Таджикистан");
    namesMap.put("TK", "Токелау");
    namesMap.put("TL", "Източен Тимор");
    namesMap.put("TM", "Туркменистан");
    namesMap.put("TN", "Тунис");
    namesMap.put("TO", "Тонга");
    namesMap.put("TR", "Турция");
    namesMap.put("TT", "Тринидад и Тобаго");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тайван");
    namesMap.put("TZ", "Танзания");
    namesMap.put("UA", "Украйна");
    namesMap.put("UG", "Уганда");
    namesMap.put("UM", "САЩ - външни острови");
    namesMap.put("US", "САЩ");
    namesMap.put("UY", "Уругвай");
    namesMap.put("UZ", "Узбекистан");
    namesMap.put("VA", "Свещено море [Ватиканска държава]");
    namesMap.put("VC", "Сейнт Винсънт и Гренадини");
    namesMap.put("VE", "Венецуела");
    namesMap.put("VG", "Британски Вирджински острони");
    namesMap.put("VI", "САЩ, Вирджински острови");
    namesMap.put("VN", "Виетнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Уолис и Футуна");
    namesMap.put("WS", "Самоа");
    namesMap.put("YE", "Йемен");
    namesMap.put("YT", "Мейот");
    namesMap.put("ZA", "Южна Африка");
    namesMap.put("ZM", "Замбия");
    namesMap.put("ZW", "Зимбабве");
    namesMap.put("ZZ", "Непозната или несъществуваща област");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Земята",
        "002": "Африка",
        "003": "Северноамерикански континент",
        "005": "Южна Америка",
        "009": "Океания",
        "011": "Западна Афирка",
        "013": "Централна Америка",
        "014": "Източна Африка",
        "015": "Северна Африка",
        "017": "Централна Африка",
        "018": "Южноафрикански регион",
        "019": "Америка",
        "021": "Северна Америка",
        "029": "Карибски о-ви",
        "030": "Източна Азия",
        "034": "Южна Азия",
        "035": "Югоизточна Азия",
        "039": "Южна Европа",
        "053": "Австралия и Нова Зеландия",
        "054": "Меланезия",
        "057": "Микронезия",
        "061": "Полинезия",
        "142": "Азия",
        "143": "Централна Азия",
        "145": "Западна Азия",
        "150": "Европа",
        "151": "Източна Европа",
        "154": "Северна Европа",
        "155": "Западна Европа",
        "419": "Латинска Америка",
        "AC": "Остров Възнесение",
        "AD": "Андора",
        "AE": "Обединени арабски емирства",
        "AF": "Афганистан",
        "AG": "Антигуа и Барбуда",
        "AI": "Ангуила",
        "AL": "Албания",
        "AM": "Армения",
        "AN": "Холандски Антили",
        "AO": "Ангола",
        "AQ": "Антарктика",
        "AR": "Аржентина",
        "AS": "Американско Самоа",
        "AT": "Австрия",
        "AU": "Австралия",
        "AW": "Аруба",
        "AX": "Аландски о-ви",
        "AZ": "Азербайджан",
        "BA": "Босна и Херцеговина",
        "BB": "Барбадос",
        "BD": "Бангладеш",
        "BE": "Белгия",
        "BF": "Буркина Фасо",
        "BG": "България",
        "BH": "Бахрейн",
        "BI": "Бурунди",
        "BJ": "Бенин",
        "BL": "Сейнт Бартоломей",
        "BM": "Бермуда",
        "BN": "Бруней Дарусалам",
        "BO": "Боливия",
        "BR": "Бразилия",
        "BS": "Бахами",
        "BT": "Бутан",
        "BV": "Остров Буве",
        "BW": "Ботсуана",
        "BY": "Беларус",
        "BZ": "Белиз",
        "CA": "Канада",
        "CC": "Кокосови [Кийлинг] острови",
        "CD": "Демократична република Конго",
        "CF": "Централноафриканска Република",
        "CG": "Конго",
        "CH": "Швейцария",
        "CI": "Бряг на слоновата кост",
        "CK": "Острови Кук",
        "CL": "Чили",
        "CM": "Камерун",
        "CN": "Китай",
        "CO": "Колумбия",
        "CP": "Остров Клипертон",
        "CR": "Коста Рика",
        "CS": "Сърбия и Черна гора",
        "CU": "Куба",
        "CV": "Кабо Верде",
        "CX": "Остров Кристмас",
        "CY": "Кипър",
        "CZ": "Чешка република",
        "DE": "Германия",
        "DG": "Диего Гарсия",
        "DJ": "Джибути",
        "DK": "Дания",
        "DM": "Доминика",
        "DO": "Доминиканска република",
        "DZ": "Алжир",
        "EA": "Сеута и Мелия",
        "EC": "Еквадор",
        "EE": "Естония",
        "EG": "Египет",
        "EH": "Западна Сахара",
        "ER": "Еритрея",
        "ES": "Испания",
        "ET": "Етиопия",
        "EU": "Европейски съюз",
        "FI": "Финландия",
        "FJ": "Фиджи",
        "FK": "Фолклендски острови",
        "FM": "Микронезия, Обединени Щати",
        "FO": "Фарьорски острови",
        "FR": "Франция",
        "FX": "Континентална Франция",
        "GA": "Габон",
        "GB": "Обединено кралство",
        "GD": "Гренада",
        "GE": "Грузия",
        "GF": "Френска Гвиана",
        "GG": "о. Гърнзи",
        "GH": "Гана",
        "GI": "Гибралтар",
        "GL": "Гренландия",
        "GM": "Гамбия",
        "GN": "Гвинея",
        "GP": "Гваделупа",
        "GQ": "Екваториална Гвинея",
        "GR": "Гърция",
        "GS": "Южна Джорджия и Южни Сандвичеви Острови",
        "GT": "Гватемала",
        "GU": "Гуам",
        "GW": "Гвинея-Бисау",
        "GY": "Гвиана",
        "HK": "Хонг-Конг",
        "HM": "Остров Хърд и Острови Макдоналд",
        "HN": "Хондурас",
        "HR": "Хърватска",
        "HT": "Хаити",
        "HU": "Унгария",
        "IC": "Канарски острови",
        "ID": "Индонезия",
        "IE": "Ирландия",
        "IL": "Израел",
        "IM": "Острови Ман",
        "IN": "Индия",
        "IO": "Британски територии в Индийския океан",
        "IQ": "Ирак",
        "IR": "Иран, Ислямска република",
        "IS": "Исландия",
        "IT": "Италия",
        "JE": "о. Джързи",
        "JM": "Ямайка",
        "JO": "Йордания",
        "JP": "Япония",
        "KE": "Кения",
        "KG": "Киргизстан",
        "KH": "Камбоджа",
        "KI": "Кирибати",
        "KM": "Комори",
        "KN": "Сейнт Китс и Невис",
        "KP": "Северна Корея",
        "KR": "Корея, Южна",
        "KW": "Кувейт",
        "KY": "Кайманови острови",
        "KZ": "Казахстан",
        "LA": "Народна демократична република Лаос",
        "LB": "Ливан",
        "LC": "Сейнт Лусия",
        "LI": "Лихтенщайн",
        "LK": "Шри Ланка",
        "LR": "Либерия",
        "LS": "Лесото",
        "LT": "Литва",
        "LU": "Люксембург",
        "LV": "Латвия",
        "LY": "Либийска арабска джамахирия",
        "MA": "Мароко",
        "MC": "Монако",
        "MD": "Молдова, Република",
        "ME": "Черна гора",
        "MF": "Сейнт Мартин",
        "MG": "Мадагаскар",
        "MH": "Маршалови острови",
        "MK": "Македония",
        "ML": "Мали",
        "MM": "Мианмар [Бирма]",
        "MN": "Монголия",
        "MO": "Макао",
        "MP": "Северни Мариански Острови",
        "MQ": "Мартиника",
        "MR": "Мавритания",
        "MS": "Монсерат",
        "MT": "Малта",
        "MU": "Мавриций",
        "MV": "Малдиви",
        "MW": "Малави",
        "MX": "Мексико",
        "MY": "Малайзия",
        "MZ": "Мозамбик",
        "NA": "Намибия",
        "NC": "Нова Каледония",
        "NE": "Нигер",
        "NF": "Остров Норфолк",
        "NG": "Нигерия",
        "NI": "Никарагуа",
        "NL": "Холандия",
        "NO": "Норвегия",
        "NP": "Непал",
        "NR": "Науру",
        "NU": "Ниуе",
        "NZ": "Нова Зеландия",
        "OM": "Оман",
        "PA": "Панама",
        "PE": "Перу",
        "PF": "Френска Полинезия",
        "PG": "Папуа Нова Гвинея",
        "PH": "Филипини",
        "PK": "Пакистан",
        "PL": "Полша",
        "PM": "Сен Пиер и Мигелон",
        "PN": "Питкайрн",
        "PR": "Пуерто Рико",
        "PS": "Палестински територии",
        "PT": "Португалия",
        "PW": "Палау",
        "PY": "Парагвай",
        "QA": "Катар",
        "QO": "Океания [QO]",
        "RE": "Реюниън",
        "RO": "Румъния",
        "RS": "Сърбия",
        "RU": "Руска федерация",
        "RW": "Руанда",
        "SA": "Саудитска Арабия",
        "SB": "Соломонови острови",
        "SC": "Сейшели",
        "SD": "Судан",
        "SE": "Швеция",
        "SG": "Сингапур",
        "SH": "Света Елена",
        "SI": "Словения",
        "SJ": "Свалбард и Ян Майен",
        "SK": "Словакия",
        "SL": "Сиера Леоне",
        "SM": "Сан Марино",
        "SN": "Сенегал",
        "SO": "Сомалия",
        "SR": "Суринам",
        "ST": "Сао Томе и Принципе",
        "SV": "Ел Салвадор",
        "SY": "Сирийска арабска република",
        "SZ": "Суазиленд",
        "TA": "Тристан да Куня",
        "TC": "Острови Туркс и Кайкос",
        "TD": "Чад",
        "TF": "Френски южни територии",
        "TG": "Того",
        "TH": "Тайланд",
        "TJ": "Таджикистан",
        "TK": "Токелау",
        "TL": "Източен Тимор",
        "TM": "Туркменистан",
        "TN": "Тунис",
        "TO": "Тонга",
        "TR": "Турция",
        "TT": "Тринидад и Тобаго",
        "TV": "Тувалу",
        "TW": "Тайван",
        "TZ": "Танзания",
        "UA": "Украйна",
        "UG": "Уганда",
        "UM": "САЩ - външни острови",
        "US": "САЩ",
        "UY": "Уругвай",
        "UZ": "Узбекистан",
        "VA": "Свещено море [Ватиканска държава]",
        "VC": "Сейнт Винсънт и Гренадини",
        "VE": "Венецуела",
        "VG": "Британски Вирджински острони",
        "VI": "САЩ, Вирджински острови",
        "VN": "Виетнам",
        "VU": "Вануату",
        "WF": "Уолис и Футуна",
        "WS": "Самоа",
        "YE": "Йемен",
        "YT": "Мейот",
        "ZA": "Южна Африка",
        "ZM": "Замбия",
        "ZW": "Зимбабве",
        "ZZ": "Непозната или несъществуваща област"
    };
  }-*/;
}
