/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "de_CH" locale.
 */
public class LocalizedNamesImpl_de_CH extends LocalizedNamesImpl_de {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "EG",
        "AX",
        "AL",
        "DZ",
        "VI",
        "UM",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "GQ",
        "AR",
        "AM",
        "AW",
        "AC",
        "AZ",
        "ET",
        "QO",
        "AU",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "VG",
        "IO",
        "BN",
        "BG",
        "BF",
        "BI",
        "EA",
        "CL",
        "CN",
        "CP",
        "CK",
        "CR",
        "CI",
        "CW",
        "DK",
        "KP",
        "DE",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EC",
        "SV",
        "ER",
        "EE",
        "EU",
        "FK",
        "FO",
        "FJ",
        "FI",
        "FR",
        "TF",
        "GF",
        "PF",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GD",
        "GR",
        "GL",
        "GB",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IM",
        "IL",
        "IT",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "BQ",
        "KZ",
        "QA",
        "KE",
        "KG",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "HR",
        "CU",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MK",
        "MX",
        "FM",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NC",
        "NZ",
        "NI",
        "NL",
        "AN",
        "NE",
        "NG",
        "NU",
        "MP",
        "NF",
        "NO",
        "OM",
        "AT",
        "PK",
        "PS",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PT",
        "PR",
        "KR",
        "MD",
        "RE",
        "RO",
        "RU",
        "RW",
        "SB",
        "ZM",
        "WS",
        "SM",
        "ST",
        "SA",
        "SE",
        "CH",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "SK",
        "SI",
        "SO",
        "HK",
        "MO",
        "ES",
        "LK",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "ZA",
        "SD",
        "GS",
        "SS",
        "SR",
        "SJ",
        "SZ",
        "SY",
        "TJ",
        "TW",
        "TZ",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TD",
        "CZ",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UG",
        "UA",
        "HU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "AE",
        "US",
        "VN",
        "WF",
        "CX",
        "BY",
        "EH",
        "CF",
        "ZW",
        "CY",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("BD", "Bangladesh");
    namesMap.put("BN", "Brunei");
    namesMap.put("BW", "Botswana");
    namesMap.put("BY", "Weissrussland");
    namesMap.put("CV", "Kapverden");
    namesMap.put("DJ", "Djibouti");
    namesMap.put("GB", "Grossbritannien");
    namesMap.put("MH", "Marshall-Inseln");
    namesMap.put("QO", "Äusseres Ozeanien");
    namesMap.put("RW", "Rwanda");
    namesMap.put("SB", "Salomon-Inseln");
    namesMap.put("ST", "Sao Tomé und Principe");
    namesMap.put("ZW", "Zimbabwe");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "BD": "Bangladesh",
        "BN": "Brunei",
        "BW": "Botswana",
        "BY": "Weissrussland",
        "CV": "Kapverden",
        "DJ": "Djibouti",
        "GB": "Grossbritannien",
        "MH": "Marshall-Inseln",
        "QO": "Äusseres Ozeanien",
        "RW": "Rwanda",
        "SB": "Salomon-Inseln",
        "ST": "Sao Tomé und Principe",
        "ZW": "Zimbabwe"
    };
  }-*/;
}
