/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "el" locale.
 */
public class LocalizedNamesImpl_el extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "GR",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "SH",
        "LC",
        "BL",
        "VC",
        "SM",
        "MF",
        "SX",
        "KN",
        "AZ",
        "EG",
        "ET",
        "HT",
        "CI",
        "AL",
        "DZ",
        "VI",
        "AS",
        "AO",
        "AI",
        "AD",
        "AQ",
        "AG",
        "UM",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AF",
        "VU",
        "VA",
        "BE",
        "VE",
        "BM",
        "VN",
        "BO",
        "KP",
        "BA",
        "BG",
        "BR",
        "IO",
        "VG",
        "FR",
        "TF",
        "GF",
        "PF",
        "DE",
        "GE",
        "GI",
        "GM",
        "GA",
        "GH",
        "GG",
        "GU",
        "GP",
        "GT",
        "GY",
        "GN",
        "GW",
        "GD",
        "GL",
        "DK",
        "DO",
        "EH",
        "EC",
        "CH",
        "GR",
        "SV",
        "ER",
        "EE",
        "EU",
        "ZM",
        "ZW",
        "AE",
        "US",
        "GB",
        "EA",
        "JP",
        "IN",
        "ID",
        "JO",
        "IQ",
        "IR",
        "IE",
        "GQ",
        "IS",
        "ES",
        "IL",
        "IT",
        "KZ",
        "CM",
        "KH",
        "CA",
        "IC",
        "QA",
        "CF",
        "KE",
        "CN",
        "KG",
        "KI",
        "CO",
        "KM",
        "CD",
        "CG",
        "XK",
        "CR",
        "CU",
        "KW",
        "CW",
        "HR",
        "CY",
        "LA",
        "LS",
        "LV",
        "BY",
        "LB",
        "LR",
        "LY",
        "LT",
        "LI",
        "LU",
        "YT",
        "MG",
        "MO",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MU",
        "MR",
        "ME",
        "MX",
        "MM",
        "FM",
        "MN",
        "MZ",
        "MD",
        "MC",
        "MS",
        "BD",
        "BB",
        "BS",
        "BH",
        "BZ",
        "BJ",
        "BW",
        "BF",
        "BI",
        "BT",
        "BN",
        "NA",
        "NR",
        "NZ",
        "NC",
        "NP",
        "MP",
        "KY",
        "CC",
        "CK",
        "MH",
        "GS",
        "AX",
        "PN",
        "SB",
        "TC",
        "FO",
        "FK",
        "HM",
        "AC",
        "CP",
        "IM",
        "BV",
        "NF",
        "CX",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "ZA",
        "KR",
        "SS",
        "DG",
        "DM",
        "NL",
        "BQ",
        "AN",
        "OM",
        "HN",
        "WF",
        "HU",
        "UG",
        "UZ",
        "UA",
        "UY",
        "PK",
        "PS",
        "PW",
        "PA",
        "PG",
        "PY",
        "MK",
        "QO",
        "PE",
        "PL",
        "PT",
        "PR",
        "CV",
        "RE",
        "RW",
        "RO",
        "RU",
        "WS",
        "ST",
        "SA",
        "SJ",
        "SN",
        "PM",
        "RS",
        "SC",
        "SG",
        "SL",
        "SK",
        "SI",
        "SO",
        "SZ",
        "SD",
        "SE",
        "SR",
        "LK",
        "SY",
        "TW",
        "TH",
        "TZ",
        "TJ",
        "JM",
        "JE",
        "DJ",
        "TL",
        "TG",
        "TK",
        "TO",
        "TV",
        "TR",
        "TM",
        "TT",
        "TA",
        "TD",
        "CZ",
        "TN",
        "YE",
        "PH",
        "FI",
        "FJ",
        "CL",
        "HK",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Κόσμος");
    namesMap.put("002", "Αφρική");
    namesMap.put("003", "Βόρεια Αμερική");
    namesMap.put("005", "Νότια Αμερική");
    namesMap.put("009", "Ωκεανία");
    namesMap.put("011", "Δυτική Αφρική");
    namesMap.put("013", "Κεντρική Αμερική");
    namesMap.put("014", "Ανατολική Αφρική");
    namesMap.put("015", "Βόρεια Αφρική");
    namesMap.put("017", "Μέση Αφρική");
    namesMap.put("018", "Νότιος Αφρική");
    namesMap.put("019", "Αμερική");
    namesMap.put("021", "Βόρειος Αμερική");
    namesMap.put("029", "Καραϊβική");
    namesMap.put("030", "Ανατολική Ασία");
    namesMap.put("034", "Νότια Ασία");
    namesMap.put("035", "Νοτιοανατολική Ασία");
    namesMap.put("039", "Νότια Ευρώπη");
    namesMap.put("053", "Αυστραλασία");
    namesMap.put("054", "Μελανησία");
    namesMap.put("057", "Περιοχή Μικρονησίας");
    namesMap.put("061", "Πολυνησία");
    namesMap.put("142", "Ασία");
    namesMap.put("143", "Κεντρική Ασία");
    namesMap.put("145", "Δυτική Ασία");
    namesMap.put("150", "Ευρώπη");
    namesMap.put("151", "Ανατολική Ευρώπη");
    namesMap.put("154", "Βόρεια Ευρώπη");
    namesMap.put("155", "Δυτική Ευρώπη");
    namesMap.put("419", "Λατινική Αμερική");
    namesMap.put("AC", "Νήσος Ασενσιόν");
    namesMap.put("AD", "Ανδόρα");
    namesMap.put("AE", "Ηνωμένα Αραβικά Εμιράτα");
    namesMap.put("AF", "Αφγανιστάν");
    namesMap.put("AG", "Αντίγκουα και Μπαρμπούντα");
    namesMap.put("AI", "Ανγκουίλα");
    namesMap.put("AL", "Αλβανία");
    namesMap.put("AM", "Αρμενία");
    namesMap.put("AN", "Ολλανδικές Αντίλλες");
    namesMap.put("AO", "Ανγκόλα");
    namesMap.put("AQ", "Ανταρκτική");
    namesMap.put("AR", "Αργεντινή");
    namesMap.put("AS", "Αμερικανική Σαμόα");
    namesMap.put("AT", "Αυστρία");
    namesMap.put("AU", "Αυστραλία");
    namesMap.put("AW", "Αρούμπα");
    namesMap.put("AX", "Νήσοι Όλαντ");
    namesMap.put("AZ", "Αζερμπαϊτζάν");
    namesMap.put("BA", "Βοσνία - Ερζεγοβίνη");
    namesMap.put("BB", "Μπαρμπάντος");
    namesMap.put("BD", "Μπανγκλαντές");
    namesMap.put("BE", "Βέλγιο");
    namesMap.put("BF", "Μπουρκίνα Φάσο");
    namesMap.put("BG", "Βουλγαρία");
    namesMap.put("BH", "Μπαχρέιν");
    namesMap.put("BI", "Μπουρούντι");
    namesMap.put("BJ", "Μπενίν");
    namesMap.put("BL", "Άγιος Βαρθολομαίος");
    namesMap.put("BM", "Βερμούδες");
    namesMap.put("BN", "Μπρουνέι");
    namesMap.put("BO", "Βολιβία");
    namesMap.put("BQ", "Ολλανδία Καραϊβικής");
    namesMap.put("BR", "Βραζιλία");
    namesMap.put("BS", "Μπαχάμες");
    namesMap.put("BT", "Μπουτάν");
    namesMap.put("BV", "Νήσος Μπουβέ");
    namesMap.put("BW", "Μποτσουάνα");
    namesMap.put("BY", "Λευκορωσία");
    namesMap.put("BZ", "Μπελίζ");
    namesMap.put("CA", "Καναδάς");
    namesMap.put("CC", "Νήσοι Κόκος (Κίλινγκ)");
    namesMap.put("CD", "Κονγκό - Κινσάσα");
    namesMap.put("CF", "Κεντροαφρικανική Δημοκρατία");
    namesMap.put("CG", "Κονγκό - Μπραζαβίλ");
    namesMap.put("CH", "Ελβετία");
    namesMap.put("CI", "Ακτή Ελεφαντοστού");
    namesMap.put("CK", "Νήσοι Κουκ");
    namesMap.put("CL", "Χιλή");
    namesMap.put("CM", "Καμερούν");
    namesMap.put("CN", "Κίνα");
    namesMap.put("CO", "Κολομβία");
    namesMap.put("CP", "Νήσος Κλίπερτον");
    namesMap.put("CR", "Κόστα Ρίκα");
    namesMap.put("CU", "Κούβα");
    namesMap.put("CV", "Πράσινο Ακρωτήριο");
    namesMap.put("CW", "Κουρασάο");
    namesMap.put("CX", "Νήσος των Χριστουγέννων");
    namesMap.put("CY", "Κύπρος");
    namesMap.put("CZ", "Τσεχική Δημοκρατία");
    namesMap.put("DE", "Γερμανία");
    namesMap.put("DG", "Ντιέγκο Γκαρσία");
    namesMap.put("DJ", "Τζιμπουτί");
    namesMap.put("DK", "Δανία");
    namesMap.put("DM", "Ντομίνικα");
    namesMap.put("DO", "Δομινικανή Δημοκρατία");
    namesMap.put("DZ", "Αλγερία");
    namesMap.put("EA", "Θεούτα και Μελίλα");
    namesMap.put("EC", "Εκουαδόρ");
    namesMap.put("EE", "Εσθονία");
    namesMap.put("EG", "Αίγυπτος");
    namesMap.put("EH", "Δυτική Σαχάρα");
    namesMap.put("ER", "Ερυθραία");
    namesMap.put("ES", "Ισπανία");
    namesMap.put("ET", "Αιθιοπία");
    namesMap.put("EU", "Ευρωπαϊκή Ένωση");
    namesMap.put("FI", "Φινλανδία");
    namesMap.put("FJ", "Φίτζι");
    namesMap.put("FK", "Νήσοι Φόκλαντ");
    namesMap.put("FM", "Μικρονησία");
    namesMap.put("FO", "Νήσοι Φερόες");
    namesMap.put("FR", "Γαλλία");
    namesMap.put("GA", "Γκαμπόν");
    namesMap.put("GB", "Ηνωμένο Βασίλειο");
    namesMap.put("GD", "Γρενάδα");
    namesMap.put("GE", "Γεωργία");
    namesMap.put("GF", "Γαλλική Γουιάνα");
    namesMap.put("GG", "Γκέρνζι");
    namesMap.put("GH", "Γκάνα");
    namesMap.put("GI", "Γιβραλτάρ");
    namesMap.put("GL", "Γροιλανδία");
    namesMap.put("GM", "Γκάμπια");
    namesMap.put("GN", "Γουινέα");
    namesMap.put("GP", "Γουαδελούπη");
    namesMap.put("GQ", "Ισημερινή Γουινέα");
    namesMap.put("GR", "Ελλάδα");
    namesMap.put("GS", "Νήσοι Νότια Γεωργία και Νότιες Σάντουιτς");
    namesMap.put("GT", "Γουατεμάλα");
    namesMap.put("GU", "Γκουάμ");
    namesMap.put("GW", "Γουινέα Μπισάου");
    namesMap.put("GY", "Γουιάνα");
    namesMap.put("HK", "Χονγκ Κονγκ ΕΔΠ Κίνας");
    namesMap.put("HM", "Νήσοι Χερντ και Μακντόναλντ");
    namesMap.put("HN", "Ονδούρα");
    namesMap.put("HR", "Κροατία");
    namesMap.put("HT", "Αϊτή");
    namesMap.put("HU", "Ουγγαρία");
    namesMap.put("IC", "Κανάριοι Νήσοι");
    namesMap.put("ID", "Ινδονησία");
    namesMap.put("IE", "Ιρλανδία");
    namesMap.put("IL", "Ισραήλ");
    namesMap.put("IM", "Νήσος Μαν");
    namesMap.put("IN", "Ινδία");
    namesMap.put("IO", "Βρετανικά Εδάφη Ινδικού Ωκεανού");
    namesMap.put("IQ", "Ιράκ");
    namesMap.put("IR", "Ιράν");
    namesMap.put("IS", "Ισλανδία");
    namesMap.put("IT", "Ιταλία");
    namesMap.put("JE", "Τζέρζι");
    namesMap.put("JM", "Τζαμάικα");
    namesMap.put("JO", "Ιορδανία");
    namesMap.put("JP", "Ιαπωνία");
    namesMap.put("KE", "Κένυα");
    namesMap.put("KG", "Κιργιστάν");
    namesMap.put("KH", "Καμπότζη");
    namesMap.put("KI", "Κιριμπάτι");
    namesMap.put("KM", "Κομόρες");
    namesMap.put("KN", "Άγιος Χριστόφορος και Νέβις");
    namesMap.put("KP", "Βόρεια Κορέα");
    namesMap.put("KR", "Νότια Κορέα");
    namesMap.put("KW", "Κουβέιτ");
    namesMap.put("KY", "Νήσοι Κάιμαν");
    namesMap.put("KZ", "Καζακστάν");
    namesMap.put("LA", "Λάος");
    namesMap.put("LB", "Λίβανος");
    namesMap.put("LC", "Αγία Λουκία");
    namesMap.put("LI", "Λιχτενστάιν");
    namesMap.put("LK", "Σρι Λάνκα");
    namesMap.put("LR", "Λιβερία");
    namesMap.put("LS", "Λεσότο");
    namesMap.put("LT", "Λιθουανία");
    namesMap.put("LU", "Λουξεμβούργο");
    namesMap.put("LV", "Λετονία");
    namesMap.put("LY", "Λιβύη");
    namesMap.put("MA", "Μαρόκο");
    namesMap.put("MC", "Μονακό");
    namesMap.put("MD", "Μολδαβία");
    namesMap.put("ME", "Μαυροβούνιο");
    namesMap.put("MF", "Άγιος Μαρτίνος (Γαλλικό τμήμα)");
    namesMap.put("MG", "Μαδαγασκάρη");
    namesMap.put("MH", "Νήσοι Μάρσαλ");
    namesMap.put("MK", "ΠΓΔΜ");
    namesMap.put("ML", "Μάλι");
    namesMap.put("MM", "Μιανμάρ/Βιρμανία");
    namesMap.put("MN", "Μογγολία");
    namesMap.put("MO", "Μακάο ΕΔΠ Κίνας");
    namesMap.put("MP", "Νήσοι Βόρειες Μαριάνες");
    namesMap.put("MQ", "Μαρτινίκα");
    namesMap.put("MR", "Μαυριτανία");
    namesMap.put("MS", "Μονσεράτ");
    namesMap.put("MT", "Μάλτα");
    namesMap.put("MU", "Μαυρίκιος");
    namesMap.put("MV", "Μαλδίβες");
    namesMap.put("MW", "Μαλάουι");
    namesMap.put("MX", "Μεξικό");
    namesMap.put("MY", "Μαλαισία");
    namesMap.put("MZ", "Μοζαμβίκη");
    namesMap.put("NA", "Ναμίμπια");
    namesMap.put("NC", "Νέα Καληδονία");
    namesMap.put("NE", "Νίγηρας");
    namesMap.put("NF", "Νήσος Νόρφολκ");
    namesMap.put("NG", "Νιγηρία");
    namesMap.put("NI", "Νικαράγουα");
    namesMap.put("NL", "Ολλανδία");
    namesMap.put("NO", "Νορβηγία");
    namesMap.put("NP", "Νεπάλ");
    namesMap.put("NR", "Ναουρού");
    namesMap.put("NU", "Νιούε");
    namesMap.put("NZ", "Νέα Ζηλανδία");
    namesMap.put("OM", "Ομάν");
    namesMap.put("PA", "Παναμάς");
    namesMap.put("PE", "Περού");
    namesMap.put("PF", "Γαλλική Πολυνησία");
    namesMap.put("PG", "Παπούα Νέα Γουινέα");
    namesMap.put("PH", "Φιλιππίνες");
    namesMap.put("PK", "Πακιστάν");
    namesMap.put("PL", "Πολωνία");
    namesMap.put("PM", "Σεν Πιερ και Μικελόν");
    namesMap.put("PN", "Νήσοι Πίτκερν");
    namesMap.put("PR", "Πουέρτο Ρίκο");
    namesMap.put("PS", "Παλαιστινιακά Εδάφη");
    namesMap.put("PT", "Πορτογαλία");
    namesMap.put("PW", "Παλάου");
    namesMap.put("PY", "Παραγουάη");
    namesMap.put("QA", "Κατάρ");
    namesMap.put("QO", "Περιφερειακή Ωκεανία");
    namesMap.put("RE", "Ρεϊνιόν");
    namesMap.put("RO", "Ρουμανία");
    namesMap.put("RS", "Σερβία");
    namesMap.put("RU", "Ρωσία");
    namesMap.put("RW", "Ρουάντα");
    namesMap.put("SA", "Σαουδική Αραβία");
    namesMap.put("SB", "Νήσοι Σολομώντος");
    namesMap.put("SC", "Σεϋχέλλες");
    namesMap.put("SD", "Σουδάν");
    namesMap.put("SE", "Σουηδία");
    namesMap.put("SG", "Σιγκαπούρη");
    namesMap.put("SH", "Αγία Ελένη");
    namesMap.put("SI", "Σλοβενία");
    namesMap.put("SJ", "Σβάλμπαρντ και Γιαν Μαγιέν");
    namesMap.put("SK", "Σλοβακία");
    namesMap.put("SL", "Σιέρα Λεόνε");
    namesMap.put("SM", "Άγιος Μαρίνος");
    namesMap.put("SN", "Σενεγάλη");
    namesMap.put("SO", "Σομαλία");
    namesMap.put("SR", "Σουρινάμ");
    namesMap.put("SS", "Νότιο Σουδάν");
    namesMap.put("ST", "Σάο Τομέ και Πρίνσιπε");
    namesMap.put("SV", "Ελ Σαλβαδόρ");
    namesMap.put("SX", "Άγιος Μαρτίνος (Ολλανδικό τμήμα)");
    namesMap.put("SY", "Συρία");
    namesMap.put("SZ", "Σουαζιλάνδη");
    namesMap.put("TA", "Τριστάν ντα Κούνια");
    namesMap.put("TC", "Νήσοι Τερκ και Κάικος");
    namesMap.put("TD", "Τσαντ");
    namesMap.put("TF", "Γαλλικές περιοχές του νοτίου ημισφαιρίου");
    namesMap.put("TG", "Τόγκο");
    namesMap.put("TH", "Ταϊλάνδη");
    namesMap.put("TJ", "Τατζικιστάν");
    namesMap.put("TK", "Τοκελάου");
    namesMap.put("TL", "Τιμόρ-Λέστε");
    namesMap.put("TM", "Τουρκμενιστάν");
    namesMap.put("TN", "Τυνησία");
    namesMap.put("TO", "Τόνγκα");
    namesMap.put("TR", "Τουρκία");
    namesMap.put("TT", "Τρινιντάντ και Τομπάγκο");
    namesMap.put("TV", "Τουβαλού");
    namesMap.put("TW", "Ταϊβάν");
    namesMap.put("TZ", "Τανζανία");
    namesMap.put("UA", "Ουκρανία");
    namesMap.put("UG", "Ουγκάντα");
    namesMap.put("UM", "Απομακρυσμένες Νησίδες Η.Π.Α.");
    namesMap.put("US", "Ηνωμένες Πολιτείες");
    namesMap.put("UY", "Ουρουγουάη");
    namesMap.put("UZ", "Ουζμπεκιστάν");
    namesMap.put("VA", "Βατικανό");
    namesMap.put("VC", "Άγιος Βικέντιος και Γρεναδίνες");
    namesMap.put("VE", "Βενεζουέλα");
    namesMap.put("VG", "Βρετανικές Παρθένοι Νήσοι");
    namesMap.put("VI", "Αμερικανικές Παρθένοι Νήσοι");
    namesMap.put("VN", "Βιετνάμ");
    namesMap.put("VU", "Βανουάτου");
    namesMap.put("WF", "Ουάλις και Φουτούνα");
    namesMap.put("WS", "Σαμόα");
    namesMap.put("XK", "Κόσοβο");
    namesMap.put("YE", "Υεμένη");
    namesMap.put("YT", "Μαγιότ");
    namesMap.put("ZA", "Νότια Αφρική");
    namesMap.put("ZM", "Ζάμπια");
    namesMap.put("ZW", "Ζιμπάμπουε");
    namesMap.put("ZZ", "Άγνωστη περιοχή");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Κόσμος",
        "002": "Αφρική",
        "003": "Βόρεια Αμερική",
        "005": "Νότια Αμερική",
        "009": "Ωκεανία",
        "011": "Δυτική Αφρική",
        "013": "Κεντρική Αμερική",
        "014": "Ανατολική Αφρική",
        "015": "Βόρεια Αφρική",
        "017": "Μέση Αφρική",
        "018": "Νότιος Αφρική",
        "019": "Αμερική",
        "021": "Βόρειος Αμερική",
        "029": "Καραϊβική",
        "030": "Ανατολική Ασία",
        "034": "Νότια Ασία",
        "035": "Νοτιοανατολική Ασία",
        "039": "Νότια Ευρώπη",
        "053": "Αυστραλασία",
        "054": "Μελανησία",
        "057": "Περιοχή Μικρονησίας",
        "061": "Πολυνησία",
        "142": "Ασία",
        "143": "Κεντρική Ασία",
        "145": "Δυτική Ασία",
        "150": "Ευρώπη",
        "151": "Ανατολική Ευρώπη",
        "154": "Βόρεια Ευρώπη",
        "155": "Δυτική Ευρώπη",
        "419": "Λατινική Αμερική",
        "AC": "Νήσος Ασενσιόν",
        "AD": "Ανδόρα",
        "AE": "Ηνωμένα Αραβικά Εμιράτα",
        "AF": "Αφγανιστάν",
        "AG": "Αντίγκουα και Μπαρμπούντα",
        "AI": "Ανγκουίλα",
        "AL": "Αλβανία",
        "AM": "Αρμενία",
        "AN": "Ολλανδικές Αντίλλες",
        "AO": "Ανγκόλα",
        "AQ": "Ανταρκτική",
        "AR": "Αργεντινή",
        "AS": "Αμερικανική Σαμόα",
        "AT": "Αυστρία",
        "AU": "Αυστραλία",
        "AW": "Αρούμπα",
        "AX": "Νήσοι Όλαντ",
        "AZ": "Αζερμπαϊτζάν",
        "BA": "Βοσνία - Ερζεγοβίνη",
        "BB": "Μπαρμπάντος",
        "BD": "Μπανγκλαντές",
        "BE": "Βέλγιο",
        "BF": "Μπουρκίνα Φάσο",
        "BG": "Βουλγαρία",
        "BH": "Μπαχρέιν",
        "BI": "Μπουρούντι",
        "BJ": "Μπενίν",
        "BL": "Άγιος Βαρθολομαίος",
        "BM": "Βερμούδες",
        "BN": "Μπρουνέι",
        "BO": "Βολιβία",
        "BQ": "Ολλανδία Καραϊβικής",
        "BR": "Βραζιλία",
        "BS": "Μπαχάμες",
        "BT": "Μπουτάν",
        "BV": "Νήσος Μπουβέ",
        "BW": "Μποτσουάνα",
        "BY": "Λευκορωσία",
        "BZ": "Μπελίζ",
        "CA": "Καναδάς",
        "CC": "Νήσοι Κόκος (Κίλινγκ)",
        "CD": "Κονγκό - Κινσάσα",
        "CF": "Κεντροαφρικανική Δημοκρατία",
        "CG": "Κονγκό - Μπραζαβίλ",
        "CH": "Ελβετία",
        "CI": "Ακτή Ελεφαντοστού",
        "CK": "Νήσοι Κουκ",
        "CL": "Χιλή",
        "CM": "Καμερούν",
        "CN": "Κίνα",
        "CO": "Κολομβία",
        "CP": "Νήσος Κλίπερτον",
        "CR": "Κόστα Ρίκα",
        "CU": "Κούβα",
        "CV": "Πράσινο Ακρωτήριο",
        "CW": "Κουρασάο",
        "CX": "Νήσος των Χριστουγέννων",
        "CY": "Κύπρος",
        "CZ": "Τσεχική Δημοκρατία",
        "DE": "Γερμανία",
        "DG": "Ντιέγκο Γκαρσία",
        "DJ": "Τζιμπουτί",
        "DK": "Δανία",
        "DM": "Ντομίνικα",
        "DO": "Δομινικανή Δημοκρατία",
        "DZ": "Αλγερία",
        "EA": "Θεούτα και Μελίλα",
        "EC": "Εκουαδόρ",
        "EE": "Εσθονία",
        "EG": "Αίγυπτος",
        "EH": "Δυτική Σαχάρα",
        "ER": "Ερυθραία",
        "ES": "Ισπανία",
        "ET": "Αιθιοπία",
        "EU": "Ευρωπαϊκή Ένωση",
        "FI": "Φινλανδία",
        "FJ": "Φίτζι",
        "FK": "Νήσοι Φόκλαντ",
        "FM": "Μικρονησία",
        "FO": "Νήσοι Φερόες",
        "FR": "Γαλλία",
        "GA": "Γκαμπόν",
        "GB": "Ηνωμένο Βασίλειο",
        "GD": "Γρενάδα",
        "GE": "Γεωργία",
        "GF": "Γαλλική Γουιάνα",
        "GG": "Γκέρνζι",
        "GH": "Γκάνα",
        "GI": "Γιβραλτάρ",
        "GL": "Γροιλανδία",
        "GM": "Γκάμπια",
        "GN": "Γουινέα",
        "GP": "Γουαδελούπη",
        "GQ": "Ισημερινή Γουινέα",
        "GR": "Ελλάδα",
        "GS": "Νήσοι Νότια Γεωργία και Νότιες Σάντουιτς",
        "GT": "Γουατεμάλα",
        "GU": "Γκουάμ",
        "GW": "Γουινέα Μπισάου",
        "GY": "Γουιάνα",
        "HK": "Χονγκ Κονγκ ΕΔΠ Κίνας",
        "HM": "Νήσοι Χερντ και Μακντόναλντ",
        "HN": "Ονδούρα",
        "HR": "Κροατία",
        "HT": "Αϊτή",
        "HU": "Ουγγαρία",
        "IC": "Κανάριοι Νήσοι",
        "ID": "Ινδονησία",
        "IE": "Ιρλανδία",
        "IL": "Ισραήλ",
        "IM": "Νήσος Μαν",
        "IN": "Ινδία",
        "IO": "Βρετανικά Εδάφη Ινδικού Ωκεανού",
        "IQ": "Ιράκ",
        "IR": "Ιράν",
        "IS": "Ισλανδία",
        "IT": "Ιταλία",
        "JE": "Τζέρζι",
        "JM": "Τζαμάικα",
        "JO": "Ιορδανία",
        "JP": "Ιαπωνία",
        "KE": "Κένυα",
        "KG": "Κιργιστάν",
        "KH": "Καμπότζη",
        "KI": "Κιριμπάτι",
        "KM": "Κομόρες",
        "KN": "Άγιος Χριστόφορος και Νέβις",
        "KP": "Βόρεια Κορέα",
        "KR": "Νότια Κορέα",
        "KW": "Κουβέιτ",
        "KY": "Νήσοι Κάιμαν",
        "KZ": "Καζακστάν",
        "LA": "Λάος",
        "LB": "Λίβανος",
        "LC": "Αγία Λουκία",
        "LI": "Λιχτενστάιν",
        "LK": "Σρι Λάνκα",
        "LR": "Λιβερία",
        "LS": "Λεσότο",
        "LT": "Λιθουανία",
        "LU": "Λουξεμβούργο",
        "LV": "Λετονία",
        "LY": "Λιβύη",
        "MA": "Μαρόκο",
        "MC": "Μονακό",
        "MD": "Μολδαβία",
        "ME": "Μαυροβούνιο",
        "MF": "Άγιος Μαρτίνος (Γαλλικό τμήμα)",
        "MG": "Μαδαγασκάρη",
        "MH": "Νήσοι Μάρσαλ",
        "MK": "ΠΓΔΜ",
        "ML": "Μάλι",
        "MM": "Μιανμάρ/Βιρμανία",
        "MN": "Μογγολία",
        "MO": "Μακάο ΕΔΠ Κίνας",
        "MP": "Νήσοι Βόρειες Μαριάνες",
        "MQ": "Μαρτινίκα",
        "MR": "Μαυριτανία",
        "MS": "Μονσεράτ",
        "MT": "Μάλτα",
        "MU": "Μαυρίκιος",
        "MV": "Μαλδίβες",
        "MW": "Μαλάουι",
        "MX": "Μεξικό",
        "MY": "Μαλαισία",
        "MZ": "Μοζαμβίκη",
        "NA": "Ναμίμπια",
        "NC": "Νέα Καληδονία",
        "NE": "Νίγηρας",
        "NF": "Νήσος Νόρφολκ",
        "NG": "Νιγηρία",
        "NI": "Νικαράγουα",
        "NL": "Ολλανδία",
        "NO": "Νορβηγία",
        "NP": "Νεπάλ",
        "NR": "Ναουρού",
        "NU": "Νιούε",
        "NZ": "Νέα Ζηλανδία",
        "OM": "Ομάν",
        "PA": "Παναμάς",
        "PE": "Περού",
        "PF": "Γαλλική Πολυνησία",
        "PG": "Παπούα Νέα Γουινέα",
        "PH": "Φιλιππίνες",
        "PK": "Πακιστάν",
        "PL": "Πολωνία",
        "PM": "Σεν Πιερ και Μικελόν",
        "PN": "Νήσοι Πίτκερν",
        "PR": "Πουέρτο Ρίκο",
        "PS": "Παλαιστινιακά Εδάφη",
        "PT": "Πορτογαλία",
        "PW": "Παλάου",
        "PY": "Παραγουάη",
        "QA": "Κατάρ",
        "QO": "Περιφερειακή Ωκεανία",
        "RE": "Ρεϊνιόν",
        "RO": "Ρουμανία",
        "RS": "Σερβία",
        "RU": "Ρωσία",
        "RW": "Ρουάντα",
        "SA": "Σαουδική Αραβία",
        "SB": "Νήσοι Σολομώντος",
        "SC": "Σεϋχέλλες",
        "SD": "Σουδάν",
        "SE": "Σουηδία",
        "SG": "Σιγκαπούρη",
        "SH": "Αγία Ελένη",
        "SI": "Σλοβενία",
        "SJ": "Σβάλμπαρντ και Γιαν Μαγιέν",
        "SK": "Σλοβακία",
        "SL": "Σιέρα Λεόνε",
        "SM": "Άγιος Μαρίνος",
        "SN": "Σενεγάλη",
        "SO": "Σομαλία",
        "SR": "Σουρινάμ",
        "SS": "Νότιο Σουδάν",
        "ST": "Σάο Τομέ και Πρίνσιπε",
        "SV": "Ελ Σαλβαδόρ",
        "SX": "Άγιος Μαρτίνος (Ολλανδικό τμήμα)",
        "SY": "Συρία",
        "SZ": "Σουαζιλάνδη",
        "TA": "Τριστάν ντα Κούνια",
        "TC": "Νήσοι Τερκ και Κάικος",
        "TD": "Τσαντ",
        "TF": "Γαλλικές περιοχές του νοτίου ημισφαιρίου",
        "TG": "Τόγκο",
        "TH": "Ταϊλάνδη",
        "TJ": "Τατζικιστάν",
        "TK": "Τοκελάου",
        "TL": "Τιμόρ-Λέστε",
        "TM": "Τουρκμενιστάν",
        "TN": "Τυνησία",
        "TO": "Τόνγκα",
        "TR": "Τουρκία",
        "TT": "Τρινιντάντ και Τομπάγκο",
        "TV": "Τουβαλού",
        "TW": "Ταϊβάν",
        "TZ": "Τανζανία",
        "UA": "Ουκρανία",
        "UG": "Ουγκάντα",
        "UM": "Απομακρυσμένες Νησίδες Η.Π.Α.",
        "US": "Ηνωμένες Πολιτείες",
        "UY": "Ουρουγουάη",
        "UZ": "Ουζμπεκιστάν",
        "VA": "Βατικανό",
        "VC": "Άγιος Βικέντιος και Γρεναδίνες",
        "VE": "Βενεζουέλα",
        "VG": "Βρετανικές Παρθένοι Νήσοι",
        "VI": "Αμερικανικές Παρθένοι Νήσοι",
        "VN": "Βιετνάμ",
        "VU": "Βανουάτου",
        "WF": "Ουάλις και Φουτούνα",
        "WS": "Σαμόα",
        "XK": "Κόσοβο",
        "YE": "Υεμένη",
        "YT": "Μαγιότ",
        "ZA": "Νότια Αφρική",
        "ZM": "Ζάμπια",
        "ZW": "Ζιμπάμπουε",
        "ZZ": "Άγνωστη περιοχή"
    };
  }-*/;
}
