/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "fr_CA" locale.
 */
public class LocalizedNamesImpl_fr_CA extends LocalizedNamesImpl_fr {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "AL",
        "DZ",
        "DE",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AN",
        "SA",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "KH",
        "CM",
        "CA",
        "CV",
        "EA",
        "CL",
        "CN",
        "CY",
        "CO",
        "KM",
        "CG",
        "CD",
        "KP",
        "KR",
        "CR",
        "CI",
        "HR",
        "CU",
        "CW",
        "DK",
        "DG",
        "DJ",
        "DM",
        "EG",
        "SV",
        "AE",
        "EC",
        "ER",
        "ES",
        "EE",
        "VA",
        "US",
        "ET",
        "FJ",
        "FI",
        "FR",
        "GA",
        "GM",
        "GE",
        "GS",
        "GH",
        "GI",
        "GR",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "GF",
        "HT",
        "HN",
        "HU",
        "BV",
        "CX",
        "CP",
        "AC",
        "IM",
        "NF",
        "AX",
        "KY",
        "IC",
        "CC",
        "CK",
        "UM",
        "FO",
        "HM",
        "FK",
        "MP",
        "MH",
        "SB",
        "TC",
        "VG",
        "VI",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "KZ",
        "KE",
        "KG",
        "KI",
        "XK",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MU",
        "MR",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "NC",
        "NZ",
        "OM",
        "UG",
        "UZ",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "NL",
        "BQ",
        "PE",
        "PH",
        "PN",
        "PL",
        "PF",
        "PR",
        "PT",
        "QA",
        "HK",
        "MO",
        "QO",
        "CF",
        "DO",
        "CZ",
        "RE",
        "RO",
        "GB",
        "RU",
        "RW",
        "EH",
        "BL",
        "SH",
        "LC",
        "KN",
        "SM",
        "MF",
        "SX",
        "PM",
        "VC",
        "WS",
        "AS",
        "ST",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SK",
        "SI",
        "SO",
        "SD",
        "SS",
        "LK",
        "SE",
        "CH",
        "SR",
        "SJ",
        "SZ",
        "SY",
        "TJ",
        "TW",
        "TZ",
        "TD",
        "TF",
        "IO",
        "PS",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TR",
        "TV",
        "UA",
        "EU",
        "UY",
        "VU",
        "VE",
        "VN",
        "WF",
        "YE",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("053", "Australie et Nouvelle-Zélande");
    namesMap.put("AC", "Île de l'Ascension");
    namesMap.put("BL", "Saint-Barthélémy");
    namesMap.put("BY", "Bélarus");
    namesMap.put("FM", "Micronésie");
    namesMap.put("GS", "Géorgie du Sud et les îles Sandwich du Sud");
    namesMap.put("IO", "Territoire britannique de l'océan Indien");
    namesMap.put("MF", "Saint-Martin");
    namesMap.put("PS", "Territoire palestinien");
    namesMap.put("RE", "Réunion");
    namesMap.put("TC", "Îles Turks et Caïques");
    namesMap.put("UM", "Îles éloignées des États-Unis");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "053": "Australie et Nouvelle-Zélande",
        "AC": "Île de l'Ascension",
        "BL": "Saint-Barthélémy",
        "BY": "Bélarus",
        "FM": "Micronésie",
        "GS": "Géorgie du Sud et les îles Sandwich du Sud",
        "IO": "Territoire britannique de l'océan Indien",
        "MF": "Saint-Martin",
        "PS": "Territoire palestinien",
        "RE": "Réunion",
        "TC": "Îles Turks et Caïques",
        "UM": "Îles éloignées des États-Unis"
    };
  }-*/;
}
