/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import javax.annotation.Nullable;

public final class AccessControlUtils {
    private AccessControlUtils() {
    }

    static JSDocInfo.Visibility getEffectiveNameVisibility(Node name, Var var, ImmutableMap<StaticSourceFile, JSDocInfo.Visibility> fileVisibilityMap) {
        JSDocInfo.Visibility raw;
        JSDocInfo jsDocInfo = var.getJSDocInfo();
        JSDocInfo.Visibility visibility = raw = jsDocInfo == null || jsDocInfo.getVisibility() == null ? JSDocInfo.Visibility.INHERITED : jsDocInfo.getVisibility();
        if (raw != JSDocInfo.Visibility.INHERITED) {
            return raw;
        }
        JSDocInfo.Visibility defaultVisibilityForFile = (JSDocInfo.Visibility)((Object)fileVisibilityMap.get((Object)var.getSourceFile()));
        JSType type = name.getJSType();
        boolean createdFromGoogProvide = type != null && type.isLiteralObject();
        return createdFromGoogProvide || defaultVisibilityForFile == null ? raw : defaultVisibilityForFile;
    }

    static JSDocInfo.Visibility getEffectivePropertyVisibility(Node property, ObjectType referenceType, ImmutableMap<StaticSourceFile, JSDocInfo.Visibility> fileVisibilityMap, @Nullable CodingConvention codingConvention) {
        String propertyName = property.getLastChild().getString();
        StaticSourceFile definingSource = AccessControlUtils.getDefiningSource(property, referenceType, propertyName);
        JSDocInfo.Visibility fileOverviewVisibility = (JSDocInfo.Visibility)((Object)fileVisibilityMap.get((Object)definingSource));
        Node parent = property.getParent();
        boolean isOverride = parent.getJSDocInfo() != null && parent.isAssign() && parent.getFirstChild() == property;
        ObjectType objectType = AccessControlUtils.getObjectType(referenceType, isOverride, propertyName);
        if (isOverride) {
            JSDocInfo.Visibility overridden = AccessControlUtils.getOverriddenPropertyVisibility(objectType, propertyName);
            return AccessControlUtils.getEffectiveVisibilityForOverriddenProperty(overridden, fileOverviewVisibility, propertyName, codingConvention);
        }
        return AccessControlUtils.getEffectiveVisibilityForNonOverriddenProperty(property, objectType, fileOverviewVisibility, codingConvention);
    }

    @Nullable
    static StaticSourceFile getDefiningSource(Node node, @Nullable ObjectType referenceType, String propertyName) {
        Node propDefNode;
        if (referenceType != null && (propDefNode = referenceType.getPropertyDefSite(propertyName)) != null) {
            return propDefNode.getStaticSourceFile();
        }
        return node.getStaticSourceFile();
    }

    @Nullable
    static ObjectType getObjectType(@Nullable ObjectType referenceType, boolean isOverride, String propertyName) {
        ObjectType current;
        if (referenceType == null) {
            return null;
        }
        ObjectType objectType = current = isOverride ? referenceType.getImplicitPrototype() : referenceType;
        while (current != null) {
            JSDocInfo docInfo = current.getOwnPropertyJSDocInfo(propertyName);
            if (docInfo != null && docInfo.getVisibility() != JSDocInfo.Visibility.INHERITED) {
                return current;
            }
            current = current.getImplicitPrototype();
        }
        return null;
    }

    static JSDocInfo.Visibility getOverriddenPropertyVisibility(ObjectType objectType, String propertyName) {
        return objectType != null ? objectType.getOwnPropertyJSDocInfo(propertyName).getVisibility() : JSDocInfo.Visibility.INHERITED;
    }

    static JSDocInfo.Visibility getEffectiveVisibilityForOverriddenProperty(JSDocInfo.Visibility visibility, @Nullable JSDocInfo.Visibility fileOverviewVisibility, String propertyName, @Nullable CodingConvention codingConvention) {
        if (codingConvention != null && codingConvention.isPrivate(propertyName)) {
            return JSDocInfo.Visibility.PRIVATE;
        }
        return fileOverviewVisibility != null && visibility == JSDocInfo.Visibility.INHERITED ? fileOverviewVisibility : visibility;
    }

    private static JSDocInfo.Visibility getEffectiveVisibilityForNonOverriddenProperty(Node getprop, ObjectType objectType, @Nullable JSDocInfo.Visibility fileOverviewVisibility, @Nullable CodingConvention codingConvention) {
        JSType type;
        String propertyName = getprop.getLastChild().getString();
        if (codingConvention != null && codingConvention.isPrivate(propertyName)) {
            return JSDocInfo.Visibility.PRIVATE;
        }
        JSDocInfo.Visibility raw = JSDocInfo.Visibility.INHERITED;
        if (objectType != null) {
            raw = objectType.getOwnPropertyJSDocInfo(propertyName).getVisibility();
        }
        boolean createdFromGoogProvide = (type = getprop.getJSType()) != null && type.isLiteralObject();
        return raw != JSDocInfo.Visibility.INHERITED || fileOverviewVisibility == null || createdFromGoogProvide ? raw : fileOverviewVisibility;
    }
}

