/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckJSDoc;
import com.google.javascript.jscomp.CheckMissingAndExtraRequires;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckSuper;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosureRewriteClass;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultPassConfig;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.lint.CheckDuplicateCase;
import com.google.javascript.jscomp.lint.CheckEmptyStatements;
import com.google.javascript.jscomp.lint.CheckEnums;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckMissingSemicolon;
import com.google.javascript.jscomp.lint.CheckNullabilityModifiers;
import com.google.javascript.jscomp.lint.CheckPrimitiveAsObject;
import com.google.javascript.jscomp.lint.CheckPrototypeProperties;
import com.google.javascript.jscomp.lint.CheckRequiresAndProvidesSorted;
import com.google.javascript.jscomp.lint.CheckUnusedLabels;
import com.google.javascript.jscomp.lint.CheckUselessBlocks;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import java.util.List;

class LintPassConfig
extends PassConfig.PassConfigDelegate {
    private final PassFactory earlyLintChecks = new PassFactory("earlyLintChecks", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CombinedCompilerPass(compiler, (List<NodeTraversal.Callback>)ImmutableList.of((Object)new CheckDuplicateCase(compiler), (Object)new CheckEmptyStatements(compiler), (Object)new CheckEnums(compiler), (Object)new CheckJSDocStyle(compiler), (Object)new CheckJSDoc(compiler), (Object)new CheckMissingSemicolon(compiler), (Object)new CheckSuper(compiler), (Object)new CheckPrimitiveAsObject(compiler), (Object)new ClosureCheckModule(compiler), (Object)new CheckNullabilityModifiers(compiler), (Object)new CheckRequiresAndProvidesSorted(compiler), (Object)new CheckSideEffects(compiler, true, false), (Object[])new NodeTraversal.Callback[]{new CheckUnusedLabels(compiler), new CheckUselessBlocks(compiler)}));
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest().withoutTypes();
        }
    };
    private final PassFactory variableReferenceCheck = new PassFactory("variableReferenceCheck", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new VariableReferenceCheck(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest().withoutTypes();
        }
    };
    private final PassFactory checkRequires = new PassFactory("checkMissingAndExtraRequires", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CheckMissingAndExtraRequires(compiler, CheckMissingAndExtraRequires.Mode.SINGLE_FILE);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest().withoutTypes();
        }
    };
    private final PassFactory closureRewriteClass = new PassFactory("closureRewriteClass", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new ClosureRewriteClass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest().withoutTypes();
        }
    };
    private final PassFactory lateLintChecks = new PassFactory("lateLintChecks", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CombinedCompilerPass(compiler, (List<NodeTraversal.Callback>)ImmutableList.of((Object)new CheckInterfaces(compiler), (Object)new CheckPrototypeProperties(compiler)));
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest().withoutTypes();
        }
    };

    LintPassConfig(CompilerOptions options) {
        super(new DefaultPassConfig(options));
    }

    @Override
    protected List<PassFactory> getChecks() {
        return ImmutableList.of((Object)this.earlyLintChecks, (Object)this.checkRequires, (Object)this.variableReferenceCheck, (Object)this.closureRewriteClass, (Object)this.lateLintChecks);
    }

    @Override
    protected List<PassFactory> getOptimizations() {
        return ImmutableList.of();
    }
}

