/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.deps.AutoValue_BrowserWithTransformedPrefixesModuleResolver_PrefixReplacement;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.ModuleResolver;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import javax.annotation.Nullable;

public class BrowserWithTransformedPrefixesModuleResolver
extends ModuleResolver {
    static final DiagnosticType TRANSFORMED_PATH_IS_AMBIGUOUS = DiagnosticType.error("JSC_TRANSFORMED_PATH_IS_AMBIGUOUS", "Replacing \"{0}\" with \"{1}\" in the import path \"{2}\" is an ambiguous address (\"{3}\").");
    private final ImmutableSet<PrefixReplacement> prefixReplacements;

    public BrowserWithTransformedPrefixesModuleResolver(ImmutableSet<String> modulePaths, ImmutableList<String> moduleRootPaths, ErrorHandler errorHandler, ModuleLoader.PathEscaper pathEscaper, ImmutableMap<String, String> prefixReplacements) {
        super(modulePaths, moduleRootPaths, errorHandler, pathEscaper);
        Set p = (Set)prefixReplacements.entrySet().stream().map(entry -> PrefixReplacement.of((String)entry.getKey(), (String)entry.getValue())).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.comparingInt(r -> r.prefix().length()).reversed().thenComparing(r -> r.prefix())));
        this.prefixReplacements = ImmutableSet.copyOf((Collection)p);
    }

    @Override
    @Nullable
    public String resolveJsModule(String scriptAddress, String moduleAddress, String sourcename, int lineno, int colno) {
        String transformedAddress = moduleAddress;
        for (PrefixReplacement prefixReplacement : this.prefixReplacements) {
            if (!moduleAddress.startsWith(prefixReplacement.prefix())) continue;
            transformedAddress = prefixReplacement.replacement() + moduleAddress.substring(prefixReplacement.prefix().length());
            if (!ModuleLoader.isAmbiguousIdentifier(transformedAddress)) break;
            this.errorHandler.report(CheckLevel.WARNING, JSError.make(sourcename, lineno, colno, TRANSFORMED_PATH_IS_AMBIGUOUS, prefixReplacement.prefix(), prefixReplacement.replacement(), moduleAddress, transformedAddress));
            break;
        }
        if (ModuleLoader.isAmbiguousIdentifier(transformedAddress)) {
            this.errorHandler.report(CheckLevel.WARNING, JSError.make(sourcename, lineno, colno, ModuleLoader.INVALID_MODULE_PATH, transformedAddress, ModuleLoader.ResolutionMode.BROWSER_WITH_TRANSFORMED_PREFIXES.toString()));
            return null;
        }
        String loadAddress = this.locate(scriptAddress, transformedAddress);
        if (transformedAddress == null) {
            this.errorHandler.report(CheckLevel.WARNING, JSError.make(sourcename, lineno, colno, ModuleLoader.LOAD_WARNING, moduleAddress));
        }
        return loadAddress;
    }

    @Override
    public String resolveModuleAsPath(String scriptAddress, String moduleAddress) {
        if (ModuleLoader.isRelativeIdentifier(moduleAddress)) {
            return super.resolveModuleAsPath(scriptAddress, moduleAddress);
        }
        String transformedAddress = moduleAddress;
        for (PrefixReplacement prefixReplacement : this.prefixReplacements) {
            if (!moduleAddress.startsWith(prefixReplacement.prefix())) continue;
            transformedAddress = prefixReplacement.replacement() + moduleAddress.substring(prefixReplacement.prefix().length());
            break;
        }
        return ModuleLoader.normalize(transformedAddress, (Iterable<String>)this.moduleRootPaths);
    }

    static abstract class PrefixReplacement {
        PrefixReplacement() {
        }

        abstract String prefix();

        abstract String replacement();

        public static PrefixReplacement of(String prefix, String replacement) {
            return new AutoValue_BrowserWithTransformedPrefixesModuleResolver_PrefixReplacement(prefix, replacement);
        }
    }

    public static final class Factory
    implements ModuleLoader.ModuleResolverFactory {
        private final ImmutableMap<String, String> prefixReplacements;

        public Factory(ImmutableMap<String, String> prefixReplacements) {
            this.prefixReplacements = prefixReplacements;
        }

        @Override
        public ModuleResolver create(ImmutableSet<String> modulePaths, ImmutableList<String> moduleRootPaths, ErrorHandler errorHandler, ModuleLoader.PathEscaper pathEscaper) {
            return new BrowserWithTransformedPrefixesModuleResolver(modulePaths, moduleRootPaths, errorHandler, pathEscaper, this.prefixReplacements);
        }
    }
}

