/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.TypeMatchingStrategy;
import com.google.javascript.refactoring.JsSourceMatcher;
import com.google.javascript.refactoring.Match;
import com.google.javascript.refactoring.NodeMetadata;
import com.google.javascript.refactoring.Scanner;
import com.google.javascript.refactoring.SuggestedFix;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class RefasterJsScanner
extends Scanner {
    private String templateJs = null;
    private TypeMatchingStrategy typeMatchingStrategy = TypeMatchingStrategy.SUBTYPES;
    private LinkedHashMap<JsSourceMatcher, ImmutableList<RefasterJsTemplate>> templates;
    private ImmutableList<RefasterJsTemplate> matchedTemplates;
    private static final Pattern AFTER_CHOICE_PATTERN = Pattern.compile("^after_option_(\\d*)_(.*)");

    public void loadRefasterJsTemplate(String refasterjsTemplate) throws IOException {
        Preconditions.checkState((this.templateJs == null ? 1 : 0) != 0, (Object)"Can't load RefasterJs template since a template is already loaded.");
        this.templateJs = Thread.currentThread().getContextClassLoader().getResource(refasterjsTemplate) != null ? Resources.toString((URL)Resources.getResource((String)refasterjsTemplate), (Charset)StandardCharsets.UTF_8) : Files.asCharSource((File)new File(refasterjsTemplate), (Charset)StandardCharsets.UTF_8).read();
    }

    public void setTypeMatchingStrategy(TypeMatchingStrategy typeMatchingStrategy) {
        this.typeMatchingStrategy = typeMatchingStrategy;
    }

    public void loadRefasterJsTemplateFromCode(String refasterJsTemplate) throws IOException {
        Preconditions.checkState((this.templateJs == null ? 1 : 0) != 0, (Object)"Can't load RefasterJs template since a template is already loaded.");
        this.templateJs = refasterJsTemplate;
    }

    public void clearTemplates() {
        this.templates = null;
        this.matchedTemplates = null;
    }

    @Override
    public boolean matches(Node node, NodeMetadata metadata) {
        if (this.templates == null) {
            try {
                this.initialize(metadata.getCompiler());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.matchedTemplates = null;
        for (Map.Entry<JsSourceMatcher, ImmutableList<RefasterJsTemplate>> e : this.templates.entrySet()) {
            if (!e.getKey().matches(node, metadata)) continue;
            this.matchedTemplates = e.getValue();
            return true;
        }
        return false;
    }

    public ImmutableList<SuggestedFix> processMatch(Match match) {
        SuggestedFix.Builder defaultFix = null;
        for (RefasterJsTemplate matchedTemplate : this.matchedTemplates) {
            SuggestedFix.Builder fix = new SuggestedFix.Builder();
            if (matchedTemplate.beforeTemplate.getLastChild().isEquivalentTo(matchedTemplate.afterTemplate.getLastChild())) {
                return ImmutableList.of();
            }
            HashMap<String, String> shortNames = new HashMap<String, String>();
            for (String require : matchedTemplate.getGoogRequiresToAdd()) {
                fix.addGoogRequire(match, require);
                shortNames.put(require, fix.getRequireName(match, require));
            }
            Preconditions.checkState((boolean)matchedTemplate.matcher.matches(match.getNode(), match.getMetadata()), (String)"Matcher for %s did not match a second time", (Object)matchedTemplate.beforeTemplate);
            Node newNode = this.transformNode(matchedTemplate.afterTemplate.getLastChild(), matchedTemplate.matcher.getTemplateNodeToMatchMap(), shortNames);
            Node nodeToReplace = match.getNode();
            fix.attachMatchedNodeInfo(nodeToReplace, match.getMetadata().getCompiler());
            fix.replace(nodeToReplace, newNode, match.getMetadata().getCompiler());
            Node n = match.getNode().getNext();
            int count = matchedTemplate.beforeTemplate.getLastChild().getChildCount();
            for (int i = 1; i < count; ++i) {
                Preconditions.checkNotNull((Object)n, (String)"Found mismatched sibling count between before template and matched node.\nTemplate: %s to %s\nMatch: %s", (Object)matchedTemplate.beforeTemplate.getLastChild(), (Object)matchedTemplate.afterTemplate.getLastChild(), (Object)match.getNode());
                fix.delete(n);
                n = n.getNext();
            }
            for (String require : matchedTemplate.getGoogRequiresToRemove()) {
                fix.removeGoogRequire(match, require);
            }
            if (defaultFix == null) {
                defaultFix = fix;
                continue;
            }
            defaultFix.addAlternative(fix.build());
        }
        return ImmutableList.of((Object)defaultFix.build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node transformNode(Node templateNode, Map<String, Node> templateNodeToMatchMap, Map<String, String> shortNames) {
        String shortName;
        String name;
        Node clone = templateNode.cloneNode();
        if (templateNode.isName()) {
            name = templateNode.getString();
            if (templateNodeToMatchMap.containsKey(name)) {
                Node templateMatch = templateNodeToMatchMap.get(name);
                Preconditions.checkNotNull((Object)templateMatch, (String)"Match for %s is null", (Object)name);
                if (!templateNode.getParent().isVar()) return templateMatch.cloneTree();
                clone.setString(templateMatch.getString());
            }
        } else if (templateNode.isCall() && templateNode.getBooleanProp((byte)50) && templateNode.getFirstChild().isName() && templateNodeToMatchMap.containsKey(name = templateNode.getFirstChild().getString())) {
            clone.putBooleanProp((byte)50, false);
        }
        if (templateNode.isQualifiedName() && shortNames.containsKey(name = templateNode.getQualifiedName()) && !(shortName = shortNames.get(name)).equals(name)) {
            return IR.name(shortNames.get(name));
        }
        for (Node child : templateNode.children()) {
            clone.addChildToBack(this.transformNode(child, templateNodeToMatchMap, shortNames));
        }
        return clone;
    }

    void initialize(AbstractCompiler compiler) throws Exception {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.templateJs) ? 1 : 0) != 0, (Object)"The template JS must be loaded before the scanner is used. Make sure that the template file is not empty.");
        Node scriptRoot = new JsAst(SourceFile.fromCode("template", this.templateJs)).getAstRoot(compiler);
        LinkedHashMap<Object, Node> beforeTemplates = new LinkedHashMap<Object, Node>();
        HashMap afterTemplates = new HashMap();
        HashSet<String> hasChoices = new HashSet<String>();
        for (Node templateNode : scriptRoot.children()) {
            Object templateName;
            if (!templateNode.isFunction()) continue;
            String fnName = templateNode.getFirstChild().getQualifiedName();
            if (fnName.startsWith("before_")) {
                templateName = fnName.substring("before_".length());
                Preconditions.checkState((!beforeTemplates.containsKey(templateName) ? 1 : 0) != 0, (String)"Found existing template with the same name: %s", beforeTemplates.get(templateName));
                Preconditions.checkState((boolean)templateNode.getLastChild().hasChildren(), (Object)"Before templates are not allowed to be empty!");
                beforeTemplates.put(templateName, templateNode);
                continue;
            }
            if (fnName.startsWith("after_option_")) {
                Matcher m = AFTER_CHOICE_PATTERN.matcher(fnName);
                Preconditions.checkState((boolean)m.matches(), (String)"Template name %s must match pattern after_option_\\d*_", (Object)fnName);
                int optionNumber = Integer.parseInt(m.group(1));
                String templateName2 = m.group(2);
                if (!afterTemplates.containsKey(templateName2)) {
                    afterTemplates.put(templateName2, new TreeMap());
                    hasChoices.add(templateName2);
                }
                Preconditions.checkState((boolean)hasChoices.contains(templateName2), (Object)"Template %s can only be mixed with other after_option_ templates");
                Preconditions.checkState((!((SortedMap)afterTemplates.get(templateName2)).containsKey(optionNumber) ? 1 : 0) != 0, (String)"Found duplicate template for %s, assign unique indexes for options", (Object)fnName);
                ((SortedMap)afterTemplates.get(templateName2)).put(optionNumber, templateNode);
                continue;
            }
            if (fnName.startsWith("after_")) {
                templateName = fnName.substring("after_".length());
                Preconditions.checkState((!afterTemplates.containsKey(templateName) ? 1 : 0) != 0, (String)"Found existing template with the same name: %s", afterTemplates.get(templateName));
                afterTemplates.put(templateName, ImmutableSortedMap.of((Comparable)Integer.valueOf(0), (Object)templateNode));
                continue;
            }
            if (!fnName.startsWith("do_not_change_")) continue;
            templateName = fnName.substring("do_not_change_".length());
            Preconditions.checkState((!beforeTemplates.containsKey(templateName) ? 1 : 0) != 0, (String)"Found existing template with the same name: %s", beforeTemplates.get(templateName));
            Preconditions.checkState((!afterTemplates.containsKey(templateName) ? 1 : 0) != 0, (String)"Found existing template with the same name: %s", afterTemplates.get(templateName));
            beforeTemplates.put(templateName, templateNode);
            afterTemplates.put(templateName, ImmutableSortedMap.of((Comparable)Integer.valueOf(0), (Object)templateNode));
        }
        Preconditions.checkState((!beforeTemplates.isEmpty() ? 1 : 0) != 0, (Object)"Did not find any RefasterJs templates! Make sure that there are 2 functions defined with the same name, one with a \"before_\" prefix and one with a \"after_\" prefix");
        this.templates = new LinkedHashMap();
        for (String templateName : beforeTemplates.keySet()) {
            Preconditions.checkState((afterTemplates.containsKey(templateName) && !((SortedMap)afterTemplates.get(templateName)).isEmpty() ? 1 : 0) != 0, (String)"Found before template without at least one corresponding after  template. Make sure there is an after_%s or after_option_1_%s function defined.", (Object)templateName, (Object)templateName);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Node afterTemplateOption : ((SortedMap)afterTemplates.get(templateName)).values()) {
                builder.add((Object)new RefasterJsTemplate(compiler.getTypeRegistry(), this.typeMatchingStrategy, (Node)beforeTemplates.get(templateName), afterTemplateOption));
            }
            ImmutableList afterOptions = builder.build();
            this.templates.put(((RefasterJsTemplate)afterOptions.get((int)0)).matcher, (ImmutableList<RefasterJsTemplate>)afterOptions);
        }
    }

    private static class RefasterJsTemplate {
        private static final Pattern ADD_GOOG_REQUIRE_PATTERN = Pattern.compile("\\+require\\s+\\{([^}]+)\\}");
        private static final Pattern REMOVE_GOOG_REQUIRE_PATTERN = Pattern.compile("-require\\s+\\{([^}]+)\\}");
        final JsSourceMatcher matcher;
        final Node beforeTemplate;
        final Node afterTemplate;

        RefasterJsTemplate(JSTypeRegistry typeRegistry, TypeMatchingStrategy typeMatchingStrategy, Node beforeTemplate, Node afterTemplate) {
            this.matcher = new JsSourceMatcher(typeRegistry, beforeTemplate, typeMatchingStrategy);
            this.beforeTemplate = beforeTemplate;
            this.afterTemplate = afterTemplate;
        }

        List<String> getGoogRequiresToAdd() {
            return this.getGoogRequiresFromPattern(ADD_GOOG_REQUIRE_PATTERN);
        }

        List<String> getGoogRequiresToRemove() {
            return this.getGoogRequiresFromPattern(REMOVE_GOOG_REQUIRE_PATTERN);
        }

        private ImmutableList<String> getGoogRequiresFromPattern(Pattern pattern) {
            return (ImmutableList)Stream.concat(RefasterJsTemplate.getGoogRequiresFromNode(pattern, this.beforeTemplate).stream(), RefasterJsTemplate.getGoogRequiresFromNode(pattern, this.afterTemplate).stream()).distinct().collect(ImmutableList.toImmutableList());
        }

        private static ImmutableList<String> getGoogRequiresFromNode(Pattern pattern, Node beforeTemplate) {
            JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(beforeTemplate);
            if (jsDoc == null) {
                return ImmutableList.of();
            }
            String jsDocContent = jsDoc.getOriginalCommentString();
            if (jsDocContent == null) {
                return ImmutableList.of();
            }
            ImmutableList.Builder requires = ImmutableList.builder();
            Matcher m = pattern.matcher(jsDocContent);
            while (m.find()) {
                requires.add((Object)m.group(1));
            }
            return requires.build();
        }
    }
}

