/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

class ConstCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType CONST_REASSIGNED_VALUE_ERROR = DiagnosticType.error("JSC_CONSTANT_REASSIGNED_VALUE_ERROR", "constant {0} assigned a value more than once.\nOriginal definition at {1}");
    private final AbstractCompiler compiler;
    private final Set<Scope.Var> initializedConstants;

    public ConstCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.initializedConstants = new HashSet<Scope.Var>();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverseRoots(this.compiler, this, externs, root);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 38: {
                if (parent == null || !parent.isVar()) break;
                String name = n.getString();
                Scope.Var var = t.getScope().getVar(name);
                if (!this.isConstant(var)) break;
                if (n.isFromExterns()) {
                    this.initializedConstants.add(var);
                    break;
                }
                if (!n.hasChildren()) break;
                if (this.initializedConstants.contains(var)) {
                    this.reportError(t, n, var, name);
                    break;
                }
                this.initializedConstants.add(var);
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                Node lhs = n.getFirstChild();
                if (!lhs.isName()) break;
                String name = lhs.getString();
                Scope.Var var = t.getScope().getVar(name);
                if (!this.isConstant(var)) break;
                if (this.initializedConstants.contains(var)) {
                    this.reportError(t, n, var, name);
                    break;
                }
                this.initializedConstants.add(var);
                break;
            }
            case 102: 
            case 103: {
                Node lhs = n.getFirstChild();
                if (!lhs.isName()) break;
                String name = lhs.getString();
                Scope.Var var = t.getScope().getVar(name);
                if (!this.isConstant(var)) break;
                this.reportError(t, n, var, name);
                break;
            }
        }
    }

    private boolean isConstant(Scope.Var var) {
        return var != null && var.isConst();
    }

    void reportError(NodeTraversal t, Node n, Scope.Var var, String name) {
        JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
        if (info == null || !info.getSuppressions().contains("const")) {
            Node declNode = var.getNode();
            String declaredPosition = declNode.getSourceFileName() + ":" + declNode.getLineno();
            this.compiler.report(t.makeError(n, CONST_REASSIGNED_VALUE_ERROR, name, declaredPosition));
        }
    }
}

