/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JvmMetrics;
import com.google.javascript.jscomp.RecentChange;
import com.google.javascript.rhino.Node;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class PerformanceTracker {
    private static final int DEFAULT_WHEN_SIZE_UNTRACKED = -1;
    private final Node jsRoot;
    private final boolean trackSize;
    private final boolean trackGzSize;
    private final RecentChange codeChange = new RecentChange();
    private int initCodeSize = -1;
    private int initGzCodeSize = -1;
    private int runtime = 0;
    private int runs = 0;
    private int changes = 0;
    private int loopRuns = 0;
    private int loopChanges = 0;
    private int codeSize = -1;
    private int gzCodeSize = -1;
    private int diff = 0;
    private int gzDiff = 0;
    private final Deque<Stats> currentPass = new ArrayDeque<Stats>();
    private final Map<String, Stats> summary = Maps.newHashMap();
    private ImmutableMap<String, Stats> summaryCopy;
    private final List<Stats> log = Lists.newArrayList();

    PerformanceTracker(Node jsRoot, CompilerOptions.TracerMode mode) {
        this.jsRoot = jsRoot;
        switch (mode) {
            case TIMING_ONLY: {
                this.trackSize = false;
                this.trackGzSize = false;
                break;
            }
            case RAW_SIZE: {
                this.trackSize = true;
                this.trackGzSize = false;
                break;
            }
            case ALL: {
                this.trackSize = true;
                this.trackGzSize = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("PerformanceTracker can't work without tracer data.");
            }
        }
    }

    CodeChangeHandler getCodeChangeHandler() {
        return this.codeChange;
    }

    void recordPassStart(String passName, boolean isOneTime) {
        this.currentPass.push(new Stats(passName, isOneTime));
        this.codeChange.reset();
    }

    void recordPassStop(String passName, long runtime) {
        Stats logStats = this.currentPass.pop();
        Preconditions.checkState((boolean)passName.equals(logStats.pass));
        if (passName.equals("parseInputs") && this.trackSize) {
            CodeSizeEstimatePrinter estimatePrinter = new CodeSizeEstimatePrinter();
            CodeGenerator.forCostEstimation(estimatePrinter).add(this.jsRoot);
            this.initCodeSize = this.codeSize = estimatePrinter.calcSize();
            if (this.trackGzSize) {
                this.initGzCodeSize = this.gzCodeSize = estimatePrinter.calcZippedSize();
            }
        }
        this.log.add(logStats);
        Stats summaryStats = this.summary.get(passName);
        if (summaryStats == null) {
            summaryStats = new Stats(passName, logStats.isOneTime);
            this.summary.put(passName, summaryStats);
        }
        logStats.runtime = runtime;
        logStats.runs = 1;
        summaryStats.runtime += runtime;
        ++summaryStats.runs;
        if (this.codeChange.hasCodeChanged()) {
            logStats.changes = 1;
            ++summaryStats.changes;
        }
        if (this.codeChange.hasCodeChanged() && this.trackSize) {
            int newSize = 0;
            CodeSizeEstimatePrinter estimatePrinter = new CodeSizeEstimatePrinter();
            CodeGenerator.forCostEstimation(estimatePrinter).add(this.jsRoot);
            if (this.trackSize) {
                newSize = estimatePrinter.calcSize();
                logStats.diff = this.codeSize - newSize;
                summaryStats.diff += logStats.diff;
                summaryStats.size = logStats.size = newSize;
                this.codeSize = logStats.size;
            }
            if (this.trackGzSize) {
                newSize = estimatePrinter.calcZippedSize();
                logStats.gzDiff = this.gzCodeSize - newSize;
                summaryStats.gzDiff += logStats.gzDiff;
                summaryStats.gzSize = logStats.gzSize = newSize;
                this.gzCodeSize = logStats.gzSize;
            }
        }
    }

    public int getRuntime() {
        this.calcTotalStats();
        return this.runtime;
    }

    public int getSize() {
        this.calcTotalStats();
        return this.codeSize;
    }

    public int getGzSize() {
        this.calcTotalStats();
        return this.gzCodeSize;
    }

    @VisibleForTesting
    int getChanges() {
        this.calcTotalStats();
        return this.changes;
    }

    @VisibleForTesting
    int getLoopChanges() {
        this.calcTotalStats();
        return this.loopChanges;
    }

    @VisibleForTesting
    int getRuns() {
        this.calcTotalStats();
        return this.runs;
    }

    @VisibleForTesting
    int getLoopRuns() {
        this.calcTotalStats();
        return this.loopRuns;
    }

    public ImmutableMap<String, Stats> getStats() {
        this.calcTotalStats();
        return this.summaryCopy;
    }

    private void calcTotalStats() {
        if (this.summaryCopy != null) {
            return;
        }
        this.summaryCopy = ImmutableMap.copyOf(this.summary);
        for (Map.Entry<String, Stats> entry : this.summary.entrySet()) {
            Stats stats = entry.getValue();
            this.runtime = (int)((long)this.runtime + stats.runtime);
            this.runs += stats.runs;
            this.changes += stats.changes;
            if (!stats.isOneTime) {
                this.loopRuns += stats.runs;
                this.loopChanges += stats.changes;
            }
            this.diff += stats.diff;
            this.gzDiff += stats.gzDiff;
        }
        Preconditions.checkState((!this.trackSize || this.initCodeSize == this.diff + this.codeSize ? 1 : 0) != 0);
        Preconditions.checkState((!this.trackGzSize || this.initGzCodeSize == this.gzDiff + this.gzCodeSize ? 1 : 0) != 0);
    }

    public void outputTracerReport(PrintStream pstr) {
        JvmMetrics.maybeWriteJvmMetrics(pstr, "verbose:pretty:all");
        OutputStreamWriter output = new OutputStreamWriter(pstr);
        try {
            this.calcTotalStats();
            ArrayList statEntries = Lists.newArrayList();
            for (Map.Entry<String, Stats> entry : this.summary.entrySet()) {
                statEntries.add(entry);
            }
            Collections.sort(statEntries, new Comparator<Map.Entry<String, Stats>>(){

                @Override
                public int compare(Map.Entry<String, Stats> e1, Map.Entry<String, Stats> e2) {
                    return (int)(e1.getValue().runtime - e2.getValue().runtime);
                }
            });
            output.write("Summary:\npass,runtime,runs,changingRuns,reduction,gzReduction\n");
            for (Map.Entry<String, Stats> entry : statEntries) {
                String key = entry.getKey();
                Stats stats = entry.getValue();
                output.write(String.format("%s,%d,%d,%d,%d,%d\n", key, stats.runtime, stats.runs, stats.changes, stats.diff, stats.gzDiff));
            }
            output.write("\nTOTAL:\nRuntime(ms): " + String.valueOf(this.runtime) + "\n#Runs: " + String.valueOf(this.runs) + "\n#Changing runs: " + String.valueOf(this.changes) + "\n#Loopable runs: " + String.valueOf(this.loopRuns) + "\n#Changing loopable runs: " + String.valueOf(this.loopChanges) + "\nEstimated Reduction(bytes): " + String.valueOf(this.diff) + "\nEstimated GzReduction(bytes): " + String.valueOf(this.gzDiff) + "\nEstimated Size(bytes): " + String.valueOf(this.codeSize) + "\nEstimated GzSize(bytes): " + String.valueOf(this.gzCodeSize) + "\n\n");
            output.write("Log:\npass,runtime,runs,changingRuns,reduction,gzReduction,size,gzSize\n");
            for (Stats stats : this.log) {
                output.write(String.format("%s,%d,%d,%d,%d,%d,%d,%d\n", stats.pass, stats.runtime, stats.runs, stats.changes, stats.diff, stats.gzDiff, stats.size, stats.gzSize));
            }
            output.write("\n");
            output.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write statistics to output.", e);
        }
    }

    private final class CodeSizeEstimatePrinter
    extends CodeConsumer {
        private int size = 0;
        private char lastChar = '\u0000';
        private final ByteArrayOutputStream output = new ByteArrayOutputStream();
        private final GZIPOutputStream stream;

        private CodeSizeEstimatePrinter() {
            try {
                this.stream = new GZIPOutputStream(this.output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        void append(String str) {
            int len = str.length();
            if (len > 0) {
                this.size += len;
                this.lastChar = str.charAt(len - 1);
                if (PerformanceTracker.this.trackGzSize) {
                    try {
                        this.stream.write(str.getBytes());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        @Override
        char getLastChar() {
            return this.lastChar;
        }

        private int calcSize() {
            return this.size;
        }

        private int calcZippedSize() {
            try {
                this.stream.finish();
                this.stream.flush();
                this.stream.close();
                return this.output.size();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Stats {
        public final String pass;
        public final boolean isOneTime;
        public long runtime = 0L;
        public int runs = 0;
        public int changes = 0;
        public int diff = 0;
        public int gzDiff = 0;
        public int size;
        public int gzSize;

        Stats(String pass, boolean iot) {
            this.pass = pass;
            this.isOneTime = iot;
        }
    }
}

