/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.LinkedUndirectedGraph;
import com.google.javascript.jscomp.graph.UndiGraph;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

class RenameProperties
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final boolean generatePseudoNames;
    private final VariableMap prevUsedPropertyMap;
    private final List<Node> stringNodesToRename = new ArrayList<Node>();
    private final Map<Node, Node> callNodeToParentMap = new HashMap<Node, Node>();
    private final char[] reservedCharacters;
    private final Map<String, Property> propertyMap = new HashMap<String, Property>();
    private final UndiGraph<Property, PropertyAffinity> affinityGraph;
    private final Set<String> externedNames = new HashSet<String>(Arrays.asList("prototype"));
    private final Set<String> quotedNames = new HashSet<String>();
    private static final Comparator<Property> FREQUENCY_COMPARATOR = new Comparator<Property>(){

        @Override
        public int compare(Property p1, Property p2) {
            if (p1.numOccurrences != p2.numOccurrences) {
                return p2.numOccurrences - p1.numOccurrences;
            }
            if (p1.affinityScore != p2.affinityScore) {
                return p2.affinityScore - p1.affinityScore;
            }
            return p1.oldName.compareTo(p2.oldName);
        }
    };
    static final String RENAME_PROPERTY_FUNCTION_NAME = "JSCompiler_renameProperty";
    static final DiagnosticType BAD_CALL = DiagnosticType.error("JSC_BAD_RENAME_PROPERTY_FUNCTION_NAME_CALL", "Bad JSCompiler_renameProperty call - argument must be a string literal");
    static final DiagnosticType BAD_ARG = DiagnosticType.error("JSC_BAD_RENAME_PROPERTY_FUNCTION_NAME_ARG", "Bad JSCompiler_renameProperty argument - '{0}' is not a valid JavaScript identifier");

    RenameProperties(AbstractCompiler compiler, boolean affinity, boolean generatePseudoNames) {
        this(compiler, affinity, generatePseudoNames, null, null);
    }

    RenameProperties(AbstractCompiler compiler, boolean affinity, boolean generatePseudoNames, VariableMap prevUsedPropertyMap) {
        this(compiler, affinity, generatePseudoNames, prevUsedPropertyMap, null);
    }

    RenameProperties(AbstractCompiler compiler, boolean affinity, boolean generatePseudoNames, VariableMap prevUsedPropertyMap, @Nullable char[] reservedCharacters) {
        this.compiler = compiler;
        this.generatePseudoNames = generatePseudoNames;
        this.prevUsedPropertyMap = prevUsedPropertyMap;
        this.reservedCharacters = reservedCharacters;
        this.affinityGraph = affinity ? LinkedUndirectedGraph.createWithoutAnnotations() : null;
        this.externedNames.addAll(compiler.getExternProperties());
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverse(this.compiler, root, new ProcessProperties());
        HashSet<String> reservedNames = new HashSet<String>(this.externedNames.size() + this.quotedNames.size());
        reservedNames.addAll(this.externedNames);
        reservedNames.addAll(this.quotedNames);
        if (this.prevUsedPropertyMap != null) {
            this.reusePropertyNames(reservedNames, this.propertyMap.values());
        }
        this.compiler.addToDebugLog("JS property assignments:");
        if (this.affinityGraph != null) {
            this.computeAffinityScores();
        }
        TreeSet<Property> propsByFreq = new TreeSet<Property>(FREQUENCY_COMPARATOR);
        propsByFreq.addAll(this.propertyMap.values());
        this.generateNames(propsByFreq, reservedNames);
        boolean changed = false;
        for (Node node : this.stringNodesToRename) {
            String oldName = node.getString();
            Property p = this.propertyMap.get(oldName);
            if (p == null || p.newName == null) continue;
            Preconditions.checkState((boolean)oldName.equals(p.oldName));
            node.setString(p.newName);
            changed = changed || !p.newName.equals(oldName);
        }
        for (Map.Entry entry : this.callNodeToParentMap.entrySet()) {
            Node parent = (Node)entry.getValue();
            Node firstArg = ((Node)entry.getKey()).getFirstChild().getNext();
            StringBuilder sb = new StringBuilder();
            for (String oldName : firstArg.getString().split("[.]")) {
                String replacement;
                Property p = this.propertyMap.get(oldName);
                if (p != null && p.newName != null) {
                    Preconditions.checkState((boolean)oldName.equals(p.oldName));
                    replacement = p.newName;
                } else {
                    replacement = oldName;
                }
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(replacement);
            }
            parent.replaceChild((Node)entry.getKey(), IR.string(sb.toString()));
            changed = true;
        }
        if (changed) {
            this.compiler.reportCodeChange();
        }
        this.compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.NORMALIZED_OBFUSCATED);
    }

    private void reusePropertyNames(Set<String> reservedNames, Collection<Property> allProps) {
        for (Property prop : allProps) {
            String prevName = this.prevUsedPropertyMap.lookupNewName(prop.oldName);
            if (this.generatePseudoNames || prevName == null || reservedNames.contains(prevName)) continue;
            prop.newName = prevName;
            reservedNames.add(prevName);
        }
    }

    private void computeAffinityScores() {
        for (Property p : this.propertyMap.values()) {
            UndiGraph.UndiGraphNode<Property, PropertyAffinity> node = this.affinityGraph.getUndirectedGraphNode(p);
            int affinityScore = 0;
            Iterator<UndiGraph.UndiGraphEdge<Property, PropertyAffinity>> edgeIterator = node.getNeighborEdgesIterator();
            while (edgeIterator.hasNext()) {
                UndiGraph.UndiGraphEdge<Property, PropertyAffinity> edge = edgeIterator.next();
                affinityScore += ((PropertyAffinity)edge.getValue()).affinity + (node == edge.getNodeA() ? ((Property)edge.getNodeB().getValue()).numOccurrences : ((Property)edge.getNodeA().getValue()).numOccurrences);
            }
            ((Property)node.getValue()).affinityScore = affinityScore;
        }
    }

    private void generateNames(Set<Property> props, Set<String> reservedNames) {
        NameGenerator nameGen = new NameGenerator(reservedNames, "", this.reservedCharacters);
        for (Property p : props) {
            if (this.generatePseudoNames) {
                p.newName = "$" + p.oldName + "$";
            } else if (p.newName == null) {
                p.newName = nameGen.generateNextName();
            }
            reservedNames.add(p.newName);
            this.compiler.addToDebugLog(p.oldName + " => " + p.newName);
        }
    }

    VariableMap getPropertyMap() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Property p : this.propertyMap.values()) {
            if (p.newName == null) continue;
            map.put((Object)p.oldName, (Object)p.newName);
        }
        return new VariableMap((Map<String, String>)map.build());
    }

    private class PropertyAffinity {
        private int affinity = 0;

        private PropertyAffinity(int affinity) {
            this.affinity = affinity;
        }

        private void increase() {
            ++this.affinity;
        }
    }

    private class Property {
        final String oldName;
        String newName;
        int numOccurrences;
        int affinityScore = 0;

        Property(String name) {
            this.oldName = name;
        }
    }

    private class ProcessProperties
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        private Set<Property> currentHighAffinityProperties = null;

        private ProcessProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 33: {
                    Node propNode = n.getFirstChild().getNext();
                    if (!propNode.isString()) break;
                    this.maybeMarkCandidate(propNode);
                    break;
                }
                case 64: {
                    for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                        if (!key.isQuotedString()) {
                            this.maybeMarkCandidate(key);
                            continue;
                        }
                        RenameProperties.this.quotedNames.add(key.getString());
                    }
                    break;
                }
                case 35: {
                    Node child = n.getLastChild();
                    if (child == null || !child.isString()) break;
                    RenameProperties.this.quotedNames.add(child.getString());
                    break;
                }
                case 37: {
                    Node fnName = n.getFirstChild();
                    if (!fnName.isName() || !RenameProperties.RENAME_PROPERTY_FUNCTION_NAME.equals(fnName.getString())) break;
                    RenameProperties.this.callNodeToParentMap.put(n, parent);
                    this.countCallCandidates(t, n);
                    break;
                }
                case 105: {
                    Node varNode;
                    if (NodeUtil.isFunctionDeclaration(n)) {
                        String name = n.getFirstChild().getString();
                        if (!RenameProperties.RENAME_PROPERTY_FUNCTION_NAME.equals(name)) break;
                        if (parent.isExprResult()) {
                            parent.detachFromParent();
                        } else {
                            parent.removeChild(n);
                        }
                        RenameProperties.this.compiler.reportCodeChange();
                        break;
                    }
                    if (!parent.isName() || !RenameProperties.RENAME_PROPERTY_FUNCTION_NAME.equals(parent.getString()) || !(varNode = parent.getParent()).isVar()) break;
                    varNode.removeChild(parent);
                    if (!varNode.hasChildren()) {
                        varNode.detachFromParent();
                    }
                    RenameProperties.this.compiler.reportCodeChange();
                }
            }
        }

        private void maybeMarkCandidate(Node n) {
            String name = n.getString();
            if (!RenameProperties.this.externedNames.contains(name)) {
                RenameProperties.this.stringNodesToRename.add(n);
                this.countPropertyOccurrence(name);
            }
        }

        private void countCallCandidates(NodeTraversal t, Node callNode) {
            Node firstArg = callNode.getFirstChild().getNext();
            if (!firstArg.isString()) {
                t.report(callNode, BAD_CALL, new String[0]);
                return;
            }
            for (String name : firstArg.getString().split("[.]")) {
                if (!TokenStream.isJSIdentifier(name)) {
                    t.report(callNode, BAD_ARG, name);
                    continue;
                }
                if (RenameProperties.this.externedNames.contains(name)) continue;
                this.countPropertyOccurrence(name);
            }
        }

        private void countPropertyOccurrence(String name) {
            Property prop = (Property)RenameProperties.this.propertyMap.get(name);
            if (prop == null) {
                prop = new Property(name);
                RenameProperties.this.propertyMap.put(name, prop);
                if (RenameProperties.this.affinityGraph != null) {
                    RenameProperties.this.affinityGraph.createNode(prop);
                }
            }
            ++prop.numOccurrences;
            if (this.currentHighAffinityProperties != null) {
                this.currentHighAffinityProperties.add(prop);
            }
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (!t.inGlobalScope() && t.getScope().getParent().isGlobal()) {
                this.currentHighAffinityProperties = Sets.newHashSet();
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            if (RenameProperties.this.affinityGraph == null) {
                return;
            }
            if (!t.inGlobalScope() && t.getScope().getParent().isGlobal()) {
                for (Property p1 : this.currentHighAffinityProperties) {
                    for (Property p2 : this.currentHighAffinityProperties) {
                        if (p1.oldName.compareTo(p2.oldName) >= 0) continue;
                        Graph.GraphEdge edge = RenameProperties.this.affinityGraph.getFirstEdge(p1, p2);
                        if (edge == null) {
                            RenameProperties.this.affinityGraph.connect(p1, new PropertyAffinity(1), p2);
                            continue;
                        }
                        ((PropertyAffinity)edge.getValue()).increase();
                    }
                }
                this.currentHighAffinityProperties = null;
            }
        }
    }
}

