/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SyntheticAst;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.javascript.jscomp.fuzzing.ScopeManager;
import com.google.javascript.jscomp.fuzzing.ScriptFuzzer;
import com.google.javascript.jscomp.fuzzing.Symbol;
import com.google.javascript.rhino.Node;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Driver {
    @Option(name="--number_of_runs", usage="The number of runs of the fuzzer. If this option is missing, the driver will run forever")
    private int numberOfRuns = -1;
    @Option(name="--max_ast_size", usage="The max number of nodes in the generated ASTs. Default: 100")
    private int maxASTSize;
    @Option(name="--compilation_level", usage="Specifies the compilation level to use. Default: SIMPLE_OPTIMIZATIONS")
    private CompilationLevel compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
    @Option(name="--seed", usage="Specifies the seed for the fuzzer. It will override --number_of_runs to 1. If not given, System.currentTimeMillis() will be used")
    private long seed = -1L;
    @Option(name="--logging_level", usage="Specifies the logging level for the driver. Default: INFO")
    private LoggingLevel level = LoggingLevel.INFO;
    @Option(name="--config", required=true, usage="Specifies the configuration file")
    private String configFileName;
    @Option(name="--execute", usage="Whether to execute the generated JavaScript")
    private boolean execute = false;
    @Option(name="--stop_on_error", usage="Whether to stop fuzzing once an error is found")
    private boolean stopOnError = false;
    private Logger logger;
    private JSONObject config;

    public Result compile(String code) throws IOException {
        Compiler.setLoggingLevel(this.level.getLevel());
        Compiler compiler = new Compiler();
        return compiler.compile(CommandLineRunner.getDefaultExterns(), Arrays.asList(SourceFile.fromCode("[fuzzedCode]", code)), this.getOptions());
    }

    public Result compile(Node script) throws IOException {
        CompilerInput input = new CompilerInput(new SyntheticAst(script));
        JSModule jsModule = new JSModule("fuzzedModule");
        jsModule.add(input);
        Compiler.setLoggingLevel(this.level.getLevel());
        Compiler compiler = new Compiler();
        compiler.setTimeout(30);
        compiler.disableThreads();
        return compiler.compileModules(CommandLineRunner.getDefaultExterns(), Arrays.asList(jsModule), this.getOptions());
    }

    private CompilerOptions getOptions() {
        CompilerOptions options = new CompilerOptions();
        this.compilationLevel.setOptionsForCompilationLevel(options);
        options.variableRenaming = VariableRenamingPolicy.OFF;
        return options;
    }

    private JSONObject getConfig() {
        if (this.config == null) {
            File file = new File(this.configFileName);
            try {
                this.config = new JSONObject(Files.toString((File)file, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException | JSONException e) {
                e.printStackTrace();
            }
        }
        return this.config;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(Driver.class.getName());
            this.logger.setLevel(this.level.getLevel());
            for (Handler handler : this.logger.getHandlers()) {
                handler.setLevel(Level.ALL);
            }
        }
        return this.logger;
    }

    private Node fuzz(FuzzingContext context) {
        ScriptFuzzer fuzzer = new ScriptFuzzer(context);
        return fuzzer.generate(this.maxASTSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeJS(String js1, String js2) {
        ExecutorService executor = Executors.newCachedThreadPool();
        NodeRunner node1 = new NodeRunner(js1);
        NodeRunner node2 = new NodeRunner(js2);
        String[] output1 = null;
        String[] output2 = null;
        try {
            Future future2;
            List futures = executor.invokeAll(Lists.newArrayList((Object[])new NodeRunner[]{node1, node2}), this.maxASTSize, TimeUnit.MILLISECONDS);
            Future future1 = futures.get(0);
            if (!future1.isCancelled()) {
                output1 = (String[])future1.get();
            }
            if (!(future2 = futures.get(1)).isCancelled()) {
                output2 = (String[])future2.get();
            }
        }
        catch (InterruptedException e) {
            this.getLogger().log(Level.INFO, "Timeout in executing JavaScript", e);
        }
        catch (ExecutionException e) {
            this.getLogger().log(Level.SEVERE, "Error in executing JavaScript", e);
        }
        finally {
            node1.process.destroy();
            node2.process.destroy();
        }
        if (output1 == null && output2 == null) {
            this.getLogger().info("Infinite loop!");
            return true;
        }
        if (NodeRunner.isSame(output1, output2)) {
            boolean hasError = false;
            if (output1 != null && output1[1].length() > 0) {
                this.getLogger().warning("First JavaScript has a runtime error: " + output1[1]);
                hasError = true;
            }
            if (output2 != null && output2[1].length() > 0) {
                this.getLogger().warning("Second JavaScript has a runtime error: " + output2[1]);
                hasError = true;
            }
            return !hasError || this.getLogger().getLevel().intValue() >= Level.WARNING.intValue();
        }
        StringBuilder sb = new StringBuilder("Different outputs!");
        sb.append("\nOutput 1:");
        if (output1 != null) {
            sb.append(output1[0]).append(output1[1]);
        } else {
            sb.append("null");
        }
        sb.append("\nOutput 2:");
        if (output2 != null) {
            sb.append(output2[0]).append(output2[1]);
        } else {
            sb.append("null");
        }
        this.getLogger().severe(sb.toString());
        return false;
    }

    private void run() {
        if (this.seed != -1L) {
            this.numberOfRuns = 1;
        }
        for (int i = 0; this.numberOfRuns == -1 || i < this.numberOfRuns; ++i) {
            StringBuffer debugInfo;
            String code1;
            Node script;
            FuzzingContext context;
            block12: {
                long currentSeed = this.seed == -1L ? System.currentTimeMillis() : this.seed;
                this.getLogger().info("Running fuzzer [" + i + " of " + this.numberOfRuns + "]");
                Random random = currentSeed == -1L ? new Random(currentSeed) : new Random(currentSeed);
                context = new FuzzingContext(random, this.getConfig(), this.execute);
                script = null;
                try {
                    script = this.fuzz(context);
                }
                catch (RuntimeException e) {
                    this.getLogger().log(Level.SEVERE, "Fuzzer error: ", e);
                    if (!this.stopOnError) continue;
                    break;
                }
                code1 = ScriptFuzzer.getPrettyCode(script);
                debugInfo = new StringBuffer("Seed: ").append(currentSeed);
                debugInfo.append("\nJavaScript: ").append(code1);
                try {
                    Result result = this.compile(script);
                    if (result.success) {
                        if (result.warnings.length == 0) {
                            this.getLogger().info(debugInfo.toString());
                        } else {
                            this.getLogger().warning(debugInfo.toString());
                        }
                    } else {
                        this.getLogger().severe(debugInfo.toString());
                        if (this.stopOnError) {
                        }
                    }
                    break block12;
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Compiler Crashed!", e);
                    this.getLogger().severe(debugInfo.toString());
                    if (!this.stopOnError) break block12;
                }
                break;
            }
            String code2 = ScriptFuzzer.getPrettyCode(script);
            debugInfo.append("\nCompiled Code: " + code2);
            String setUpCode = this.getSetupCode(context.scopeManager);
            if (this.execute && !this.executeJS(setUpCode + code1, setUpCode + code2)) {
                this.getLogger().severe(debugInfo.toString());
                if (this.stopOnError) break;
            }
            this.getLogger().info(debugInfo.toString());
        }
    }

    private String getSetupCode(ScopeManager scopeManager) {
        Collection vars = Collections2.transform((Collection)Lists.newArrayList(scopeManager.localScope().symbols), (Function)new Function<Symbol, String>(){

            public String apply(Symbol s) {
                return "'" + s.name + "'=" + s.name;
            }
        });
        String setUpCode = "function toString(value) {\n    if (value instanceof Array) {\n        var string = \"[\";\n        for (var i in value) {\n            string += toString(value[i]) + \",\";\n        }\n        string += ']';\n        return string;\n    } else if (value instanceof Function) {\n        return value.length;\n    } else {\n        return value;\n    }\n}\n\nprocess.on('uncaughtException', function(e) {\n    console.log(\"Errors: \");\n    if (e instanceof Error) {\n        console.log(e.name);\n    } else {\n        console.log(typeof(e));\n    }\n});\n\nprocess.on(\"exit\", function(e) {\n    console.log(\"Variables:\");\n    var allvars = " + vars + ";\n" + "    console.log(toString(allvars));\n" + "});\n" + "";
        return setUpCode;
    }

    public static void main(String[] args) throws Exception {
        Driver driver = new Driver();
        CmdLineParser parser = new CmdLineParser((Object)driver);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage((OutputStream)System.err);
            System.exit(1);
        }
        driver.run();
        System.exit(0);
    }

    static class NodeRunner
    implements Callable<String[]> {
        private String js;
        private Process process;

        NodeRunner(String js) {
            this.js = js;
        }

        @Override
        public String[] call() throws IOException {
            String[] command = new String[]{"node", "-e", this.js};
            Runtime runtime = Runtime.getRuntime();
            this.process = runtime.exec(command);
            String[] results = new String[]{CharStreams.toString((Readable)new InputStreamReader(this.process.getInputStream())), CharStreams.toString((Readable)new InputStreamReader(this.process.getErrorStream()))};
            return results;
        }

        public static boolean isSame(String[] output1, String[] output2) {
            if (output1 == null && output2 == null) {
                return true;
            }
            if (output1 == null || output2 == null) {
                return false;
            }
            return output1[0].equals(output2[0]);
        }
    }

    static enum LoggingLevel {
        OFF(Level.OFF),
        SEVERE(Level.SEVERE),
        WARNING(Level.WARNING),
        INFO(Level.INFO),
        CONFIG(Level.CONFIG),
        FINE(Level.FINE),
        FINER(Level.FINER),
        FINEST(Level.FINEST),
        ALL(Level.ALL);

        private Level level;

        private LoggingLevel(Level l) {
            this.level = l;
        }

        public Level getLevel() {
            return this.level;
        }
    }
}

