package com.google.javascript.jscomp.bundle;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import javax.annotation.processing.Generated;
import org.jspecify.nullness.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Source extends Source {

  private final Path path;

  private final String sourceMap;

  private final String sourceUrl;

  private final String sourceMappingUrl;

  private final ImmutableSet<String> runtimes;

  private final ImmutableMap<String, String> loadFlags;

  private final int estimatedSize;

  private final Source.Lazy<String> codeSupplier;

  private final Source.@Nullable Lazy<String> originalCodeSupplier;

  private AutoValue_Source(
      Path path,
      String sourceMap,
      String sourceUrl,
      String sourceMappingUrl,
      ImmutableSet<String> runtimes,
      ImmutableMap<String, String> loadFlags,
      int estimatedSize,
      Source.Lazy<String> codeSupplier,
      Source.@Nullable Lazy<String> originalCodeSupplier) {
    this.path = path;
    this.sourceMap = sourceMap;
    this.sourceUrl = sourceUrl;
    this.sourceMappingUrl = sourceMappingUrl;
    this.runtimes = runtimes;
    this.loadFlags = loadFlags;
    this.estimatedSize = estimatedSize;
    this.codeSupplier = codeSupplier;
    this.originalCodeSupplier = originalCodeSupplier;
  }

  @Override
  public Path path() {
    return path;
  }

  @Override
  public String sourceMap() {
    return sourceMap;
  }

  @Override
  public String sourceUrl() {
    return sourceUrl;
  }

  @Override
  public String sourceMappingUrl() {
    return sourceMappingUrl;
  }

  @Override
  public ImmutableSet<String> runtimes() {
    return runtimes;
  }

  @Override
  public ImmutableMap<String, String> loadFlags() {
    return loadFlags;
  }

  @Override
  public int estimatedSize() {
    return estimatedSize;
  }

  @Override
  Source.Lazy<String> codeSupplier() {
    return codeSupplier;
  }

  @Override
  Source.@Nullable Lazy<String> originalCodeSupplier() {
    return originalCodeSupplier;
  }

  @Override
  public String toString() {
    return "Source{"
        + "path=" + path + ", "
        + "sourceMap=" + sourceMap + ", "
        + "sourceUrl=" + sourceUrl + ", "
        + "sourceMappingUrl=" + sourceMappingUrl + ", "
        + "runtimes=" + runtimes + ", "
        + "loadFlags=" + loadFlags + ", "
        + "estimatedSize=" + estimatedSize + ", "
        + "codeSupplier=" + codeSupplier + ", "
        + "originalCodeSupplier=" + originalCodeSupplier
        + "}";
  }

  @Override
  public boolean equals(@Nullable Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Source) {
      Source that = (Source) o;
      return this.path.equals(that.path())
          && this.sourceMap.equals(that.sourceMap())
          && this.sourceUrl.equals(that.sourceUrl())
          && this.sourceMappingUrl.equals(that.sourceMappingUrl())
          && this.runtimes.equals(that.runtimes())
          && this.loadFlags.equals(that.loadFlags())
          && this.estimatedSize == that.estimatedSize()
          && this.codeSupplier.equals(that.codeSupplier())
          && (this.originalCodeSupplier == null ? that.originalCodeSupplier() == null : this.originalCodeSupplier.equals(that.originalCodeSupplier()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= path.hashCode();
    h$ *= 1000003;
    h$ ^= sourceMap.hashCode();
    h$ *= 1000003;
    h$ ^= sourceUrl.hashCode();
    h$ *= 1000003;
    h$ ^= sourceMappingUrl.hashCode();
    h$ *= 1000003;
    h$ ^= runtimes.hashCode();
    h$ *= 1000003;
    h$ ^= loadFlags.hashCode();
    h$ *= 1000003;
    h$ ^= estimatedSize;
    h$ *= 1000003;
    h$ ^= codeSupplier.hashCode();
    h$ *= 1000003;
    h$ ^= (originalCodeSupplier == null) ? 0 : originalCodeSupplier.hashCode();
    return h$;
  }

  @Override
  public Source.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Source.Builder {
    private @Nullable Path path;
    private @Nullable String sourceMap;
    private @Nullable String sourceUrl;
    private @Nullable String sourceMappingUrl;
    private @Nullable ImmutableSet<String> runtimes;
    private @Nullable ImmutableMap<String, String> loadFlags;
    private int estimatedSize;
    private Source.@Nullable Lazy<String> codeSupplier;
    private Source.@Nullable Lazy<String> originalCodeSupplier;
    private byte set$0;
    Builder() {
    }
    private Builder(Source source) {
      this.path = source.path();
      this.sourceMap = source.sourceMap();
      this.sourceUrl = source.sourceUrl();
      this.sourceMappingUrl = source.sourceMappingUrl();
      this.runtimes = source.runtimes();
      this.loadFlags = source.loadFlags();
      this.estimatedSize = source.estimatedSize();
      this.codeSupplier = source.codeSupplier();
      this.originalCodeSupplier = source.originalCodeSupplier();
      set$0 = (byte) 1;
    }
    @Override
    public Source.Builder setPath(Path path) {
      if (path == null) {
        throw new NullPointerException("Null path");
      }
      this.path = path;
      return this;
    }
    @Override
    public Source.Builder setSourceMap(String sourceMap) {
      if (sourceMap == null) {
        throw new NullPointerException("Null sourceMap");
      }
      this.sourceMap = sourceMap;
      return this;
    }
    @Override
    public Source.Builder setSourceUrl(String sourceUrl) {
      if (sourceUrl == null) {
        throw new NullPointerException("Null sourceUrl");
      }
      this.sourceUrl = sourceUrl;
      return this;
    }
    @Override
    public Source.Builder setSourceMappingUrl(String sourceMappingUrl) {
      if (sourceMappingUrl == null) {
        throw new NullPointerException("Null sourceMappingUrl");
      }
      this.sourceMappingUrl = sourceMappingUrl;
      return this;
    }
    @Override
    public Source.Builder setRuntimes(ImmutableSet<String> runtimes) {
      if (runtimes == null) {
        throw new NullPointerException("Null runtimes");
      }
      this.runtimes = runtimes;
      return this;
    }
    @Override
    ImmutableSet<String> runtimes() {
      if (this.runtimes == null) {
        throw new IllegalStateException("Property \"runtimes\" has not been set");
      }
      return runtimes;
    }
    @Override
    public Source.Builder setLoadFlags(ImmutableMap<String, String> loadFlags) {
      if (loadFlags == null) {
        throw new NullPointerException("Null loadFlags");
      }
      this.loadFlags = loadFlags;
      return this;
    }
    @Override
    public Source.Builder setEstimatedSize(int estimatedSize) {
      this.estimatedSize = estimatedSize;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    Source.Builder setCodeSupplier(Source.Lazy<String> codeSupplier) {
      if (codeSupplier == null) {
        throw new NullPointerException("Null codeSupplier");
      }
      this.codeSupplier = codeSupplier;
      return this;
    }
    @Override
    Source.Lazy<String> codeSupplier() {
      if (this.codeSupplier == null) {
        throw new IllegalStateException("Property \"codeSupplier\" has not been set");
      }
      return codeSupplier;
    }
    @Override
    Source.Builder setOriginalCodeSupplier(Source.@Nullable Lazy<String> originalCodeSupplier) {
      this.originalCodeSupplier = originalCodeSupplier;
      return this;
    }
    @Override
    Source.@Nullable Lazy<String> originalCodeSupplier() {
      return originalCodeSupplier;
    }
    @Override
    Source autoBuild() {
      if (set$0 != 1
          || this.path == null
          || this.sourceMap == null
          || this.sourceUrl == null
          || this.sourceMappingUrl == null
          || this.runtimes == null
          || this.loadFlags == null
          || this.codeSupplier == null) {
        StringBuilder missing = new StringBuilder();
        if (this.path == null) {
          missing.append(" path");
        }
        if (this.sourceMap == null) {
          missing.append(" sourceMap");
        }
        if (this.sourceUrl == null) {
          missing.append(" sourceUrl");
        }
        if (this.sourceMappingUrl == null) {
          missing.append(" sourceMappingUrl");
        }
        if (this.runtimes == null) {
          missing.append(" runtimes");
        }
        if (this.loadFlags == null) {
          missing.append(" loadFlags");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" estimatedSize");
        }
        if (this.codeSupplier == null) {
          missing.append(" codeSupplier");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Source(
          this.path,
          this.sourceMap,
          this.sourceUrl,
          this.sourceMappingUrl,
          this.runtimes,
          this.loadFlags,
          this.estimatedSize,
          this.codeSupplier,
          this.originalCodeSupplier);
    }
  }

}
