/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.testing.compile.AutoValue_Compiler;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompilationFailureException;
import com.google.testing.compile.InMemoryJavaFileManager;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
public abstract class Compiler {
    @VisibleForTesting
    static final @Nullable ClassLoader platformClassLoader = Compiler.getPlatformClassLoader();

    public static Compiler javac() {
        return Compiler.compiler(ToolProvider.getSystemJavaCompiler());
    }

    public static Compiler compiler(JavaCompiler javaCompiler) {
        return new AutoValue_Compiler(javaCompiler, (ImmutableList<Processor>)ImmutableList.of(), (ImmutableList<String>)ImmutableList.of(), Optional.empty(), Optional.empty());
    }

    abstract JavaCompiler javaCompiler();

    public abstract ImmutableList<Processor> processors();

    public abstract ImmutableList<String> options();

    public abstract Optional<ImmutableList<File>> classPath();

    public abstract Optional<ImmutableList<File>> annotationProcessorPath();

    public final Compiler withProcessors(Processor ... processors) {
        return this.withProcessors((Iterable<? extends Processor>)ImmutableList.copyOf((Object[])processors));
    }

    public final Compiler withProcessors(Iterable<? extends Processor> processors) {
        return this.copy((ImmutableList<Processor>)ImmutableList.copyOf(processors), this.options(), this.classPath(), this.annotationProcessorPath());
    }

    public final Compiler withOptions(Object ... options) {
        return this.withOptions((Iterable<? extends Object>)ImmutableList.copyOf((Object[])options));
    }

    public final Compiler withOptions(Iterable<? extends Object> options) {
        return this.copy(this.processors(), (ImmutableList<String>)FluentIterable.from(options).transform(Functions.toStringFunction()).toList(), this.classPath(), this.annotationProcessorPath());
    }

    @Deprecated
    public final Compiler withClasspathFrom(ClassLoader classloader) {
        return this.copy(this.processors(), this.options(), Optional.of(Compiler.getClasspathFromClassloader(classloader)), this.annotationProcessorPath());
    }

    public final Compiler withClasspath(Iterable<File> classPath) {
        return this.copy(this.processors(), this.options(), Optional.of(ImmutableList.copyOf(classPath)), this.annotationProcessorPath());
    }

    public final Compiler withAnnotationProcessorPath(Iterable<File> annotationProcessorPath) {
        return this.copy(this.processors(), this.options(), this.classPath(), Optional.of(ImmutableList.copyOf(annotationProcessorPath)));
    }

    public final Compilation compile(JavaFileObject ... files) {
        return this.compile((Iterable<? extends JavaFileObject>)ImmutableList.copyOf((Object[])files));
    }

    public final Compilation compile(Iterable<? extends JavaFileObject> files) {
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        InMemoryJavaFileManager fileManager = new InMemoryJavaFileManager(this.javaCompiler().getStandardFileManager(diagnosticCollector, Locale.getDefault(), StandardCharsets.UTF_8));
        fileManager.addSourceFiles(files);
        this.classPath().ifPresent(path -> Compiler.setLocation(fileManager, StandardLocation.CLASS_PATH, (ImmutableList<File>)path));
        this.annotationProcessorPath().ifPresent(path -> Compiler.setLocation(fileManager, StandardLocation.ANNOTATION_PROCESSOR_PATH, (ImmutableList<File>)path));
        JavaCompiler.CompilationTask task = this.javaCompiler().getTask(null, fileManager, diagnosticCollector, (Iterable<String>)this.options(), (Iterable<String>)ImmutableSet.of(), files);
        task.setProcessors((Iterable<? extends Processor>)this.processors());
        boolean succeeded = task.call();
        Compilation compilation = new Compilation(this, files, succeeded, (Iterable<Diagnostic<? extends JavaFileObject>>)diagnosticCollector.getDiagnostics(), (Iterable<JavaFileObject>)fileManager.getOutputFiles());
        if (compilation.status().equals((Object)Compilation.Status.FAILURE) && compilation.errors().isEmpty()) {
            throw new CompilationFailureException(compilation);
        }
        return compilation;
    }

    private static @Nullable ClassLoader getPlatformClassLoader() {
        try {
            return (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private static ImmutableList<File> getClasspathFromClassloader(ClassLoader classloader) {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        LinkedHashSet<String> classpaths = new LinkedHashSet<String>();
        ClassLoader currentClassloader = classloader;
        while (true) {
            if (currentClassloader == systemClassLoader) {
                Iterables.addAll(classpaths, (Iterable)Splitter.on((String)StandardSystemProperty.PATH_SEPARATOR.value()).split((CharSequence)StandardSystemProperty.JAVA_CLASS_PATH.value()));
                break;
            }
            if (currentClassloader == platformClassLoader) break;
            if (currentClassloader instanceof URLClassLoader) {
                for (URL url : ((URLClassLoader)currentClassloader).getURLs()) {
                    if (!url.getProtocol().equals("file")) {
                        throw new IllegalArgumentException("Given classloader consists of classpaths which are unsupported for compilation.");
                    }
                    classpaths.add(url.getPath());
                }
            } else {
                throw new IllegalArgumentException(String.format("Classpath for compilation could not be extracted since %s is not an instance of URLClassloader", currentClassloader));
            }
            currentClassloader = currentClassloader.getParent();
        }
        return (ImmutableList)classpaths.stream().map(File::new).collect(ImmutableList.toImmutableList());
    }

    private static void setLocation(InMemoryJavaFileManager fileManager, StandardLocation location, ImmutableList<File> path) {
        try {
            fileManager.setLocation(location, (Iterable<? extends File>)path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Compiler copy(ImmutableList<Processor> processors, ImmutableList<String> options, Optional<ImmutableList<File>> classPath, Optional<ImmutableList<File>> annotationProcessorPath) {
        return new AutoValue_Compiler(this.javaCompiler(), processors, options, classPath, annotationProcessorPath);
    }
}

