/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.testing.junit.testparameterinjector.ExecutableValidationResult;
import com.google.testing.junit.testparameterinjector.TestInfo;
import com.google.testing.junit.testparameterinjector.TestMethodProcessorList;
import com.google.testing.junit.testparameterinjector.TestParameterInjectorUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MemberValueConsumer;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

abstract class PluggableTestRunner
extends BlockJUnit4ClassRunner {
    private static final ThreadLocal<TestInfo> currentTestInfo = new ThreadLocal();
    private TestMethodProcessorList testMethodProcessors;

    protected PluggableTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    @Deprecated
    protected TestMethodProcessorList createTestMethodProcessorList() {
        return TestMethodProcessorList.createNewParameterizedProcessors();
    }

    protected void finalizeCreatedTestInstance(Object testInstance) {
    }

    protected ImmutableList<FrameworkMethod> sortTestMethods(ImmutableList<FrameworkMethod> methods) {
        return methods;
    }

    protected ImmutableList<Class<? extends Annotation>> getSupportedTestAnnotations() {
        return ImmutableList.of(Test.class);
    }

    protected List<TestRule> getExtraTestRules() {
        return ImmutableList.of();
    }

    public final ImmutableList<FrameworkMethod> computeTestMethods() {
        return this.sortTestMethods((ImmutableList<FrameworkMethod>)FluentIterable.from(this.getSupportedTestAnnotations()).transformAndConcat(annotation -> this.getTestClass().getAnnotatedMethods(annotation)).transformAndConcat(this::processMethod).toList());
    }

    private ImmutableList<FrameworkMethod> processMethod(FrameworkMethod initialMethod) {
        return FluentIterable.from(this.getTestMethodProcessors().calculateTestInfos(initialMethod.getMethod(), this.getTestClass().getJavaClass())).transform(testInfo -> new OverriddenFrameworkMethod(testInfo.getMethod(), (TestInfo)testInfo)).toList();
    }

    public final Statement methodBlock(final FrameworkMethod method) {
        Object testObject;
        try {
            testObject = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return PluggableTestRunner.this.createTestForMethod(method);
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        Statement statement = this.methodInvoker(method, testObject);
        statement = this.possiblyExpectingExceptions(method, testObject, statement);
        statement = this.withPotentialTimeoutInternal(method, testObject, statement);
        statement = this.withBefores(method, testObject, statement);
        statement = this.withAfters(method, testObject, statement);
        statement = this.withRules(method, testObject, statement);
        statement = this.withInterruptIsolation(statement);
        return statement;
    }

    private Statement withPotentialTimeoutInternal(FrameworkMethod method, Object test, Statement next) {
        Test testAnnotation = (Test)method.getAnnotation(Test.class);
        if (testAnnotation == null) {
            return next;
        }
        if (testAnnotation.timeout() <= 0L) {
            return next;
        }
        return FailOnTimeout.builder().withTimeout(testAnnotation.timeout(), TimeUnit.MILLISECONDS).build(next);
    }

    public final Statement methodInvoker(final FrameworkMethod frameworkMethod, final Object testObject) {
        TestInfo testInfo = ((OverriddenFrameworkMethod)frameworkMethod).getTestInfo();
        if (testInfo.getMethod().getParameterTypes().length == 0) {
            return super.methodInvoker(frameworkMethod, testObject);
        }
        final List<Object> parameters = this.getTestMethodProcessors().getTestMethodParameters(testInfo);
        return new Statement(){

            public void evaluate() throws Throwable {
                frameworkMethod.invokeExplosively(testObject, parameters.toArray());
            }
        };
    }

    private Statement withRules(FrameworkMethod method, Object target, Statement statement) {
        Description testDescription = this.describeChild(method);
        TestClass testClass = this.getTestClass();
        LinkedListMultimap orderToRulesMultimap = LinkedListMultimap.create();
        MemberValueConsumer collector = (frameworkMember, rule) -> {
            int order;
            Rule ruleAnnotation = (Rule)frameworkMember.getAnnotation(Rule.class);
            int n = order = ruleAnnotation == null ? -1 : ruleAnnotation.order();
            if (orderToRulesMultimap.containsValue(rule) && rule instanceof MethodRule && rule instanceof TestRule) {
                orderToRulesMultimap.remove((Object)order, rule);
            }
            orderToRulesMultimap.put((Object)order, rule);
        };
        testClass.collectAnnotatedMethodValues(target, Rule.class, MethodRule.class, (arg_0, arg_1) -> ((MemberValueConsumer)collector).accept(arg_0, arg_1));
        testClass.collectAnnotatedFieldValues(target, Rule.class, MethodRule.class, (arg_0, arg_1) -> ((MemberValueConsumer)collector).accept(arg_0, arg_1));
        testClass.collectAnnotatedMethodValues(target, Rule.class, TestRule.class, (arg_0, arg_1) -> ((MemberValueConsumer)collector).accept(arg_0, arg_1));
        testClass.collectAnnotatedFieldValues(target, Rule.class, TestRule.class, (arg_0, arg_1) -> ((MemberValueConsumer)collector).accept(arg_0, arg_1));
        ArrayList keys = new ArrayList(orderToRulesMultimap.keySet());
        Collections.sort(keys);
        ImmutableList orderedRules = FluentIterable.from(keys).transformAndConcat(key -> Lists.reverse((List)orderToRulesMultimap.get(key))).toList();
        for (Object rule2 : Lists.reverse((List)orderedRules)) {
            if (rule2 instanceof TestRule) {
                statement = ((TestRule)rule2).apply(statement, testDescription);
                continue;
            }
            if (rule2 instanceof MethodRule) {
                statement = ((MethodRule)rule2).apply(statement, method, target);
                continue;
            }
            throw new AssertionError(rule2);
        }
        for (TestRule testRule : this.getExtraTestRules()) {
            statement = testRule.apply(statement, testDescription);
        }
        statement = new ContextMethodRule().apply(statement, method, target);
        return statement;
    }

    private Object createTestForMethod(FrameworkMethod method) throws Exception {
        Object testInstance;
        TestInfo testInfo = ((OverriddenFrameworkMethod)method).getTestInfo();
        Constructor<?> constructor = TestParameterInjectorUtils.getOnlyConstructor(this.getTestClass().getJavaClass());
        if (constructor.getParameterTypes().length == 0) {
            testInstance = this.createTest();
        } else {
            List<Object> constructorParameters = this.getTestMethodProcessors().getConstructorParameters(constructor, testInfo);
            try {
                testInstance = constructor.newInstance(constructorParameters.toArray());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.getTestMethodProcessors().postProcessTestInstance(testInstance, testInfo);
        this.finalizeCreatedTestInstance(testInstance);
        return testInstance;
    }

    protected final void validateZeroArgConstructor(List<Throwable> errorsReturned) {
        ExecutableValidationResult validationResult = this.getTestMethodProcessors().validateConstructor(TestParameterInjectorUtils.getOnlyConstructor(this.getTestClass().getJavaClass()));
        if (validationResult.wasValidated()) {
            errorsReturned.addAll((Collection<Throwable>)validationResult.validationErrors());
        } else {
            super.validateZeroArgConstructor(errorsReturned);
        }
    }

    protected final void validateTestMethods(List<Throwable> errorsReturned) {
        ImmutableList testMethods = FluentIterable.from(this.getSupportedTestAnnotations()).transformAndConcat(annotation -> this.getTestClass().getAnnotatedMethods(annotation)).toList();
        for (FrameworkMethod testMethod : testMethods) {
            ExecutableValidationResult validationResult = this.getTestMethodProcessors().validateTestMethod(testMethod.getMethod(), this.getTestClass().getJavaClass());
            if (Modifier.isStatic(testMethod.getMethod().getModifiers())) {
                errorsReturned.add(new Exception(String.format("Method %s() should not be static", testMethod.getName())));
            }
            if (!Modifier.isPublic(testMethod.getMethod().getModifiers())) {
                errorsReturned.add(new Exception(String.format("Method %s() should be public", testMethod.getName())));
            }
            if (validationResult.wasValidated()) {
                errorsReturned.addAll((Collection<Throwable>)validationResult.validationErrors());
                continue;
            }
            testMethod.validatePublicVoidNoArg(false, errorsReturned);
        }
    }

    protected final void collectInitializationErrors(List<Throwable> errors) {
        super.collectInitializationErrors(errors);
        if (!errors.isEmpty()) {
            throw new RuntimeException(String.format("Found %s issues while initializing the test runner:\n\n  - %s\n\n\n", errors.size(), FluentIterable.from(errors).transform(Throwables::getStackTraceAsString).join(Joiner.on((String)"\n\n\n  - "))));
        }
    }

    protected final Object createTest() throws Exception {
        return super.createTest();
    }

    protected final void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        super.validatePublicVoidNoArgMethods(annotation, isStatic, errors);
    }

    private synchronized TestMethodProcessorList getTestMethodProcessors() {
        if (this.testMethodProcessors == null) {
            this.testMethodProcessors = this.createTestMethodProcessorList();
        }
        return this.testMethodProcessors;
    }

    private static class OverriddenFrameworkMethod
    extends FrameworkMethod {
        private final TestInfo testInfo;

        public OverriddenFrameworkMethod(Method method, TestInfo testInfo) {
            super(method);
            this.testInfo = testInfo;
        }

        public TestInfo getTestInfo() {
            return this.testInfo;
        }

        public String getName() {
            return this.testInfo.getName();
        }

        public Annotation[] getAnnotations() {
            ImmutableList<Annotation> annotations = this.testInfo.getAnnotations();
            return annotations.toArray((Annotation[])new Annotation[0]);
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.testInfo.getAnnotation(annotationClass);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OverriddenFrameworkMethod)) {
                return false;
            }
            OverriddenFrameworkMethod other = (OverriddenFrameworkMethod)((Object)obj);
            return super.equals((Object)other) && other.testInfo.equals(this.testInfo);
        }

        public int hashCode() {
            return super.hashCode() * 37 + this.testInfo.hashCode();
        }
    }

    private static class ContextMethodRule
    implements MethodRule {
        private ContextMethodRule() {
        }

        public Statement apply(final Statement statement, final FrameworkMethod method, Object o) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    currentTestInfo.set(((OverriddenFrameworkMethod)method).getTestInfo());
                    try {
                        statement.evaluate();
                    }
                    finally {
                        currentTestInfo.set(null);
                    }
                }
            };
        }
    }
}

