/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.vm.impl;

import com.google.web.bindery.autobean.shared.AutoBeanVisitor;
import com.google.web.bindery.autobean.vm.impl.TypeUtils;
import java.lang.reflect.Type;

abstract class MethodPropertyContext
implements AutoBeanVisitor.CollectionPropertyContext,
AutoBeanVisitor.MapPropertyContext {
    private final Class<?> elementType;
    private final Type genericType;
    private final Class<?> keyType;
    private final Class<?> valueType;
    private final Class<?> type;

    protected MethodPropertyContext(Type genericType, Class<?> type, Class<?> elementType, Class<?> keyType, Class<?> valueType) {
        this.genericType = genericType;
        this.type = type;
        this.elementType = elementType;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public void accept(AutoBeanVisitor.ParameterizationVisitor visitor) {
        this.traverse(visitor, this.genericType);
    }

    @Override
    public abstract boolean canSet();

    @Override
    public Class<?> getElementType() {
        return this.elementType;
    }

    @Override
    public Class<?> getKeyType() {
        return this.keyType;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Class<?> getValueType() {
        return this.valueType;
    }

    @Override
    public abstract void set(Object var1);

    private void traverse(AutoBeanVisitor.ParameterizationVisitor visitor, Type type) {
        Class<?> base = TypeUtils.ensureBaseType(type);
        if (visitor.visitType(base)) {
            Type[] params;
            for (Type t : params = TypeUtils.getParameterization(base, type)) {
                if (visitor.visitParameter()) {
                    this.traverse(visitor, t);
                }
                visitor.endVisitParameter();
            }
        }
        visitor.endVisitType(base);
    }
}

