/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.AbstractIsoBufferWrapper;
import com.coremedia.iso.IsoBufferWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexIsoBufferWrapperImpl
extends AbstractIsoBufferWrapper {
    List<IsoBufferWrapper> multiplexees;
    int activeMultiplexee = 0;

    public MultiplexIsoBufferWrapperImpl(List<IsoBufferWrapper> multiplexees) {
        this.multiplexees = multiplexees;
    }

    @Override
    public long position() throws IOException {
        if (this.activeMultiplexee >= 0) {
            long pos = 0L;
            for (int i = 0; i < this.activeMultiplexee; ++i) {
                pos += this.multiplexees.get(i).size();
            }
            return pos += this.multiplexees.get(this.activeMultiplexee).position();
        }
        return this.size();
    }

    @Override
    public long remaining() throws IOException {
        if (this.activeMultiplexee == -1) {
            return 0L;
        }
        long remaining = 0L;
        for (int i = this.multiplexees.size() - 1; i > this.activeMultiplexee; --i) {
            remaining += this.multiplexees.get(i).size();
        }
        return remaining += this.multiplexees.get(this.activeMultiplexee).remaining();
    }

    @Override
    public void position(long position) throws IOException {
        if (position == this.size()) {
            this.activeMultiplexee = -1;
        } else {
            int current = 0;
            while (position >= this.multiplexees.get(current).size()) {
                position -= this.multiplexees.get(current++).size();
            }
            this.multiplexees.get(current).position((int)position);
            this.activeMultiplexee = current;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            b[i] = this.readByte();
        }
        return b.length;
    }

    @Override
    public IsoBufferWrapper getSegment(long startPos, long length) throws IOException {
        long savePos = this.position();
        ArrayList<IsoBufferWrapper> segments = new ArrayList<IsoBufferWrapper>();
        this.position(startPos);
        while (length > 0L) {
            IsoBufferWrapper currentSlice = this.multiplexees.get(this.activeMultiplexee);
            if (currentSlice.remaining() >= length) {
                segments.add(currentSlice.getSegment(currentSlice.position(), length));
                length -= length;
                continue;
            }
            length -= currentSlice.remaining();
            this.multiplexees.get(++this.activeMultiplexee).position(0L);
            segments.add(currentSlice.getSegment(0L, currentSlice.remaining()));
        }
        this.position(savePos);
        return new MultiplexIsoBufferWrapperImpl(segments);
    }

    @Override
    public int read() throws IOException {
        if (this.multiplexees.get(this.activeMultiplexee).remaining() == 0L) {
            if (this.multiplexees.size() > this.activeMultiplexee + 1) {
                ++this.activeMultiplexee;
                this.multiplexees.get(this.activeMultiplexee).position(0L);
                return this.read();
            }
            return -1;
        }
        int b = this.multiplexees.get(this.activeMultiplexee).read();
        return b < 0 ? b + 256 : b;
    }

    @Override
    public long size() {
        long size = 0L;
        for (IsoBufferWrapper multiplexee : this.multiplexees) {
            size += multiplexee.size();
        }
        return size;
    }
}

