/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleToChunkBox
extends AbstractFullBox {
    List<Entry> entries = Collections.emptyList();
    public static final String TYPE = "stsc";

    public SampleToChunkBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    @Override
    protected long getContentSize() {
        return this.entries.size() * 12 + 4;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        long entryCount = in.readUInt32();
        if (entryCount > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE entries!");
        }
        this.entries = new ArrayList<Entry>((int)entryCount);
        int i = 0;
        while ((long)i < entryCount) {
            this.entries.add(new Entry(in.readUInt32(), in.readUInt32(), in.readUInt32()));
            ++i;
        }
    }

    @Override
    protected void getContent(IsoOutputStream isos) throws IOException {
        long l = isos.getStreamPosition();
        isos.writeUInt32(this.entries.size());
        for (Entry entry : this.entries) {
            isos.writeUInt32(entry.getFirstChunk());
            isos.writeUInt32(entry.getSamplesPerChunk());
            isos.writeUInt32(entry.getSampleDescriptionIndex());
        }
        assert (this.getContentSize() == isos.getStreamPosition() - l);
    }

    public String toString() {
        return "SampleToChunkBox[entryCount=" + this.entries.size() + "]";
    }

    public long[] blowup(int chunkCount) {
        long[] numberOfSamples = new long[chunkCount];
        boolean j = false;
        LinkedList<Entry> sampleToChunkEntries = new LinkedList<Entry>(this.entries);
        Collections.reverse(sampleToChunkEntries);
        Iterator iterator = sampleToChunkEntries.iterator();
        Entry currentEntry = (Entry)iterator.next();
        for (int i = numberOfSamples.length; i > 1; --i) {
            numberOfSamples[i - 1] = currentEntry.getSamplesPerChunk();
            if ((long)i != currentEntry.getFirstChunk()) continue;
            currentEntry = (Entry)iterator.next();
        }
        numberOfSamples[0] = currentEntry.getSamplesPerChunk();
        return numberOfSamples;
    }

    public static class Entry {
        long firstChunk;
        long samplesPerChunk;
        long sampleDescriptionIndex;

        public Entry(long firstChunk, long samplesPerChunk, long sampleDescriptionIndex) {
            this.firstChunk = firstChunk;
            this.samplesPerChunk = samplesPerChunk;
            this.sampleDescriptionIndex = sampleDescriptionIndex;
        }

        public long getFirstChunk() {
            return this.firstChunk;
        }

        public void setFirstChunk(long firstChunk) {
            this.firstChunk = firstChunk;
        }

        public long getSamplesPerChunk() {
            return this.samplesPerChunk;
        }

        public void setSamplesPerChunk(long samplesPerChunk) {
            this.samplesPerChunk = samplesPerChunk;
        }

        public long getSampleDescriptionIndex() {
            return this.sampleDescriptionIndex;
        }

        public void setSampleDescriptionIndex(long sampleDescriptionIndex) {
            this.sampleDescriptionIndex = sampleDescriptionIndex;
        }

        public String toString() {
            return "Entry{firstChunk=" + this.firstChunk + ", samplesPerChunk=" + this.samplesPerChunk + ", sampleDescriptionIndex=" + this.sampleDescriptionIndex + '}';
        }
    }
}

