/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.h264;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoBufferWrapperImpl;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.googlecode.mp4parser.h264.model.PictureParameterSet;
import com.googlecode.mp4parser.h264.model.SeqParameterSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AvcConfigurationBox
extends AbstractBox {
    public static final String TYPE = "avcC";
    private int configurationVersion;
    private int avcProfileIndicaation;
    private int profileCompatibility;
    private int avcLevelIndication;
    private int lengthSizeMinusOne;
    List<byte[]> sequenceParameterSets = new ArrayList<byte[]>();
    List<byte[]> pictureParameterSets = new ArrayList<byte[]>();

    public AvcConfigurationBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public int getConfigurationVersion() {
        return this.configurationVersion;
    }

    public int getAvcProfileIndicaation() {
        return this.avcProfileIndicaation;
    }

    public int getProfileCompatibility() {
        return this.profileCompatibility;
    }

    public int getAvcLevelIndication() {
        return this.avcLevelIndication;
    }

    public int getLengthSizeMinusOne() {
        return this.lengthSizeMinusOne;
    }

    public List<byte[]> getSequenceParameterSets() {
        return Collections.unmodifiableList(this.sequenceParameterSets);
    }

    public List<byte[]> getPictureParameterSets() {
        return Collections.unmodifiableList(this.pictureParameterSets);
    }

    public void setConfigurationVersion(int configurationVersion) {
        this.configurationVersion = configurationVersion;
    }

    public void setAvcProfileIndicaation(int avcProfileIndicaation) {
        this.avcProfileIndicaation = avcProfileIndicaation;
    }

    public void setProfileCompatibility(int profileCompatibility) {
        this.profileCompatibility = profileCompatibility;
    }

    public void setAvcLevelIndication(int avcLevelIndication) {
        this.avcLevelIndication = avcLevelIndication;
    }

    public void setLengthSizeMinusOne(int lengthSizeMinusOne) {
        this.lengthSizeMinusOne = lengthSizeMinusOne;
    }

    public void setSequenceParameterSets(List<byte[]> sequenceParameterSets) {
        this.sequenceParameterSets = sequenceParameterSets;
    }

    public void setPictureParameterSets(List<byte[]> pictureParameterSets) {
        this.pictureParameterSets = pictureParameterSets;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        this.configurationVersion = in.readUInt8();
        this.avcProfileIndicaation = in.readUInt8();
        this.profileCompatibility = in.readUInt8();
        this.avcLevelIndication = in.readUInt8();
        int temp = in.readUInt8();
        this.lengthSizeMinusOne = temp & 3;
        long numberOfSeuqenceParameterSets = in.readUInt8() & 0x1F;
        int i = 0;
        while ((long)i < numberOfSeuqenceParameterSets) {
            int sequenceParameterSetLength = in.readUInt16();
            byte[] sequenceParameterSetNALUnit = in.read(sequenceParameterSetLength);
            this.sequenceParameterSets.add(sequenceParameterSetNALUnit);
            ++i;
        }
        long numberOfPictureParameterSets = in.readUInt8();
        int i2 = 0;
        while ((long)i2 < numberOfPictureParameterSets) {
            int pictureParameterSetLength = in.readUInt16();
            byte[] pictureParameterSetNALUnit = in.read(pictureParameterSetLength);
            this.pictureParameterSets.add(pictureParameterSetNALUnit);
            ++i2;
        }
    }

    @Override
    protected long getContentSize() {
        long size = 5L;
        ++size;
        for (byte[] sequenceParameterSetNALUnit : this.sequenceParameterSets) {
            size += 2L;
            size += (long)sequenceParameterSetNALUnit.length;
        }
        ++size;
        for (byte[] pictureParameterSetNALUnit : this.pictureParameterSets) {
            size += 2L;
            size += (long)pictureParameterSetNALUnit.length;
        }
        return size;
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt8(this.configurationVersion);
        os.writeUInt8(this.avcProfileIndicaation);
        os.writeUInt8(this.profileCompatibility);
        os.writeUInt8(this.avcLevelIndication);
        os.writeUInt8(this.lengthSizeMinusOne | 0xFC);
        os.writeUInt8(this.pictureParameterSets.size() & 0x1F | 0xE0);
        for (byte[] sequenceParameterSetNALUnit : this.sequenceParameterSets) {
            os.writeUInt16(sequenceParameterSetNALUnit.length);
            os.write(sequenceParameterSetNALUnit);
        }
        os.writeUInt8(this.pictureParameterSets.size());
        for (byte[] pictureParameterSetNALUnit : this.pictureParameterSets) {
            os.writeUInt16(pictureParameterSetNALUnit.length);
            os.write(pictureParameterSetNALUnit);
        }
    }

    public String[] getPPS() {
        ArrayList<String> l = new ArrayList<String>();
        for (byte[] pictureParameterSet : this.pictureParameterSets) {
            String details = "not parsable";
            try {
                details = PictureParameterSet.read(new IsoBufferWrapperImpl(pictureParameterSet)).toString();
            }
            catch (IOException e) {
                // empty catch block
            }
            l.add(details);
        }
        return l.toArray(new String[l.size()]);
    }

    public String[] getSPS() {
        ArrayList<String> l = new ArrayList<String>();
        for (byte[] sequenceParameterSet : this.sequenceParameterSets) {
            String detail = "not parsable";
            try {
                detail = SeqParameterSet.read(new IsoBufferWrapperImpl(sequenceParameterSet)).toString();
            }
            catch (IOException e) {
                // empty catch block
            }
            l.add(detail);
        }
        return l.toArray(new String[l.size()]);
    }
}

