/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.srt;

import com.googlecode.mp4parser.authoring.tracks.TextTrackImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public class SrtParser {
    public static TextTrackImpl parse(InputStream is) throws IOException {
        String numberString;
        LineNumberReader r = new LineNumberReader(new InputStreamReader(is, "UTF-8"));
        TextTrackImpl track = new TextTrackImpl();
        while ((numberString = r.readLine()) != null) {
            String s;
            String timeString = r.readLine();
            String lineString = "";
            while ((s = r.readLine()) != null && !s.trim().equals("")) {
                lineString = lineString + s + "\n";
            }
            long startTime = SrtParser.parse(timeString.split("-->")[0]);
            long endTime = SrtParser.parse(timeString.split("-->")[1]);
            track.getSubs().add(new TextTrackImpl.Line(startTime, endTime, lineString));
        }
        return track;
    }

    private static long parse(String in) {
        long hours = Long.parseLong(in.split(":")[0].trim());
        long minutes = Long.parseLong(in.split(":")[1].trim());
        long seconds = Long.parseLong(in.split(":")[2].split(",")[0].trim());
        long millies = Long.parseLong(in.split(":")[2].split(",")[1].trim());
        return hours * 60L * 60L * 1000L + minutes * 60L * 1000L + seconds * 1000L + millies;
    }
}

