/**
 *   Copyright 2012-2013 Wicked Charts (http://wicked-charts.googlecode.com)
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package com.googlecode.wickedcharts.highcharts.options.series;

import java.util.Arrays;
import java.util.List;

/**
 * A series of bubbles.
 * 
 * @author Tom Hombergs (tom.hombergs@gmail.com)
 * 
 */
public class BubbleSeries extends Series<Bubble> {

	private static final long serialVersionUID = 1L;

	public BubbleSeries addPoint(Bubble bubble) {
		super.addPoint(bubble);
		return this;
	}

	public BubbleSeries addPoint(Number x, Number y, Number size) {
		super.addPoint(new Bubble(x, y, size));
		return this;
	}

	@Override
	public List<Bubble> getData() {
		return super.getData();
	}

	@Override
	public BubbleSeries setData(Bubble... data) {
		super.setData(Arrays.asList(data));
		return this;
	}

	@Override
	public BubbleSeries setData(final List<Bubble> data) {
		super.setData(data);
		return this;
	}

}
