/*
 * Decompiled with CFR 0.152.
 */
package com.gradecak.alfresco.mvc.aop;

import com.gradecak.alfresco.mvc.annotation.AlfrescoRunAs;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class RunAsAdvice
implements MethodInterceptor {
    public Object invoke(final MethodInvocation invocation) throws Throwable {
        String runAs;
        Class<?> targetClass = invocation.getThis() != null ? invocation.getThis().getClass() : null;
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)invocation.getMethod(), targetClass);
        AlfrescoRunAs alfrescounRunAs = this.parseRunAsAnnotation(specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod));
        if (alfrescounRunAs != null && StringUtils.hasText((String)(runAs = alfrescounRunAs.value()))) {
            AuthenticationUtil.RunAsWork<Object> getUserNameRunAsWork = new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    try {
                        return invocation.proceed();
                    }
                    catch (Throwable e) {
                        throw new Exception(e.getMessage(), e);
                    }
                }
            };
            return AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)getUserNameRunAsWork, (String)runAs);
        }
        return invocation.proceed();
    }

    private AlfrescoRunAs parseRunAsAnnotation(AnnotatedElement ae) {
        AlfrescoRunAs ann = ae.getAnnotation(AlfrescoRunAs.class);
        if (ann == null) {
            Annotation metaAnn;
            Annotation[] annotationArray = ae.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && (ann = (metaAnn = annotationArray[i]).annotationType().getAnnotation(AlfrescoRunAs.class)) == null; ++i) {
            }
        }
        if (ann != null) {
            return this.parseAnnotation(ann);
        }
        return null;
    }

    private AlfrescoRunAs parseAnnotation(AlfrescoRunAs ann) {
        return ann;
    }
}

