/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.algorithms;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.algorithms.Algorithm;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.algorithms.CryptoHelper;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.SignatureVerificationException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.DecodedJWT;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.RSAKeyProvider;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;

class RSAAlgorithm
extends Algorithm {
    private final RSAKeyProvider keyProvider;
    private final CryptoHelper crypto;

    RSAAlgorithm(CryptoHelper cryptoHelper, String string, String string2, RSAKeyProvider rSAKeyProvider) throws IllegalArgumentException {
        super(string, string2);
        if (rSAKeyProvider == null) {
            throw new IllegalArgumentException("The Key Provider cannot be null.");
        }
        this.keyProvider = rSAKeyProvider;
        this.crypto = cryptoHelper;
    }

    RSAAlgorithm(String string, String string2, RSAKeyProvider rSAKeyProvider) throws IllegalArgumentException {
        this(new CryptoHelper(), string, string2, rSAKeyProvider);
    }

    @Override
    public void verify(DecodedJWT decodedJWT) throws SignatureVerificationException {
        try {
            byte[] byArray = Base64.getUrlDecoder().decode(decodedJWT.getSignature());
            RSAPublicKey rSAPublicKey = (RSAPublicKey)this.keyProvider.getPublicKeyById(decodedJWT.getKeyId());
            if (rSAPublicKey == null) {
                throw new IllegalStateException("The given Public Key is null.");
            }
            boolean bl2 = this.crypto.verifySignatureFor(this.getDescription(), (PublicKey)rSAPublicKey, decodedJWT.getHeader(), decodedJWT.getPayload(), byArray);
            if (!bl2) {
                throw new SignatureVerificationException(this);
            }
        }
        catch (IllegalArgumentException | IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException exception) {
            throw new SignatureVerificationException(this, (Throwable)exception);
        }
    }

    static RSAKeyProvider providerForKeys(final RSAPublicKey rSAPublicKey, final RSAPrivateKey rSAPrivateKey) {
        if (rSAPublicKey == null && rSAPrivateKey == null) {
            throw new IllegalArgumentException("Both provided Keys cannot be null.");
        }
        return new RSAKeyProvider(){

            @Override
            public RSAPublicKey getPublicKeyById(String string) {
                return rSAPublicKey;
            }
        };
    }
}

