/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dom;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.WriterConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dom.DOMOutputElement;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.EmptyNamespaceContext;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.dom.DOMWrappingWriter;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WstxDOMWrappingWriter
extends DOMWrappingWriter {
    protected static final String ERR_NSDECL_WRONG_STATE = "Trying to write a namespace declaration when there is no open start element.";
    protected final WriterConfig mConfig;
    protected DOMOutputElement mCurrElem;
    protected DOMOutputElement mOpenElement;
    protected int[] mAutoNsSeq;
    protected String mSuggestedDefNs = null;
    protected String mAutomaticNsPrefix;
    HashMap<String, String> mSuggestedPrefixes = null;

    private WstxDOMWrappingWriter(WriterConfig writerConfig, Node node) throws XMLStreamException {
        super(node, writerConfig.willSupportNamespaces(), writerConfig.automaticNamespacesEnabled());
        this.mConfig = writerConfig;
        this.mAutoNsSeq = null;
        this.mAutomaticNsPrefix = this.mNsRepairing ? this.mConfig.getAutomaticNsPrefix() : null;
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                this.mCurrElem = DOMOutputElement.createRoot(node);
                this.mOpenElement = null;
                break;
            }
            case 1: {
                DOMOutputElement dOMOutputElement = DOMOutputElement.createRoot(node);
                Element element = (Element)node;
                this.mOpenElement = this.mCurrElem = dOMOutputElement.createChild(element);
                break;
            }
            default: {
                throw new XMLStreamException("Can not create an XMLStreamWriter for a DOM node of type " + node.getClass());
            }
        }
    }

    public static WstxDOMWrappingWriter createFrom(WriterConfig writerConfig, DOMResult dOMResult) throws XMLStreamException {
        Node node = dOMResult.getNode();
        return new WstxDOMWrappingWriter(writerConfig, node);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        if (!this.mNsAware) {
            return EmptyNamespaceContext.getInstance();
        }
        return this.mCurrElem;
    }

    @Override
    public String getPrefix(String string) {
        String string2;
        if (!this.mNsAware) {
            return null;
        }
        if (this.mNsContext != null && (string2 = this.mNsContext.getPrefix(string)) != null) {
            return string2;
        }
        return this.mCurrElem.getPrefix(string);
    }

    @Override
    public Object getProperty(String string) {
        return this.mConfig.getProperty(string);
    }

    @Override
    public void setDefaultNamespace(String string) {
        this.mSuggestedDefNs = string == null || string.length() == 0 ? null : string;
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        if (string == null) {
            throw new NullPointerException("Can not pass null 'prefix' value");
        }
        if (string.length() == 0) {
            this.setDefaultNamespace(string2);
            return;
        }
        if (string2 == null) {
            throw new NullPointerException("Can not pass null 'uri' value");
        }
        if (string.equals("xml")) {
            if (!string2.equals("http://www.w3.org/XML/1998/namespace")) {
                WstxDOMWrappingWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML, string2);
            }
        } else {
            if (string.equals("xmlns")) {
                if (!string2.equals("http://www.w3.org/2000/xmlns/")) {
                    WstxDOMWrappingWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS, string2);
                }
                return;
            }
            if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
                WstxDOMWrappingWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML_URI, string);
            } else if (string2.equals("http://www.w3.org/2000/xmlns/")) {
                WstxDOMWrappingWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI, string);
            }
        }
        if (this.mSuggestedPrefixes == null) {
            this.mSuggestedPrefixes = new HashMap(16);
        }
        this.mSuggestedPrefixes.put(string2, string);
    }

    @Override
    public void writeAttribute(String string, String string2) throws XMLStreamException {
        this.outputAttribute(null, null, string, string2);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        this.outputAttribute(string, null, string2, string3);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        this.outputAttribute(string2, string, string3, string4);
    }

    @Override
    public void writeDefaultNamespace(String string) {
        if (this.mOpenElement == null) {
            throw new IllegalStateException("No currently open START_ELEMENT, cannot write attribute");
        }
        this.setDefaultNamespace(string);
        this.mOpenElement.addAttribute("http://www.w3.org/2000/xmlns/", "xmlns", string);
    }

    @Override
    public void writeEmptyElement(String string) throws XMLStreamException {
        this.writeEmptyElement(null, string);
    }

    @Override
    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.createStartElem(string, null, string2, true);
    }

    @Override
    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        if (string == null) {
            string = "";
        }
        this.createStartElem(string3, string, string2, true);
    }

    @Override
    public void writeEndDocument() {
        this.mOpenElement = null;
        this.mCurrElem = null;
    }

    @Override
    public void writeEndElement() {
        if (this.mCurrElem == null || this.mCurrElem.isRoot()) {
            throw new IllegalStateException("No open start element to close");
        }
        this.mOpenElement = null;
        this.mCurrElem = this.mCurrElem.getParent();
    }

    @Override
    public void writeNamespace(String string, String string2) throws XMLStreamException {
        if (string == null || string.length() == 0) {
            this.writeDefaultNamespace(string2);
            return;
        }
        if (!this.mNsAware) {
            WstxDOMWrappingWriter.throwOutputError("Can not write namespaces with non-namespace writer.");
        }
        this.outputAttribute("http://www.w3.org/2000/xmlns/", "xmlns", string, string2);
        this.mCurrElem.addPrefix(string, string2);
    }

    @Override
    public void writeStartElement(String string) throws XMLStreamException {
        this.writeStartElement(null, string);
    }

    @Override
    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.createStartElem(string, null, string2, false);
    }

    @Override
    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.createStartElem(string3, string, string2, false);
    }

    @Override
    public boolean isPropertySupported(String string) {
        return this.mConfig.isPropertySupported(string);
    }

    @Override
    public boolean setProperty(String string, Object object) {
        return this.mConfig.setProperty(string, object);
    }

    @Override
    public void writeDTD(String string, String string2, String string3, String string4) throws XMLStreamException {
        if (this.mCurrElem != null) {
            throw new IllegalStateException("Operation only allowed to the document before adding root element");
        }
        this.reportUnsupported("writeDTD()");
    }

    @Override
    protected void appendLeaf(Node node) throws IllegalStateException {
        this.mCurrElem.appendNode(node);
        this.mOpenElement = null;
    }

    protected void createStartElem(String string, String string2, String string3, boolean bl2) throws XMLStreamException {
        DOMOutputElement dOMOutputElement;
        if (!this.mNsAware) {
            if (string != null && string.length() > 0) {
                WstxDOMWrappingWriter.throwOutputError("Can not specify non-empty uri/prefix in non-namespace mode");
            }
            dOMOutputElement = this.mCurrElem.createAndAttachChild(this.mDocument.createElement(string3));
        } else if (this.mNsRepairing) {
            String string4 = this.validateElemPrefix(string2, string, this.mCurrElem);
            if (string4 != null) {
                dOMOutputElement = string4.length() != 0 ? this.mCurrElem.createAndAttachChild(this.mDocument.createElementNS(string, string4 + ":" + string3)) : this.mCurrElem.createAndAttachChild(this.mDocument.createElementNS(string, string3));
            } else {
                boolean bl3;
                if (string2 == null) {
                    string2 = "";
                }
                boolean bl4 = bl3 = (string4 = this.generateElemPrefix(string2, string, this.mCurrElem)).length() != 0;
                if (bl3) {
                    string3 = string4 + ":" + string3;
                }
                this.mOpenElement = dOMOutputElement = this.mCurrElem.createAndAttachChild(this.mDocument.createElementNS(string, string3));
                if (bl3) {
                    this.writeNamespace(string4, string);
                    dOMOutputElement.addPrefix(string4, string);
                } else {
                    this.writeDefaultNamespace(string);
                    dOMOutputElement.setDefaultNsUri(string);
                }
            }
        } else {
            if (string2 == null && string != null && string.length() > 0) {
                String string5 = string2 = this.mSuggestedPrefixes == null ? null : this.mSuggestedPrefixes.get(string);
                if (string2 == null) {
                    WstxDOMWrappingWriter.throwOutputError("Can not find prefix for namespace \"" + string + "\"");
                }
            }
            if (string2 != null && string2.length() != 0) {
                string3 = string2 + ":" + string3;
            }
            dOMOutputElement = this.mCurrElem.createAndAttachChild(this.mDocument.createElementNS(string, string3));
        }
        this.mOpenElement = dOMOutputElement;
        if (!bl2) {
            this.mCurrElem = dOMOutputElement;
        }
    }

    protected void outputAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        if (this.mOpenElement == null) {
            throw new IllegalStateException("No currently open START_ELEMENT, cannot write attribute");
        }
        if (this.mNsAware) {
            if (this.mNsRepairing) {
                string2 = this.findOrCreateAttrPrefix(string2, string, this.mOpenElement);
            }
            if (string2 != null && string2.length() > 0) {
                string3 = string2 + ":" + string3;
            }
            this.mOpenElement.addAttribute(string, string3, string4);
        } else {
            if (string2 != null && string2.length() > 0) {
                string3 = string2 + ":" + string3;
            }
            this.mOpenElement.addAttribute(string3, string4);
        }
    }

    private final String validateElemPrefix(String string, String string2, DOMOutputElement dOMOutputElement) throws XMLStreamException {
        if (string2 == null || string2.length() == 0) {
            String string3 = dOMOutputElement.getDefaultNsUri();
            if (string3 == null || string3.length() == 0) {
                return "";
            }
            return null;
        }
        int n2 = dOMOutputElement.isPrefixValid(string, string2, true);
        if (n2 == 1) {
            return string;
        }
        return null;
    }

    protected final String findElemPrefix(String string, DOMOutputElement dOMOutputElement) throws XMLStreamException {
        if (string == null || string.length() == 0) {
            String string2 = dOMOutputElement.getDefaultNsUri();
            if (string2 != null && string2.length() > 0) {
                return null;
            }
            return "";
        }
        return this.mCurrElem.getPrefix(string);
    }

    protected final String generateElemPrefix(String string, String string2, DOMOutputElement dOMOutputElement) throws XMLStreamException {
        if (string2 == null || string2.length() == 0) {
            return "";
        }
        if (string == null) {
            if (this.mSuggestedDefNs != null && this.mSuggestedDefNs.equals(string2)) {
                string = "";
            } else {
                String string3 = string = this.mSuggestedPrefixes == null ? null : this.mSuggestedPrefixes.get(string2);
                if (string == null) {
                    if (this.mAutoNsSeq == null) {
                        this.mAutoNsSeq = new int[1];
                        this.mAutoNsSeq[0] = 1;
                    }
                    string = dOMOutputElement.generateMapping(this.mAutomaticNsPrefix, string2, this.mAutoNsSeq);
                }
            }
        }
        return string;
    }

    protected final String findOrCreateAttrPrefix(String string, String string2, DOMOutputElement dOMOutputElement) throws XMLStreamException {
        String string3;
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        if (string != null) {
            int n2 = dOMOutputElement.isPrefixValid(string, string2, false);
            if (n2 == 1) {
                return string;
            }
            if (n2 == 0) {
                dOMOutputElement.addPrefix(string, string2);
                this.writeNamespace(string, string2);
                return string;
            }
        }
        if ((string3 = dOMOutputElement.getExplicitPrefix(string2)) != null) {
            return string3;
        }
        if (string != null) {
            string3 = string;
        } else if (this.mSuggestedPrefixes != null) {
            string3 = this.mSuggestedPrefixes.get(string2);
        }
        if (string3 != null && (string3.length() == 0 || dOMOutputElement.getNamespaceURI(string3) != null)) {
            string3 = null;
        }
        if (string3 == null) {
            if (this.mAutoNsSeq == null) {
                this.mAutoNsSeq = new int[1];
                this.mAutoNsSeq[0] = 1;
            }
            string3 = this.mCurrElem.generateMapping(this.mAutomaticNsPrefix, string2, this.mAutoNsSeq);
        }
        dOMOutputElement.addPrefix(string3, string2);
        this.writeNamespace(string3, string2);
        return string3;
    }
}

