/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.ChoiceModel;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.ConcatModel;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.ContentSpec;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.LargePrefixedNameSet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.ModelNode;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.OptionalModel;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.PrefixedNameSet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.SmallPrefixedNameSet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.StarModel;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.StructValidator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.TokenContentSpec;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.ExceptionUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.PrefixedName;
import java.util.Collection;

public class ChoiceContentSpec
extends ContentSpec {
    final boolean mNsAware;
    final boolean mHasMixed;
    final ContentSpec[] mContentSpecs;

    private ChoiceContentSpec(boolean bl2, char c2, boolean bl3, ContentSpec[] contentSpecArray) {
        super(c2);
        this.mNsAware = bl2;
        this.mHasMixed = bl3;
        this.mContentSpecs = contentSpecArray;
    }

    private ChoiceContentSpec(boolean bl2, char c2, boolean bl3, Collection<ContentSpec> collection) {
        super(c2);
        this.mNsAware = bl2;
        this.mHasMixed = bl3;
        this.mContentSpecs = new ContentSpec[collection.size()];
        collection.toArray(this.mContentSpecs);
    }

    public static ChoiceContentSpec constructChoice(boolean bl2, char c2, Collection<ContentSpec> collection) {
        return new ChoiceContentSpec(bl2, c2, false, collection);
    }

    public static ChoiceContentSpec constructMixed(boolean bl2, Collection<ContentSpec> collection) {
        return new ChoiceContentSpec(bl2, '*', true, collection);
    }

    @Override
    public StructValidator getSimpleValidator() {
        int n2;
        ContentSpec[] contentSpecArray = this.mContentSpecs;
        int n3 = contentSpecArray.length;
        if (this.mHasMixed) {
            n2 = n3;
        } else {
            for (n2 = 0; n2 < n3 && contentSpecArray[n2].isLeaf(); ++n2) {
            }
        }
        if (n2 == n3) {
            PrefixedNameSet prefixedNameSet = ChoiceContentSpec.namesetFromSpecs(this.mNsAware, contentSpecArray);
            return new Validator(this.mArity, prefixedNameSet);
        }
        return null;
    }

    @Override
    public ModelNode rewrite() {
        ContentSpec[] contentSpecArray = this.mContentSpecs;
        int n2 = contentSpecArray.length;
        ModelNode[] modelNodeArray = new ModelNode[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            modelNodeArray[i2] = contentSpecArray[i2].rewrite();
        }
        ChoiceModel choiceModel = new ChoiceModel(modelNodeArray);
        if (this.mArity == '*') {
            return new StarModel(choiceModel);
        }
        if (this.mArity == '?') {
            return new OptionalModel(choiceModel);
        }
        if (this.mArity == '+') {
            return new ConcatModel(choiceModel, new StarModel(choiceModel.cloneModel()));
        }
        return choiceModel;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mHasMixed) {
            stringBuilder.append("(#PCDATA | ");
        } else {
            stringBuilder.append('(');
        }
        for (int i2 = 0; i2 < this.mContentSpecs.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(" | ");
            }
            stringBuilder.append(this.mContentSpecs[i2].toString());
        }
        stringBuilder.append(')');
        if (this.mArity != ' ') {
            stringBuilder.append(this.mArity);
        }
        return stringBuilder.toString();
    }

    protected static PrefixedNameSet namesetFromSpecs(boolean bl2, ContentSpec[] contentSpecArray) {
        int n2 = contentSpecArray.length;
        PrefixedName[] prefixedNameArray = new PrefixedName[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            prefixedNameArray[i2] = ((TokenContentSpec)contentSpecArray[i2]).getName();
        }
        if (n2 < 5) {
            return new SmallPrefixedNameSet(bl2, prefixedNameArray);
        }
        return new LargePrefixedNameSet(bl2, prefixedNameArray);
    }

    static final class Validator
    extends StructValidator {
        final char mArity;
        final PrefixedNameSet mNames;
        int mCount = 0;

        public Validator(char c2, PrefixedNameSet prefixedNameSet) {
            this.mArity = c2;
            this.mNames = prefixedNameSet;
        }

        @Override
        public StructValidator newInstance() {
            return this.mArity == '*' ? this : new Validator(this.mArity, this.mNames);
        }

        @Override
        public String tryToValidate(PrefixedName prefixedName) {
            if (!this.mNames.contains(prefixedName)) {
                if (this.mNames.hasMultiple()) {
                    return "Expected one of (" + this.mNames.toString(" | ") + ")";
                }
                return "Expected <" + this.mNames.toString("") + ">";
            }
            if (++this.mCount > 1 && (this.mArity == '?' || this.mArity == ' ')) {
                if (this.mNames.hasMultiple()) {
                    return "Expected $END (already had one of [" + this.mNames.toString(" | ") + "]";
                }
                return "Expected $END (already had one <" + this.mNames.toString("") + ">]";
            }
            return null;
        }

        @Override
        public String fullyValid() {
            switch (this.mArity) {
                case '*': 
                case '?': {
                    return null;
                }
                case ' ': 
                case '+': {
                    if (this.mCount > 0) {
                        return null;
                    }
                    return "Expected " + (this.mArity == '+' ? "at least" : "") + " one of elements (" + this.mNames + ")";
                }
            }
            ExceptionUtil.throwGenericInternal();
            return null;
        }
    }
}

