/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDAttribute;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDElement;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDSubset;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.ent.EntityDecl;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputElementStack;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.NsDefaultProvider;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.DataUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.ElementIdMap;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.ExceptionUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.PrefixedName;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.ValidationContext;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidationProblem;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidationSchema;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidator;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public abstract class DTDValidatorBase
extends XMLValidator
implements NsDefaultProvider {
    protected static final HashMap<PrefixedName, DTDAttribute> NO_ATTRS = new HashMap();
    static final int DEFAULT_STACK_SIZE = 16;
    static final int EXP_MAX_ATTRS = 16;
    protected static final HashMap<String, EntityDecl> EMPTY_MAP = new HashMap();
    final boolean mHasNsDefaults;
    final DTDSubset mSchema;
    final ValidationContext mContext;
    final Map<PrefixedName, DTDElement> mElemSpecs;
    final Map<String, EntityDecl> mGeneralEntities;
    protected boolean mNormAttrs;
    protected DTDElement mCurrElem = null;
    protected DTDElement[] mElems = null;
    protected int mElemCount = 0;
    protected HashMap<PrefixedName, DTDAttribute> mCurrAttrDefs = null;
    protected DTDAttribute[] mAttrSpecs = new DTDAttribute[16];
    protected int mAttrCount = 0;
    protected int mIdAttrIndex = -1;
    protected final transient PrefixedName mTmpKey = new PrefixedName(null, null);
    char[] mTmpAttrValueBuffer = null;

    public DTDValidatorBase(DTDSubset dTDSubset, ValidationContext validationContext, boolean bl2, Map<PrefixedName, DTDElement> map, Map<String, EntityDecl> map2) {
        this.mSchema = dTDSubset;
        this.mContext = validationContext;
        this.mHasNsDefaults = bl2;
        this.mElemSpecs = map == null || map.size() == 0 ? Collections.emptyMap() : map;
        this.mGeneralEntities = map2;
        this.mNormAttrs = true;
        this.mElems = new DTDElement[16];
    }

    public void setAttrValueNormalization(boolean bl2) {
        this.mNormAttrs = bl2;
    }

    public abstract boolean reallyValidating();

    @Override
    public final XMLValidationSchema getSchema() {
        return this.mSchema;
    }

    @Override
    public abstract void validateElementStart(String var1, String var2, String var3) throws XMLStreamException;

    @Override
    public abstract String validateAttribute(String var1, String var2, String var3, String var4) throws XMLStreamException;

    @Override
    public abstract String validateAttribute(String var1, String var2, String var3, char[] var4, int var5, int var6) throws XMLStreamException;

    @Override
    public abstract int validateElementAndAttributes() throws XMLStreamException;

    @Override
    public abstract int validateElementEnd(String var1, String var2, String var3) throws XMLStreamException;

    @Override
    public void validateText(String string, boolean bl2) throws XMLStreamException {
    }

    @Override
    public void validateText(char[] cArray, int n2, int n3, boolean bl2) throws XMLStreamException {
    }

    @Override
    public abstract void validationCompleted(boolean var1) throws XMLStreamException;

    @Override
    public String getAttributeType(int n2) {
        DTDAttribute dTDAttribute = this.mAttrSpecs[n2];
        return dTDAttribute == null ? "CDATA" : dTDAttribute.getValueTypeString();
    }

    @Override
    public int getIdAttrIndex() {
        int n2 = this.mIdAttrIndex;
        if (n2 == -2) {
            DTDAttribute dTDAttribute;
            n2 = -1;
            if (this.mCurrElem != null && (dTDAttribute = this.mCurrElem.getIdAttribute()) != null) {
                DTDAttribute[] dTDAttributeArray = this.mAttrSpecs;
                int n3 = dTDAttributeArray.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (dTDAttributeArray[i2] != dTDAttribute) continue;
                    n2 = i2;
                    break;
                }
            }
            this.mIdAttrIndex = n2;
        }
        return n2;
    }

    @Override
    public int getNotationAttrIndex() {
        int n2 = this.mAttrCount;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.mAttrSpecs[i2].typeIsNotation()) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean mayHaveNsDefaults(String string, String string2) {
        DTDElement dTDElement;
        this.mTmpKey.reset(string, string2);
        this.mCurrElem = dTDElement = this.mElemSpecs.get(this.mTmpKey);
        return dTDElement != null && dTDElement.hasNsDefaults();
    }

    @Override
    public void checkNsDefaults(InputElementStack inputElementStack) throws XMLStreamException {
        HashMap<String, DTDAttribute> hashMap = this.mCurrElem.getNsDefaults();
        if (hashMap != null) {
            for (Map.Entry<String, DTDAttribute> entry : hashMap.entrySet()) {
                String string = entry.getKey();
                if (inputElementStack.isPrefixLocallyDeclared(string)) continue;
                DTDAttribute dTDAttribute = entry.getValue();
                String string2 = dTDAttribute.getDefaultValue(this.mContext, this);
                inputElementStack.addNsBinding(string, string2);
            }
        }
    }

    PrefixedName getElemName() {
        DTDElement dTDElement = this.mElems[this.mElemCount - 1];
        return dTDElement.getName();
    }

    Location getLocation() {
        return this.mContext.getValidationLocation();
    }

    protected abstract ElementIdMap getIdMap();

    Map<String, EntityDecl> getEntityMap() {
        return this.mGeneralEntities;
    }

    char[] getTempAttrValueBuffer(int n2) {
        if (this.mTmpAttrValueBuffer == null || this.mTmpAttrValueBuffer.length < n2) {
            int n3 = n2 < 100 ? 100 : n2;
            this.mTmpAttrValueBuffer = new char[n3];
        }
        return this.mTmpAttrValueBuffer;
    }

    public boolean hasNsDefaults() {
        return this.mHasNsDefaults;
    }

    void reportValidationProblem(String string) throws XMLStreamException {
        this.doReportValidationProblem(string, null);
    }

    void reportValidationProblem(String string, Location location) throws XMLStreamException {
        this.doReportValidationProblem(string, location);
    }

    void reportValidationProblem(String string, Object object) throws XMLStreamException {
        this.doReportValidationProblem(MessageFormat.format(string, object), null);
    }

    void reportValidationProblem(String string, Object object, Object object2) throws XMLStreamException {
        this.doReportValidationProblem(MessageFormat.format(string, object, object2), null);
    }

    protected void doReportValidationProblem(String string, Location location) throws XMLStreamException {
        if (location == null) {
            location = this.getLocation();
        }
        XMLValidationProblem xMLValidationProblem = new XMLValidationProblem(location, string, 2);
        xMLValidationProblem.setReporter(this);
        this.mContext.reportProblem(xMLValidationProblem);
    }

    protected void doAddDefaultValue(DTDAttribute dTDAttribute) throws XMLStreamException {
        int n2;
        String string = dTDAttribute.getDefaultValue(this.mContext, this);
        if (string == null) {
            ExceptionUtil.throwInternal("null default attribute value");
        }
        PrefixedName prefixedName = dTDAttribute.getName();
        String string2 = prefixedName.getPrefix();
        String string3 = "";
        if (string2 != null && string2.length() > 0 && ((string3 = this.mContext.getNamespaceURI(string2)) == null || string3.length() == 0)) {
            this.reportValidationProblem("Unbound namespace prefix \"{0}\" for default attribute \"{1}\"", string2, dTDAttribute);
            string3 = "";
        }
        if ((n2 = this.mContext.addDefaultAttribute(prefixedName.getLocalName(), string3, string2, string)) >= 0) {
            while (n2 >= this.mAttrSpecs.length) {
                this.mAttrSpecs = (DTDAttribute[])DataUtil.growArrayBy50Pct(this.mAttrSpecs);
            }
            while (this.mAttrCount < n2) {
                this.mAttrSpecs[this.mAttrCount++] = null;
            }
            this.mAttrSpecs[n2] = dTDAttribute;
            this.mAttrCount = n2 + 1;
        }
    }
}

