/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.StringUtil;
import java.io.OutputStreamWriter;
import java.io.Writer;

public final class CharsetNames {
    public static final String CS_US_ASCII = "US-ASCII";
    public static final String CS_UTF8 = "UTF-8";
    public static final String CS_UTF16 = "UTF-16";
    public static final String CS_UTF16BE = "UTF-16BE";
    public static final String CS_UTF16LE = "UTF-16LE";
    public static final String CS_UTF32 = "UTF-32";
    public static final String CS_UTF32BE = "UTF-32BE";
    public static final String CS_UTF32LE = "UTF-32LE";
    public static final String CS_ISO_LATIN1 = "ISO-8859-1";
    public static final String CS_SHIFT_JIS = "Shift_JIS";
    public static final String CS_EBCDIC_SUBSET = "IBM037";

    /*
     * Enabled aggressive block sorting
     */
    public static String normalize(String string) {
        int n2;
        if (string == null) return string;
        if (string.length() < 3) {
            return string;
        }
        boolean bl2 = false;
        char c2 = string.charAt(0);
        if (!(c2 != 'c' && c2 != 'C' || (n2 = string.charAt(1)) != 115 && n2 != 83)) {
            string = string.substring(2);
            c2 = string.charAt(0);
            bl2 = true;
        }
        switch (c2) {
            case 'A': 
            case 'a': {
                if (!StringUtil.equalEncodings(string, "ASCII")) return string;
                return CS_US_ASCII;
            }
            case 'C': 
            case 'c': {
                if (StringUtil.encodingStartsWith(string, "cp")) {
                    return "IBM" + StringUtil.trimEncoding(string, true).substring(2);
                }
                if (!StringUtil.encodingStartsWith(string, "cs")) return string;
                if (!StringUtil.encodingStartsWith(string, "csIBM")) return string;
                return StringUtil.trimEncoding(string, true).substring(2);
            }
            case 'E': 
            case 'e': {
                String string2;
                if (!string.startsWith("EBCDIC-CP-")) {
                    if (!string.startsWith("ebcdic-cp-")) return string;
                }
                if ((string2 = StringUtil.trimEncoding(string, true).substring(8)).equals("US")) return CS_EBCDIC_SUBSET;
                if (string2.equals("CA")) return CS_EBCDIC_SUBSET;
                if (string2.equals("WT")) return CS_EBCDIC_SUBSET;
                if (string2.equals("NL")) {
                    return CS_EBCDIC_SUBSET;
                }
                if (string2.equals("DK")) return "IBM277";
                if (string2.equals("NO")) {
                    return "IBM277";
                }
                if (string2.equals("FI")) return "IBM278";
                if (string2.equals("SE")) {
                    return "IBM278";
                }
                if (string2.equals("ROECE")) return "IBM870";
                if (string2.equals("YU")) {
                    return "IBM870";
                }
                if (string2.equals("IT")) {
                    return "IBM280";
                }
                if (string2.equals("ES")) {
                    return "IBM284";
                }
                if (string2.equals("GB")) {
                    return "IBM285";
                }
                if (string2.equals("FR")) {
                    return "IBM297";
                }
                if (string2.equals("AR1")) {
                    return "IBM420";
                }
                if (string2.equals("AR2")) {
                    return "IBM918";
                }
                if (string2.equals("HE")) {
                    return "IBM424";
                }
                if (string2.equals("CH")) {
                    return "IBM500";
                }
                if (!string2.equals("IS")) return CS_EBCDIC_SUBSET;
                return "IBM871";
            }
            case 'I': 
            case 'i': {
                if (StringUtil.equalEncodings(string, CS_ISO_LATIN1)) return CS_ISO_LATIN1;
                if (StringUtil.equalEncodings(string, "ISO-Latin1")) {
                    return CS_ISO_LATIN1;
                }
                if (!StringUtil.encodingStartsWith(string, "ISO-10646")) {
                    if (!StringUtil.encodingStartsWith(string, "IBM")) return string;
                    return string;
                }
                n2 = string.indexOf("10646");
                String string3 = string.substring(n2 + 5);
                if (StringUtil.equalEncodings(string3, "UCS-Basic")) {
                    return CS_US_ASCII;
                }
                if (StringUtil.equalEncodings(string3, "Unicode-Latin1")) {
                    return CS_ISO_LATIN1;
                }
                if (StringUtil.equalEncodings(string3, "UCS-2")) {
                    return CS_UTF16;
                }
                if (StringUtil.equalEncodings(string3, "UCS-4")) {
                    return CS_UTF32;
                }
                if (StringUtil.equalEncodings(string3, "UTF-1")) {
                    return CS_US_ASCII;
                }
                if (StringUtil.equalEncodings(string3, "J-1")) {
                    return CS_US_ASCII;
                }
                if (!StringUtil.equalEncodings(string3, CS_US_ASCII)) return string;
                return CS_US_ASCII;
            }
            case 'J': 
            case 'j': {
                if (!StringUtil.equalEncodings(string, "JIS_Encoding")) return string;
                return CS_SHIFT_JIS;
            }
            case 'S': 
            case 's': {
                if (!StringUtil.equalEncodings(string, CS_SHIFT_JIS)) return string;
                return CS_SHIFT_JIS;
            }
            case 'U': 
            case 'u': {
                if (string.length() < 2) {
                    return string;
                }
                switch (string.charAt(1)) {
                    case 'C': 
                    case 'c': {
                        if (StringUtil.equalEncodings(string, "UCS-2")) {
                            return CS_UTF16;
                        }
                        if (!StringUtil.equalEncodings(string, "UCS-4")) return string;
                        return CS_UTF32;
                    }
                    case 'N': 
                    case 'n': {
                        if (!bl2) return string;
                        if (StringUtil.equalEncodings(string, "Unicode")) {
                            return CS_UTF16;
                        }
                        if (StringUtil.equalEncodings(string, "UnicodeAscii")) {
                            return CS_ISO_LATIN1;
                        }
                        if (!StringUtil.equalEncodings(string, "UnicodeAscii")) return string;
                        return CS_US_ASCII;
                    }
                    case 'S': 
                    case 's': {
                        if (!StringUtil.equalEncodings(string, CS_US_ASCII)) return string;
                        return CS_US_ASCII;
                    }
                    case 'T': 
                    case 't': {
                        if (StringUtil.equalEncodings(string, CS_UTF8)) {
                            return CS_UTF8;
                        }
                        if (StringUtil.equalEncodings(string, CS_UTF16BE)) {
                            return CS_UTF16BE;
                        }
                        if (StringUtil.equalEncodings(string, CS_UTF16LE)) {
                            return CS_UTF16LE;
                        }
                        if (StringUtil.equalEncodings(string, CS_UTF16)) {
                            return CS_UTF16;
                        }
                        if (StringUtil.equalEncodings(string, CS_UTF32BE)) {
                            return CS_UTF32BE;
                        }
                        if (StringUtil.equalEncodings(string, CS_UTF32LE)) {
                            return CS_UTF32LE;
                        }
                        if (StringUtil.equalEncodings(string, CS_UTF32)) {
                            return CS_UTF32;
                        }
                        if (!StringUtil.equalEncodings(string, "UTF")) return string;
                        return CS_UTF16;
                    }
                }
                return string;
            }
        }
        return string;
    }

    public static String findEncodingFor(Writer writer) {
        if (writer instanceof OutputStreamWriter) {
            String string = ((OutputStreamWriter)writer).getEncoding();
            return CharsetNames.normalize(string);
        }
        return null;
    }
}

