/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import java.io.IOException;
import java.io.InputStream;

public final class MergedStream
extends InputStream {
    private final ReaderConfig mConfig;
    private final InputStream mIn;
    private byte[] mData;
    private int mPtr;
    private final int mEnd;

    public MergedStream(ReaderConfig readerConfig, InputStream inputStream, byte[] byArray, int n2, int n3) {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream `in` should not be `null`");
        }
        this.mConfig = readerConfig;
        this.mIn = inputStream;
        this.mData = byArray;
        this.mPtr = n2;
        this.mEnd = n3;
    }

    @Override
    public int available() throws IOException {
        if (this.mData != null) {
            return this.mEnd - this.mPtr;
        }
        return this.mIn.available();
    }

    @Override
    public void close() throws IOException {
        this.freeMergedBuffer();
        this.mIn.close();
    }

    @Override
    public synchronized void mark(int n2) {
        if (this.mData == null) {
            this.mIn.mark(n2);
        }
    }

    @Override
    public boolean markSupported() {
        return this.mData == null && this.mIn.markSupported();
    }

    @Override
    public int read() throws IOException {
        if (this.mData != null) {
            int n2 = this.mData[this.mPtr++] & 0xFF;
            if (this.mPtr >= this.mEnd) {
                this.freeMergedBuffer();
            }
            return n2;
        }
        return this.mIn.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.mData != null) {
            int n4 = this.mEnd - this.mPtr;
            if (n3 > n4) {
                n3 = n4;
            }
            System.arraycopy(this.mData, this.mPtr, byArray, n2, n3);
            this.mPtr += n3;
            if (this.mPtr >= this.mEnd) {
                this.freeMergedBuffer();
            }
            return n3;
        }
        return this.mIn.read(byArray, n2, n3);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mData == null) {
            this.mIn.reset();
        }
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3 = 0L;
        if (this.mData != null) {
            int n2 = this.mEnd - this.mPtr;
            if ((long)n2 > l2) {
                this.mPtr += (int)l2;
                return l2;
            }
            this.freeMergedBuffer();
            l3 += (long)n2;
            l2 -= (long)n2;
        }
        if (l2 > 0L) {
            l3 += this.mIn.skip(l2);
        }
        return l3;
    }

    private void freeMergedBuffer() {
        if (this.mData != null) {
            byte[] byArray = this.mData;
            this.mData = null;
            if (this.mConfig != null) {
                this.mConfig.freeFullBBuffer(byArray);
            }
        }
    }
}

