/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_jp_gr_xml.dom;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_jp_gr_xml.dom.IDOMVisitor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_jp_gr_xml.dom.UDOMVisitor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_jp_gr_xml.xml.UXML;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLMaker
implements IDOMVisitor {
    protected StringBuffer buffer_ = new StringBuffer();
    protected String encoding_ = "UTF-8";
    protected boolean dom2_ = false;
    protected boolean expandEntityReference_ = false;
    protected boolean emptyElementTag_ = false;

    public void setEncoding(String string) {
        this.encoding_ = string;
    }

    public void setDOM2(boolean bl2) {
        this.dom2_ = bl2;
    }

    public void setExpandEntityReference(boolean bl2) {
        this.expandEntityReference_ = bl2;
    }

    public void setEmptyElementTag(boolean bl2) {
        this.emptyElementTag_ = bl2;
    }

    public String getText() {
        return new String(this.buffer_);
    }

    public boolean enter(Element element) {
        String string = element.getTagName();
        this.buffer_.append("<");
        this.buffer_.append(string);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Attr attr = (Attr)namedNodeMap.item(i2);
            if (!attr.getSpecified()) continue;
            this.buffer_.append(' ');
            this.enter(attr);
            this.leave(attr);
        }
        this.buffer_.append(">");
        return true;
    }

    public void leave(Element element) {
        String string = element.getTagName();
        this.buffer_.append("</" + string + ">");
    }

    public boolean enter(Attr attr) {
        this.buffer_.append(attr.getName());
        this.buffer_.append("=\"");
        this.buffer_.append(UXML.escapeAttrQuot(attr.getValue()));
        this.buffer_.append('\"');
        return true;
    }

    public void leave(Attr attr) {
    }

    public boolean enter(Text text) {
        this.buffer_.append(UXML.escapeCharData(text.getData()));
        return true;
    }

    public void leave(Text text) {
    }

    public boolean enter(CDATASection cDATASection) {
        this.buffer_.append("<![CDATA[");
        this.buffer_.append(cDATASection.getData());
        this.buffer_.append("]]>");
        return true;
    }

    public void leave(CDATASection cDATASection) {
    }

    public boolean enter(EntityReference entityReference) {
        this.buffer_.append("&");
        this.buffer_.append(entityReference.getNodeName());
        this.buffer_.append(";");
        return false;
    }

    public void leave(EntityReference entityReference) {
    }

    public boolean enter(Entity entity) {
        String string = entity.getNodeName();
        String string2 = entity.getPublicId();
        String string3 = entity.getSystemId();
        String string4 = entity.getNotationName();
        this.buffer_.append("<!ENTITY ");
        this.buffer_.append(string);
        if (string3 != null) {
            if (string2 != null) {
                this.buffer_.append(" PUBLIC \"");
                this.buffer_.append(string2);
                this.buffer_.append("\" \"");
                this.buffer_.append(UXML.escapeSystemQuot(string3));
                this.buffer_.append("\">");
            } else {
                this.buffer_.append(" SYSTEM \"");
                this.buffer_.append(UXML.escapeSystemQuot(string3));
                this.buffer_.append("\">");
            }
            if (string4 != null) {
                this.buffer_.append(" NDATA ");
                this.buffer_.append(string4);
                this.buffer_.append(">");
            }
        } else {
            this.buffer_.append(" \"");
            XMLMaker xMLMaker = new XMLMaker();
            UDOMVisitor.traverseChildren(entity, xMLMaker);
            this.buffer_.append(UXML.escapeEntityQuot(xMLMaker.getText()));
            this.buffer_.append("\"");
            this.buffer_.append(">");
        }
        return false;
    }

    public void leave(Entity entity) {
    }

    public boolean enter(ProcessingInstruction processingInstruction) {
        this.buffer_.append("<?");
        this.buffer_.append(processingInstruction.getTarget());
        this.buffer_.append(" ");
        this.buffer_.append(processingInstruction.getData());
        this.buffer_.append("?>");
        return true;
    }

    public void leave(ProcessingInstruction processingInstruction) {
    }

    public boolean enter(Comment comment) {
        this.buffer_.append("<!--");
        this.buffer_.append(comment.getData());
        this.buffer_.append("-->");
        return true;
    }

    public void leave(Comment comment) {
    }

    public boolean enter(Document document) {
        this.buffer_.append("<?xml version=\"1.0\" encoding=\"");
        this.buffer_.append(this.encoding_);
        this.buffer_.append("\" ?>\n");
        return true;
    }

    public void leave(Document document) {
    }

    public boolean enter(DocumentType documentType) {
        if (this.dom2_) {
            String string = documentType.getName();
            String string2 = documentType.getPublicId();
            String string3 = documentType.getSystemId();
            String string4 = documentType.getInternalSubset();
            this.buffer_.append("<!DOCTYPE ");
            this.buffer_.append(string);
            if (string2 != null) {
                this.buffer_.append(" PUBLIC \"");
                this.buffer_.append(string2);
                this.buffer_.append("\"");
            }
            if (string3 != null) {
                this.buffer_.append(" SYSTEM \"");
                this.buffer_.append(string3);
                this.buffer_.append("\"");
            }
            if (string4 != null) {
                this.buffer_.append(" [");
                this.buffer_.append(string4);
                this.buffer_.append("]");
            }
            this.buffer_.append(">\n");
            return true;
        }
        String string = documentType.getName();
        NamedNodeMap namedNodeMap = documentType.getEntities();
        NamedNodeMap namedNodeMap2 = documentType.getNotations();
        this.buffer_.append("<!DOCTYPE ");
        this.buffer_.append(string);
        if (namedNodeMap != null && namedNodeMap.getLength() > 0 || namedNodeMap2 != null && namedNodeMap2.getLength() > 0) {
            int n2;
            this.buffer_.append(" [");
            int n3 = namedNodeMap.getLength();
            for (n2 = 0; n2 < n3; ++n2) {
                XMLMaker xMLMaker = new XMLMaker();
                UDOMVisitor.traverse(namedNodeMap.item(n2), xMLMaker);
                this.buffer_.append(xMLMaker.getText());
            }
            n2 = namedNodeMap2.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.enter((Notation)namedNodeMap2.item(i2));
                this.leave((Notation)namedNodeMap2.item(i2));
            }
            this.buffer_.append("]");
        }
        this.buffer_.append(">\n");
        return true;
    }

    public void leave(DocumentType documentType) {
    }

    public boolean enter(DocumentFragment documentFragment) {
        return true;
    }

    public void leave(DocumentFragment documentFragment) {
    }

    public boolean enter(Notation notation) {
        String string = notation.getNodeName();
        String string2 = notation.getPublicId();
        String string3 = notation.getSystemId();
        this.buffer_.append("<!NOTATION ");
        this.buffer_.append(string);
        if (string2 != null) {
            this.buffer_.append(" PUBLIC \"");
            this.buffer_.append(string2);
            this.buffer_.append("\"");
            if (string3 != null) {
                this.buffer_.append(" \"");
                this.buffer_.append(UXML.escapeSystemQuot(string3));
                this.buffer_.append("\"");
            }
        } else if (string3 != null) {
            this.buffer_.append(" SYSTEM \"");
            this.buffer_.append(UXML.escapeSystemQuot(string3));
            this.buffer_.append("\"");
        }
        this.buffer_.append(">");
        return true;
    }

    public void leave(Notation notation) {
    }

    public boolean enter(Node node) {
        throw new InternalError(node.toString());
    }

    public void leave(Node node) {
        throw new InternalError(node.toString());
    }

    public boolean isParsedEntity(EntityReference entityReference) {
        String string = entityReference.getNodeName();
        Document document = entityReference.getOwnerDocument();
        DocumentType documentType = document.getDoctype();
        if (documentType == null) {
            return false;
        }
        NamedNodeMap namedNodeMap = documentType.getEntities();
        Entity entity = (Entity)namedNodeMap.getNamedItem(string);
        if (entity == null) {
            return false;
        }
        return entity.getNotationName() == null;
    }
}

