/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.SerializationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.BuiltinAtomicType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.Discrete;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.SimpleURType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.UnicodeUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.regex.RegExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.regex.RegExpFactory;
import java.text.ParseException;

public class AnyURIType
extends BuiltinAtomicType
implements Discrete {
    public static final AnyURIType theInstance = new AnyURIType();
    private static final boolean[] isUric = AnyURIType.createUricMap();
    static final RegExp regexp = AnyURIType.createRegExp();
    private static final long serialVersionUID = 1L;

    private AnyURIType() {
        super("anyURI");
    }

    protected boolean checkFormat(String string, ValidationContext validationContext) {
        return regexp.matches(AnyURIType.escape(string));
    }

    private static void appendHex(StringBuffer stringBuffer, int n2) {
        if (n2 < 10) {
            stringBuffer.append((char)(n2 + 48));
        } else {
            stringBuffer.append((char)(n2 - 10 + 65));
        }
    }

    private static void appendByte(StringBuffer stringBuffer, int n2) {
        stringBuffer.append('%');
        AnyURIType.appendHex(stringBuffer, n2 / 16);
        AnyURIType.appendHex(stringBuffer, n2 % 16);
    }

    private static void appendEscaped(StringBuffer stringBuffer, char c2) {
        if (c2 < '\u007f') {
            AnyURIType.appendByte(stringBuffer, c2);
            return;
        }
        if (c2 < '\u07ff') {
            AnyURIType.appendByte(stringBuffer, 192 + (c2 >> 6));
            AnyURIType.appendByte(stringBuffer, 128 + c2 % 64);
            return;
        }
        if (c2 < '\uffff') {
            AnyURIType.appendByte(stringBuffer, 224 + (c2 >> 12));
            AnyURIType.appendByte(stringBuffer, 128 + (c2 >> 6) % 64);
            AnyURIType.appendByte(stringBuffer, 128 + c2 % 64);
        }
    }

    private static void appendEscaped(StringBuffer stringBuffer, char c2, char c3) {
        int n2 = ((c2 & 0x3FF) << 10) + (c3 & 0x3FF);
        AnyURIType.appendByte(stringBuffer, 240 + (n2 >> 18));
        AnyURIType.appendByte(stringBuffer, 128 + (n2 >> 12) % 64);
        AnyURIType.appendByte(stringBuffer, 128 + (n2 >> 6) % 64);
        AnyURIType.appendByte(stringBuffer, 128 + n2 % 64);
    }

    private static boolean[] createUricMap() {
        int n2;
        boolean[] blArray = new boolean[128];
        for (n2 = 97; n2 <= 122; ++n2) {
            blArray[n2] = true;
        }
        for (n2 = 65; n2 <= 90; ++n2) {
            blArray[n2] = true;
        }
        for (n2 = 48; n2 <= 57; ++n2) {
            blArray[n2] = true;
        }
        char[] cArray = new char[]{'-', '_', '.', '!', '~', '*', '\'', '(', ')', '#', '%', '[', ']'};
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            blArray[cArray[i2]] = true;
        }
        char[] cArray2 = new char[]{';', '/', '?', ':', '@', '&', '=', '+', '$', ','};
        for (int i3 = 0; i3 < cArray2.length; ++i3) {
            blArray[cArray2[i3]] = true;
        }
        return blArray;
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0080' && isUric[c2]) {
                stringBuffer.append(c2);
                continue;
            }
            if ('\ud800' <= c2 && c2 < '\udc00') {
                AnyURIType.appendEscaped(stringBuffer, c2, string.charAt(++i2));
                continue;
            }
            AnyURIType.appendEscaped(stringBuffer, c2);
        }
        return new String(stringBuffer);
    }

    static RegExp createRegExp() {
        String string = "[a-zA-Z]";
        String string2 = "[0-9a-zA-Z]";
        String string3 = "[0-9a-fA-F]";
        String string4 = "%" + string3 + "{2}";
        String string5 = "[\\-_\\.!~\\*'\\(\\)]";
        String string6 = "(" + string2 + "|" + string5 + ")";
        String string7 = "[;/\\?:@&=\\+$,\\[\\]]";
        String string8 = "(" + string7 + "|" + string6 + "|" + string4 + ")";
        String string9 = string8 + "*";
        String string10 = string8 + "*";
        String string11 = "(" + string6 + "|" + string4 + "|[:@&=\\+$,])";
        String string12 = string11 + "*";
        String string13 = "(" + string12 + "(;" + string12 + ")*)";
        String string14 = "(" + string13 + "(/" + string13 + ")*)";
        String string15 = "[0-9]*";
        String string16 = "[0-9]{1,3}";
        String string17 = string16 + "\\." + string16 + "\\." + string16 + "\\." + string16;
        String string18 = string3 + "{1,4}";
        String string19 = string18 + "(:" + string18 + ")*";
        String string20 = "((" + string19 + "(::(" + string19 + ")?)?)|(::(" + string19 + ")?))";
        String string21 = "((" + string20 + "(:" + string17 + ")?)|(::" + string17 + "))";
        String string22 = "\\[" + string21 + "\\]";
        String string23 = string2 + "([0-9A-Za-z\\-]*" + string2 + ")?";
        String string24 = string + "([0-9A-Za-z\\-]*" + string2 + ")?";
        String string25 = "(" + string23 + "\\.)*" + string24 + "(\\.)?";
        String string26 = "((" + string25 + ")|(" + string17 + ")|(" + string22 + "))";
        String string27 = string26 + "(:" + string15 + ")?";
        String string28 = "(" + string6 + "|" + string4 + "|[;:&=\\+$,])*";
        String string29 = "((" + string28 + "@)?" + string27 + ")?";
        String string30 = "(" + string6 + "|" + string4 + "|[$,;:@&=\\+])+";
        String string31 = "((" + string29 + ")|(" + string30 + "))";
        String string32 = string + "[A-Za-z0-9\\+\\-\\.]*";
        String string33 = "(" + string6 + "|" + string4 + "|[;@&=\\+$,])+";
        String string34 = "/" + string14;
        String string35 = string33 + "(" + string34 + ")?";
        String string36 = "//" + string31 + "(" + string34 + ")?";
        String string37 = "(" + string6 + "|" + string4 + "|[;\\?:@&=\\+$,])";
        String string38 = string37 + "(" + string8 + ")*";
        String string39 = "((" + string36 + ")|(" + string34 + "))(\\?" + string10 + ")?";
        String string40 = "((" + string36 + ")|(" + string34 + ")|(" + string35 + "))(\\?" + string10 + ")?";
        String string41 = string32 + ":((" + string39 + ")|(" + string38 + "))";
        String string42 = "(" + string41 + "|" + string40 + ")?(#" + string9 + ")?";
        try {
            return RegExpFactory.createFactory().compile(string42);
        }
        catch (ParseException parseException) {
            throw new Error();
        }
    }

    public Object _createValue(String string, ValidationContext validationContext) {
        if (!regexp.matches(AnyURIType.escape(string))) {
            return null;
        }
        return string;
    }

    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException();
    }

    public final int isFacetApplicable(String string) {
        if (string.equals("length") || string.equals("minLength") || string.equals("maxLength") || string.equals("pattern") || string.equals("whiteSpace") || string.equals("enumeration")) {
            return 0;
        }
        return -2;
    }

    public final int countLength(Object object) {
        return UnicodeUtil.countLength((String)object);
    }

    public Class getJavaObjectType() {
        return String.class;
    }

    public XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }
}

