/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.AnyURIType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.Base64BinaryType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.BooleanType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.ByteType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.DateTimeType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.DateType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.DoubleType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.DurationType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.EntityType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.ErrorType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.FloatType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.GDayType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.GMonthDayType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.GMonthType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.GYearMonthType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.GYearType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.HexBinaryType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.IDREFType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.IDType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.IntType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.IntegerType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.LanguageType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.ListType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.LongType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.NameType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.NcnameType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.NegativeIntegerType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.NmtokenType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.NonNegativeIntegerType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.NonPositiveIntegerType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.NormalizedStringType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.NumberType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.PositiveIntegerType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.Proxy;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.QnameType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.ShortType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.SimpleURType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.StringType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.TimeType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.TokenType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.TypeIncubator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.UnionType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.UnsignedByteType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.UnsignedIntType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.UnsignedLongType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.UnsignedShortType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.WhiteSpaceProcessor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatypeImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DatatypeFactory {
    private static final Map builtinType = DatatypeFactory.createInitialBuiltinTypesMap();

    private DatatypeFactory() {
    }

    public static XSDatatype deriveByList(String string, String string2, XSDatatype xSDatatype) throws DatatypeException {
        if (xSDatatype instanceof ErrorType) {
            return xSDatatype;
        }
        return new ListType(string, string2, (XSDatatypeImpl)xSDatatype);
    }

    public static XSDatatype deriveByList(String string, XSDatatype xSDatatype) throws DatatypeException {
        return DatatypeFactory.deriveByList("", string, xSDatatype);
    }

    public static XSDatatype deriveByUnion(String string, String string2, XSDatatype[] xSDatatypeArray) throws DatatypeException {
        for (int i2 = 0; i2 < xSDatatypeArray.length; ++i2) {
            if (!(xSDatatypeArray[i2] instanceof ErrorType)) continue;
            return xSDatatypeArray[i2];
        }
        return new UnionType(string, string2, xSDatatypeArray);
    }

    public static XSDatatype deriveByUnion(String string, XSDatatype[] xSDatatypeArray) throws DatatypeException {
        return DatatypeFactory.deriveByUnion("", string, xSDatatypeArray);
    }

    public static XSDatatype deriveByUnion(String string, Collection collection) throws DatatypeException {
        return DatatypeFactory.deriveByUnion("", string, collection);
    }

    public static XSDatatype deriveByUnion(String string, String string2, Collection collection) throws DatatypeException {
        XSDatatype[] xSDatatypeArray = new XSDatatypeImpl[collection.size()];
        int n2 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            for (int i2 = 0; i2 < xSDatatypeArray.length; ++i2) {
                xSDatatypeArray[i2] = (XSDatatypeImpl)iterator.next();
            }
            ++n2;
        }
        return DatatypeFactory.deriveByUnion(string, string2, xSDatatypeArray);
    }

    private static void add(Map map, XSDatatypeImpl xSDatatypeImpl) {
        String string = xSDatatypeImpl.getName();
        if (string == null) {
            throw new IllegalArgumentException("anonymous type");
        }
        if (map.containsKey(string)) {
            throw new IllegalArgumentException("multiple definition");
        }
        map.put(string, xSDatatypeImpl);
    }

    public static synchronized XSDatatype getTypeByName(String string) throws DatatypeException {
        XSDatatype xSDatatype = (XSDatatype)builtinType.get(string);
        if (xSDatatype != null) {
            return xSDatatype;
        }
        try {
            if (string.equals("float")) {
                DatatypeFactory.add(builtinType, FloatType.theInstance);
            } else if (string.equals("double")) {
                DatatypeFactory.add(builtinType, DoubleType.theInstance);
            } else if (string.equals("duration")) {
                DatatypeFactory.add(builtinType, DurationType.theInstance);
            } else if (string.equals("dateTime")) {
                DatatypeFactory.add(builtinType, DateTimeType.theInstance);
            } else if (string.equals("time")) {
                DatatypeFactory.add(builtinType, TimeType.theInstance);
            } else if (string.equals("date")) {
                DatatypeFactory.add(builtinType, DateType.theInstance);
            } else if (string.equals("gYearMonth")) {
                DatatypeFactory.add(builtinType, GYearMonthType.theInstance);
            } else if (string.equals("gYear")) {
                DatatypeFactory.add(builtinType, GYearType.theInstance);
            } else if (string.equals("gMonthDay")) {
                DatatypeFactory.add(builtinType, GMonthDayType.theInstance);
            } else if (string.equals("gDay")) {
                DatatypeFactory.add(builtinType, GDayType.theInstance);
            } else if (string.equals("gMonth")) {
                DatatypeFactory.add(builtinType, GMonthType.theInstance);
            } else if (string.equals("hexBinary")) {
                DatatypeFactory.add(builtinType, HexBinaryType.theInstance);
            } else if (string.equals("base64Binary")) {
                DatatypeFactory.add(builtinType, Base64BinaryType.theInstance);
            } else if (string.equals("anyURI")) {
                DatatypeFactory.add(builtinType, AnyURIType.theInstance);
            } else if (string.equals("ENTITY")) {
                DatatypeFactory.add(builtinType, EntityType.theInstance);
            } else if (string.equals("language")) {
                DatatypeFactory.add(builtinType, LanguageType.theInstance);
            } else if (string.equals("ID")) {
                DatatypeFactory.add(builtinType, IDType.theInstance);
            } else if (string.equals("IDREF")) {
                DatatypeFactory.add(builtinType, IDREFType.theInstance);
            } else if (string.equals("IDREFS")) {
                DatatypeFactory.add(builtinType, DatatypeFactory.createBuiltinList("IDREFS", IDREFType.theInstance));
            } else if (string.equals("ENTITIES")) {
                DatatypeFactory.add(builtinType, DatatypeFactory.createBuiltinList("ENTITIES", EntityType.theInstance));
            } else if (string.equals("NMTOKENS")) {
                DatatypeFactory.add(builtinType, DatatypeFactory.createBuiltinList("NMTOKENS", NmtokenType.theInstance));
            } else if (string.equals("NOTATION")) {
                DatatypeFactory.add(builtinType, new StringType("NOTATION", WhiteSpaceProcessor.theCollapse, false));
            } else if (string.equals("nonPositiveInteger")) {
                DatatypeFactory.add(builtinType, NonPositiveIntegerType.theInstance);
            } else if (string.equals("unsignedLong")) {
                DatatypeFactory.add(builtinType, UnsignedLongType.theInstance);
            } else if (string.equals("unsignedInt")) {
                DatatypeFactory.add(builtinType, UnsignedIntType.theInstance);
            } else if (string.equals("unsignedShort")) {
                DatatypeFactory.add(builtinType, UnsignedShortType.theInstance);
            } else if (string.equals("unsignedByte")) {
                DatatypeFactory.add(builtinType, UnsignedByteType.theInstance);
            } else if (string.equals("anySimpleType")) {
                DatatypeFactory.add(builtinType, SimpleURType.theInstance);
            }
        }
        catch (DatatypeException datatypeException) {
            throw new Error();
        }
        xSDatatype = (XSDatatype)builtinType.get(string);
        if (xSDatatype != null) {
            return xSDatatype;
        }
        throw new DatatypeException("undefined type name:" + string);
    }

    private static XSDatatypeImpl createBuiltinList(String string, XSDatatypeImpl xSDatatypeImpl) throws DatatypeException {
        TypeIncubator typeIncubator = new TypeIncubator(new ListType(null, null, xSDatatypeImpl));
        typeIncubator.addFacet("minLength", "1", false, null);
        return new Proxy("http://www.w3.org/2001/XMLSchema", string, typeIncubator.derive(null, null)){

            private Object readResolve() {
                try {
                    return DatatypeFactory.getTypeByName(this.getName());
                }
                catch (DatatypeException datatypeException) {
                    datatypeException.printStackTrace();
                    throw new InternalError(datatypeException.getMessage());
                }
            }
        };
    }

    private static Map createInitialBuiltinTypesMap() {
        HashMap hashMap = new HashMap();
        DatatypeFactory.add(hashMap, StringType.theInstance);
        DatatypeFactory.add(hashMap, BooleanType.theInstance);
        DatatypeFactory.add(hashMap, NumberType.theInstance);
        DatatypeFactory.add(hashMap, QnameType.theInstance);
        DatatypeFactory.add(hashMap, NormalizedStringType.theInstance);
        DatatypeFactory.add(hashMap, TokenType.theInstance);
        DatatypeFactory.add(hashMap, NmtokenType.theInstance);
        DatatypeFactory.add(hashMap, NameType.theInstance);
        DatatypeFactory.add(hashMap, NcnameType.theInstance);
        DatatypeFactory.add(hashMap, IntegerType.theInstance);
        DatatypeFactory.add(hashMap, NegativeIntegerType.theInstance);
        DatatypeFactory.add(hashMap, LongType.theInstance);
        DatatypeFactory.add(hashMap, IntType.theInstance);
        DatatypeFactory.add(hashMap, ShortType.theInstance);
        DatatypeFactory.add(hashMap, ByteType.theInstance);
        DatatypeFactory.add(hashMap, NonNegativeIntegerType.theInstance);
        DatatypeFactory.add(hashMap, PositiveIntegerType.theInstance);
        return hashMap;
    }
}

