/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd;

import java.io.InputStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class MessageCatalog {
    private String bundleName;
    private Hashtable cache = new Hashtable(5);

    protected MessageCatalog(Class clazz) {
        this(clazz, "Messages");
    }

    private MessageCatalog(Class clazz, String string) {
        this.bundleName = clazz.getName();
        int n2 = this.bundleName.lastIndexOf(46);
        this.bundleName = n2 == -1 ? "" : this.bundleName.substring(0, n2) + ".";
        this.bundleName = this.bundleName + "resources." + string;
    }

    public String getMessage(Locale locale, String string) {
        ResourceBundle resourceBundle;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            resourceBundle = ResourceBundle.getBundle(this.bundleName, locale);
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = ResourceBundle.getBundle(this.bundleName, Locale.ENGLISH);
        }
        return resourceBundle.getString(string);
    }

    public String getMessage(Locale locale, String string, Object[] objectArray) {
        ResourceBundle resourceBundle;
        if (objectArray == null) {
            return this.getMessage(locale, string);
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] instanceof String || objectArray[i2] instanceof Number || objectArray[i2] instanceof Date) continue;
            objectArray[i2] = objectArray[i2] == null ? "(null)" : objectArray[i2].toString();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            resourceBundle = ResourceBundle.getBundle(this.bundleName, locale);
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = ResourceBundle.getBundle(this.bundleName, Locale.ENGLISH);
        }
        MessageFormat messageFormat = new MessageFormat(resourceBundle.getString(string));
        messageFormat.setLocale(locale);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = messageFormat.format(objectArray, stringBuffer, new FieldPosition(0));
        return stringBuffer.toString();
    }

    public Locale chooseLocale(String[] stringArray) {
        if ((stringArray = this.canonicalize(stringArray)) != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!this.isLocaleSupported(stringArray[i2])) continue;
                return this.getLocale(stringArray[i2]);
            }
        }
        return null;
    }

    private String[] canonicalize(String[] stringArray) {
        boolean bl2 = false;
        int n2 = 0;
        if (stringArray == null) {
            return stringArray;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            int n3 = string.length();
            if (n3 != 2 && n3 != 5) {
                if (!bl2) {
                    stringArray = (String[])stringArray.clone();
                    bl2 = true;
                }
                stringArray[i2] = null;
                ++n2;
                continue;
            }
            if (n3 == 2) {
                if ((string = string.toLowerCase()) == stringArray[i2]) continue;
                if (!bl2) {
                    stringArray = (String[])stringArray.clone();
                    bl2 = true;
                }
                stringArray[i2] = string;
                continue;
            }
            char[] cArray = new char[]{Character.toLowerCase(string.charAt(0)), Character.toLowerCase(string.charAt(1)), '_', Character.toUpperCase(string.charAt(3)), Character.toUpperCase(string.charAt(4))};
            if (!bl2) {
                stringArray = (String[])stringArray.clone();
                bl2 = true;
            }
            stringArray[i2] = new String(cArray);
        }
        if (n2 != 0) {
            String[] stringArray2 = new String[stringArray.length - n2];
            n2 = 0;
            for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                while (stringArray[i3 + n2] == null) {
                    ++n2;
                }
                stringArray2[i3] = stringArray[i3 + n2];
            }
            stringArray = stringArray2;
        }
        return stringArray;
    }

    private Locale getLocale(String string) {
        String string2;
        String string3;
        int n2 = string.indexOf(95);
        if (n2 == -1) {
            if (string.equals("de")) {
                return Locale.GERMAN;
            }
            if (string.equals("en")) {
                return Locale.ENGLISH;
            }
            if (string.equals("fr")) {
                return Locale.FRENCH;
            }
            if (string.equals("it")) {
                return Locale.ITALIAN;
            }
            if (string.equals("ja")) {
                return Locale.JAPANESE;
            }
            if (string.equals("ko")) {
                return Locale.KOREAN;
            }
            if (string.equals("zh")) {
                return Locale.CHINESE;
            }
            string3 = string;
            string2 = "";
        } else {
            if (string.equals("zh_CN")) {
                return Locale.SIMPLIFIED_CHINESE;
            }
            if (string.equals("zh_TW")) {
                return Locale.TRADITIONAL_CHINESE;
            }
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        }
        return new Locale(string3, string2);
    }

    public boolean isLocaleSupported(String string) {
        Boolean bl2 = (Boolean)this.cache.get(string);
        if (bl2 != null) {
            return bl2;
        }
        ClassLoader classLoader = null;
        while (true) {
            String string2 = this.bundleName + "_" + string;
            try {
                Class.forName(string2);
                this.cache.put(string, Boolean.TRUE);
                return true;
            }
            catch (Exception exception) {
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                string2 = string2.replace('.', '/');
                string2 = string2 + ".properties";
                InputStream inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string2) : classLoader.getResourceAsStream(string2);
                if (inputStream != null) {
                    this.cache.put(string, Boolean.TRUE);
                    return true;
                }
                int n2 = string.indexOf(95);
                if (n2 > 0) {
                    string = string.substring(0, n2);
                    continue;
                }
                this.cache.put(string, Boolean.FALSE);
                return false;
            }
            break;
        }
    }
}

