/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.psvi;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ElementExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.DatatypeRef;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StartTagInfo;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StringRef;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.Acceptor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.DocumentDeclaration;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.ErrorInfo;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.ValidityViolation;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.Verifier;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.psvi.TypedContentHandler;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.ComplexAcceptor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.REDocumentDeclaration;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.SimpleAcceptor;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class TypeDetector
extends Verifier {
    private StringBuffer text = new StringBuffer();
    protected TypedContentHandler handler;
    private final DatatypeRef characterType = new DatatypeRef();

    public TypeDetector(DocumentDeclaration documentDeclaration, ErrorHandler errorHandler) {
        super(documentDeclaration, errorHandler);
    }

    public TypeDetector(DocumentDeclaration documentDeclaration, TypedContentHandler typedContentHandler, ErrorHandler errorHandler) {
        this(documentDeclaration, errorHandler);
        this.setContentHandler(typedContentHandler);
    }

    public void setContentHandler(TypedContentHandler typedContentHandler) {
        this.handler = typedContentHandler;
    }

    protected void verifyText() throws SAXException {
        if (this.text.length() != 0) {
            String string = new String(this.text);
            if (!this.current.onText2(string, this, null, this.characterType)) {
                StringRef stringRef = new StringRef();
                this.current.onText2(string, this, stringRef, null);
                this.errorHandler.error(new ValidityViolation(this.locator, TypeDetector.localizeMessage("Verifier.Error.UnexpectedText", null), new ErrorInfo.BadText(string)));
            }
            this.reportCharacterChunks(string, this.characterType.types);
            this.text = new StringBuffer();
        }
    }

    private void reportCharacterChunks(String string, Datatype[] datatypeArray) throws SAXException {
        if (datatypeArray == null) {
            throw new AmbiguousDocumentException();
        }
        switch (datatypeArray.length) {
            case 0: {
                return;
            }
            case 1: {
                this.handler.characterChunk(string, datatypeArray[0]);
                return;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        for (int i2 = 0; i2 < datatypeArray.length; ++i2) {
            this.handler.characterChunk(stringTokenizer.nextToken(), datatypeArray[i2]);
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new Error();
        }
    }

    protected Datatype[] feedAttribute(Acceptor acceptor, String string, String string2, String string3, String string4) throws SAXException {
        this.handler.startAttribute(string, string2, string3);
        Datatype[] datatypeArray = super.feedAttribute(acceptor, string, string2, string3, string4);
        this.reportCharacterChunks(string4, datatypeArray);
        this.handler.endAttribute(string, string2, string3, ((REDocumentDeclaration)this.docDecl).attToken.matchedExp);
        return datatypeArray;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        this.handler.endAttributePart();
    }

    protected void onNextAcceptorReady(StartTagInfo startTagInfo, Acceptor acceptor) throws SAXException {
        this.handler.startElement(startTagInfo.namespaceURI, startTagInfo.localName, startTagInfo.qName);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        ElementExp elementExp;
        Acceptor acceptor = this.current;
        super.endElement(string, string2, string3);
        if (acceptor instanceof SimpleAcceptor) {
            elementExp = ((SimpleAcceptor)acceptor).owner;
        } else if (acceptor instanceof ComplexAcceptor) {
            ElementExp[] elementExpArray = ((ComplexAcceptor)acceptor).getSatisfiedOwners();
            if (elementExpArray.length != 1) {
                throw new AmbiguousDocumentException();
            }
            elementExp = elementExpArray[0];
        } else {
            throw new Error();
        }
        this.handler.endElement(string, string2, string3, elementExp);
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        this.text.append(cArray, n2, n3);
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        this.text.append(cArray, n2, n3);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.handler.startDocument(this);
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.handler.endDocument();
    }

    public class AmbiguousDocumentException
    extends SAXException {
        public AmbiguousDocumentException() {
            super("");
        }

        Locator getLocation() {
            return TypeDetector.this.getLocator();
        }
    }
}

