/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.WriterConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.CharsetNames;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.CompletelyCloseable;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.XmlWriter;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.typed.AsciiValueEncoder;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;

public final class BufferingXmlWriter
extends XmlWriter
implements XMLStreamConstants {
    static final int DEFAULT_BUFFER_SIZE = 1000;
    static final int DEFAULT_SMALL_SIZE = 256;
    protected static final int HIGHEST_ENCODABLE_ATTR_CHAR = 60;
    protected static final int HIGHEST_ENCODABLE_TEXT_CHAR = 62;
    protected static final int[] QUOTABLE_TEXT_CHARS;
    protected final Writer mOut;
    protected char[] mOutputBuffer;
    protected final int mSmallWriteSize;
    protected int mOutputPtr;
    protected int mOutputBufLen;
    protected final OutputStream mUnderlyingStream;
    private final int mEncHighChar;
    final char mEncQuoteChar;
    final String mEncQuoteEntity;

    public BufferingXmlWriter(Writer writer, WriterConfig writerConfig, String string, boolean bl2, OutputStream outputStream, int n2) throws IOException {
        super(writerConfig, string, bl2);
        this.mOut = writer;
        this.mOutputBuffer = writerConfig.allocFullCBuffer(1000);
        this.mOutputBufLen = this.mOutputBuffer.length;
        this.mSmallWriteSize = 256;
        this.mOutputPtr = 0;
        this.mUnderlyingStream = outputStream;
        this.mEncQuoteChar = (char)34;
        this.mEncQuoteEntity = "&quot;";
        if (n2 < 1) {
            n2 = BufferingXmlWriter.guessEncodingBitSize(string);
        }
        this.mEncHighChar = n2 < 16 ? 1 << n2 : 65534;
    }

    @Override
    protected int getOutputPtr() {
        return this.mOutputPtr;
    }

    @Override
    protected final OutputStream getOutputStream() {
        return this.mUnderlyingStream;
    }

    @Override
    protected final Writer getWriter() {
        return this.mOut;
    }

    @Override
    public void close(boolean bl2) throws IOException {
        this.flush();
        this.mTextWriter = null;
        this.mAttrValueWriter = null;
        char[] cArray = this.mOutputBuffer;
        if (cArray != null) {
            this.mOutputBuffer = null;
            this.mConfig.freeFullCBuffer(cArray);
        }
        if (bl2 || this.mAutoCloseOutput) {
            if (this.mOut instanceof CompletelyCloseable) {
                ((CompletelyCloseable)((Object)this.mOut)).closeCompletely();
            } else {
                this.mOut.close();
            }
        }
    }

    @Override
    public final void flush() throws IOException {
        this.flushBuffer();
        this.mOut.flush();
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) throws IOException {
        if (this.mOut == null) {
            return;
        }
        if (n3 < this.mSmallWriteSize) {
            if (this.mOutputPtr + n3 > this.mOutputBufLen) {
                this.flushBuffer();
            }
            System.arraycopy(cArray, n2, this.mOutputBuffer, this.mOutputPtr, n3);
            this.mOutputPtr += n3;
            return;
        }
        int n4 = this.mOutputPtr;
        if (n4 > 0) {
            if (n4 < this.mSmallWriteSize) {
                int n5 = this.mSmallWriteSize - n4;
                System.arraycopy(cArray, n2, this.mOutputBuffer, n4, n5);
                this.mOutputPtr = n4 + n5;
                n3 -= n5;
                n2 += n5;
            }
            this.flushBuffer();
        }
        this.mOut.write(cArray, n2, n3);
    }

    @Override
    public final void writeRawAscii(char[] cArray, int n2, int n3) throws IOException {
        this.writeRaw(cArray, n2, n3);
    }

    @Override
    public void writeRaw(String string) throws IOException {
        if (this.mOut == null) {
            return;
        }
        int n2 = string.length();
        if (n2 < this.mSmallWriteSize) {
            if (this.mOutputPtr + n2 >= this.mOutputBufLen) {
                this.flushBuffer();
            }
            string.getChars(0, n2, this.mOutputBuffer, this.mOutputPtr);
            this.mOutputPtr += n2;
            return;
        }
        this.writeRaw(string, 0, n2);
    }

    @Override
    public void writeRaw(String string, int n2, int n3) throws IOException {
        if (this.mOut == null) {
            return;
        }
        if (n3 < this.mSmallWriteSize) {
            if (this.mOutputPtr + n3 >= this.mOutputBufLen) {
                this.flushBuffer();
            }
            string.getChars(n2, n2 + n3, this.mOutputBuffer, this.mOutputPtr);
            this.mOutputPtr += n3;
            return;
        }
        int n4 = this.mOutputPtr;
        if (n4 > 0) {
            if (n4 < this.mSmallWriteSize) {
                int n5 = this.mSmallWriteSize - n4;
                string.getChars(n2, n2 + n5, this.mOutputBuffer, n4);
                this.mOutputPtr = n4 + n5;
                n3 -= n5;
                n2 += n5;
            }
            this.flushBuffer();
        }
        this.mOut.write(string, n2, n3);
    }

    @Override
    public final void writeCDataStart() throws IOException {
        this.fastWriteRaw("<![CDATA[");
    }

    @Override
    public final void writeCDataEnd() throws IOException {
        this.fastWriteRaw("]]>");
    }

    @Override
    public final void writeCommentStart() throws IOException {
        this.fastWriteRaw("<!--");
    }

    @Override
    public final void writeCommentEnd() throws IOException {
        this.fastWriteRaw("-->");
    }

    @Override
    public final void writePIStart(String string, boolean bl2) throws IOException {
        this.fastWriteRaw('<', '?');
        this.fastWriteRaw(string);
        if (bl2) {
            this.fastWriteRaw(' ');
        }
    }

    @Override
    public final void writePIEnd() throws IOException {
        this.fastWriteRaw('?', '>');
    }

    @Override
    public int writeCData(String string) throws IOException {
        int n2;
        if (this.mCheckContent && (n2 = this.verifyCDataContent(string)) >= 0) {
            if (!this.mFixContent) {
                return n2;
            }
            this.writeSegmentedCData(string, n2);
            return -1;
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(string, 0, string.length());
        this.fastWriteRaw("]]>");
        return -1;
    }

    @Override
    public int writeCData(char[] cArray, int n2, int n3) throws IOException {
        int n4;
        if (this.mCheckContent && (n4 = this.verifyCDataContent(cArray, n2, n3)) >= 0) {
            if (!this.mFixContent) {
                return n4;
            }
            this.writeSegmentedCData(cArray, n2, n3, n4);
            return -1;
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(cArray, n2, n3);
        this.fastWriteRaw("]]>");
        return -1;
    }

    @Override
    public void writeCharacters(String string) throws IOException {
        if (this.mOut == null) {
            return;
        }
        if (this.mTextWriter != null) {
            this.mTextWriter.write(string);
            return;
        }
        int n2 = 0;
        int n3 = string.length();
        int[] nArray = QUOTABLE_TEXT_CHARS;
        int n4 = this.mEncHighChar;
        int n5 = Math.min(nArray.length, n4);
        block0: while (true) {
            String string2 = null;
            while (n2 < n3) {
                block14: {
                    char c2;
                    block11: {
                        block10: {
                            block17: {
                                block16: {
                                    block15: {
                                        block12: {
                                            block13: {
                                                if ((c2 = string.charAt(n2++)) >= n5) break block10;
                                                if (nArray[c2] == 0) break block11;
                                                if (c2 >= ' ') break block12;
                                                if (c2 == '\n' || c2 == '\t') break block11;
                                                if (c2 != '\r') break block13;
                                                if (!this.mEscapeCR) break block11;
                                                break block14;
                                            }
                                            if (this.mXml11 && c2 != '\u0000') break block14;
                                            c2 = this.handleInvalidChar(c2);
                                            string2 = String.valueOf(c2);
                                            break block11;
                                        }
                                        if (c2 != '<') break block15;
                                        string2 = "&lt;";
                                        break block14;
                                    }
                                    if (c2 != '&') break block16;
                                    string2 = "&amp;";
                                    break block14;
                                }
                                if (c2 != '>') break block17;
                                if (n2 >= 2 && string.charAt(n2 - 2) != ']') break block11;
                                string2 = "&gt;";
                                break block14;
                            }
                            if (c2 < '\u007f') break block11;
                            break block14;
                        }
                        if (c2 >= n4) break block14;
                    }
                    if (this.mOutputPtr >= this.mOutputBufLen) {
                        this.flushBuffer();
                    }
                    this.mOutputBuffer[this.mOutputPtr++] = c2;
                    continue;
                }
                if (string2 != null) {
                    this.writeRaw(string2);
                    continue block0;
                }
                this.writeAsEntity(string.charAt(n2 - 1));
                continue block0;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeCharacters(char[] cArray, int n2, int n3) throws IOException {
        if (this.mOut == null) {
            return;
        }
        if (this.mTextWriter != null) {
            this.mTextWriter.write(cArray, n2, n3);
            return;
        }
        int[] nArray = QUOTABLE_TEXT_CHARS;
        int n4 = this.mEncHighChar;
        int n5 = Math.min(nArray.length, n4);
        n3 += n2;
        do {
            int n6;
            char c2 = '\u0000';
            int n7 = n2;
            String string = null;
            while (n2 < n3) {
                block16: {
                    block17: {
                        block18: {
                            c2 = cArray[n2];
                            if (c2 >= n5) break block17;
                            if (nArray[c2] == 0) break block16;
                            if (c2 == '<') {
                                string = "&lt;";
                                break;
                            }
                            if (c2 == '&') {
                                string = "&amp;";
                                break;
                            }
                            if (c2 != '>') break block18;
                            if (n2 == n7 || cArray[n2 - 1] == ']') {
                                string = "&gt;";
                                break;
                            }
                            break block16;
                        }
                        if (c2 < ' ') {
                            if (c2 != '\n' && c2 != '\t') {
                                if (c2 == '\r') {
                                    if (this.mEscapeCR) {
                                        break;
                                    }
                                    break block16;
                                } else {
                                    if (this.mXml11 && c2 != '\u0000') break;
                                    c2 = this.handleInvalidChar(c2);
                                    string = String.valueOf(c2);
                                    break;
                                }
                            }
                            break block16;
                        } else if (c2 >= '\u007f') {
                            break;
                        }
                        break block16;
                    }
                    if (c2 >= n4) break;
                }
                ++n2;
            }
            if ((n6 = n2 - n7) > 0) {
                this.writeRaw(cArray, n7, n6);
            }
            if (string != null) {
                this.writeRaw(string);
                string = null;
                continue;
            }
            if (n2 >= n3) continue;
            this.writeAsEntity(c2);
        } while (++n2 < n3);
    }

    @Override
    public int writeComment(String string) throws IOException {
        int n2;
        if (this.mCheckContent && (n2 = this.verifyCommentContent(string)) >= 0) {
            if (!this.mFixContent) {
                return n2;
            }
            this.writeSegmentedComment(string, n2);
            return -1;
        }
        this.fastWriteRaw("<!--");
        this.writeRaw(string);
        this.fastWriteRaw("-->");
        return -1;
    }

    @Override
    public void writeDTD(String string) throws IOException {
        this.writeRaw(string);
    }

    @Override
    public void writeDTD(String string, String string2, String string3, String string4) throws IOException, XMLStreamException {
        this.fastWriteRaw("<!DOCTYPE ");
        if (this.mCheckNames) {
            this.verifyNameValidity(string, false);
        }
        this.fastWriteRaw(string);
        if (string2 != null) {
            if (string3 != null) {
                this.fastWriteRaw(" PUBLIC \"");
                this.fastWriteRaw(string3);
                this.fastWriteRaw("\" \"");
            } else {
                this.fastWriteRaw(" SYSTEM \"");
            }
            this.fastWriteRaw(string2);
            this.fastWriteRaw('\"');
        }
        if (string4 != null && string4.length() > 0) {
            this.fastWriteRaw(' ', '[');
            this.fastWriteRaw(string4);
            this.fastWriteRaw(']');
        }
        this.fastWriteRaw('>');
    }

    @Override
    public void writeEntityReference(String string) throws IOException, XMLStreamException {
        if (this.mCheckNames) {
            this.verifyNameValidity(string, this.mNsAware);
        }
        this.fastWriteRaw('&');
        this.fastWriteRaw(string);
        this.fastWriteRaw(';');
    }

    @Override
    public void writeXmlDeclaration(String string, String string2, String string3) throws IOException {
        char c2 = this.mUseDoubleQuotesInXmlDecl ? (char)'\"' : '\'';
        this.fastWriteRaw("<?xml version=");
        this.fastWriteRaw(c2);
        this.fastWriteRaw(string);
        this.fastWriteRaw(c2);
        if (string2 != null && string2.length() > 0) {
            this.fastWriteRaw(" encoding=");
            this.fastWriteRaw(c2);
            this.fastWriteRaw(string2);
            this.fastWriteRaw(c2);
        }
        if (string3 != null) {
            this.fastWriteRaw(" standalone=");
            this.fastWriteRaw(c2);
            this.fastWriteRaw(string3);
            this.fastWriteRaw(c2);
        }
        this.fastWriteRaw('?', '>');
    }

    @Override
    public int writePI(String string, String string2) throws IOException, XMLStreamException {
        if (this.mCheckNames) {
            this.verifyNameValidity(string, this.mNsAware);
        }
        this.fastWriteRaw('<', '?');
        this.fastWriteRaw(string);
        if (string2 != null && string2.length() > 0) {
            int n2;
            if (this.mCheckContent && (n2 = string2.indexOf(63)) >= 0 && (n2 = string2.indexOf("?>", n2)) >= 0) {
                return n2;
            }
            this.fastWriteRaw(' ');
            this.writeRaw(string2);
        }
        this.fastWriteRaw('?', '>');
        return -1;
    }

    @Override
    public void writeStartTagStart(String string) throws IOException, XMLStreamException {
        int n2;
        int n3;
        if (this.mCheckNames) {
            this.verifyNameValidity(string, this.mNsAware);
        }
        if ((n3 = this.mOutputBufLen - (n2 = this.mOutputPtr) - (1 + string.length())) < 0) {
            this.fastWriteRaw('<');
            this.fastWriteRaw(string);
        } else {
            char[] cArray = this.mOutputBuffer;
            cArray[n2++] = 60;
            int n4 = string.length();
            string.getChars(0, n4, cArray, n2);
            this.mOutputPtr = n2 + n4;
        }
    }

    @Override
    public void writeStartTagStart(String string, String string2) throws IOException, XMLStreamException {
        if (string == null || string.length() == 0) {
            this.writeStartTagStart(string2);
            return;
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(string, this.mNsAware);
            this.verifyNameValidity(string2, this.mNsAware);
        }
        int n2 = this.mOutputPtr;
        int n3 = string.length();
        int n4 = this.mOutputBufLen - n2 - (2 + string2.length() + n3);
        if (n4 < 0) {
            this.fastWriteRaw('<');
            this.fastWriteRaw(string);
            this.fastWriteRaw(':');
            this.fastWriteRaw(string2);
        } else {
            char[] cArray = this.mOutputBuffer;
            cArray[n2++] = 60;
            string.getChars(0, n3, cArray, n2);
            n2 += n3;
            cArray[n2++] = 58;
            n3 = string2.length();
            string2.getChars(0, n3, cArray, n2);
            this.mOutputPtr = n2 + n3;
        }
    }

    @Override
    public void writeStartTagEnd() throws IOException {
        this.fastWriteRaw('>');
    }

    @Override
    public void writeStartTagEmptyEnd() throws IOException {
        int n2 = this.mOutputPtr;
        if (n2 + 3 >= this.mOutputBufLen) {
            if (this.mOut == null) {
                return;
            }
            this.flushBuffer();
            n2 = this.mOutputPtr;
        }
        char[] cArray = this.mOutputBuffer;
        if (this.mAddSpaceAfterEmptyElem) {
            cArray[n2++] = 32;
        }
        cArray[n2++] = 47;
        cArray[n2++] = 62;
        this.mOutputPtr = n2;
    }

    @Override
    public void writeEndTag(String string) throws IOException {
        int n2 = this.mOutputPtr;
        int n3 = this.mOutputBufLen - n2 - (3 + string.length());
        if (n3 < 0) {
            this.fastWriteRaw('<', '/');
            this.fastWriteRaw(string);
            this.fastWriteRaw('>');
        } else {
            char[] cArray = this.mOutputBuffer;
            cArray[n2++] = 60;
            cArray[n2++] = 47;
            int n4 = string.length();
            string.getChars(0, n4, cArray, n2);
            n2 += n4;
            cArray[n2++] = 62;
            this.mOutputPtr = n2;
        }
    }

    @Override
    public void writeEndTag(String string, String string2) throws IOException {
        if (string == null || string.length() == 0) {
            this.writeEndTag(string2);
            return;
        }
        int n2 = this.mOutputPtr;
        int n3 = string.length();
        int n4 = this.mOutputBufLen - n2 - (4 + string2.length() + n3);
        if (n4 < 0) {
            this.fastWriteRaw('<', '/');
            this.fastWriteRaw(string);
            this.fastWriteRaw(':');
            this.fastWriteRaw(string2);
            this.fastWriteRaw('>');
        } else {
            char[] cArray = this.mOutputBuffer;
            cArray[n2++] = 60;
            cArray[n2++] = 47;
            string.getChars(0, n3, cArray, n2);
            n2 += n3;
            cArray[n2++] = 58;
            n3 = string2.length();
            string2.getChars(0, n3, cArray, n2);
            n2 += n3;
            cArray[n2++] = 62;
            this.mOutputPtr = n2;
        }
    }

    @Override
    public void writeAttribute(String string, String string2) throws IOException, XMLStreamException {
        int n2;
        if (this.mOut == null) {
            return;
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(string, this.mNsAware);
        }
        if (this.mOutputBufLen - this.mOutputPtr - (3 + (n2 = string.length())) < 0) {
            this.fastWriteRaw(' ');
            this.fastWriteRaw(string);
            this.fastWriteRaw('=', '\"');
        } else {
            int n3 = this.mOutputPtr;
            char[] cArray = this.mOutputBuffer;
            cArray[n3++] = 32;
            string.getChars(0, n2, cArray, n3);
            n3 += n2;
            cArray[n3++] = 61;
            cArray[n3++] = 34;
            this.mOutputPtr = n3;
        }
        int n4 = n2 = string2 == null ? 0 : string2.length();
        if (n2 > 0) {
            if (this.mAttrValueWriter != null) {
                this.mAttrValueWriter.write(string2, 0, n2);
            } else {
                this.writeAttrValue(string2, n2);
            }
        }
        this.fastWriteRaw('\"');
    }

    @Override
    public void writeAttribute(String string, char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        int n4;
        if (this.mOut == null) {
            return;
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(string, this.mNsAware);
        }
        if (this.mOutputBufLen - this.mOutputPtr - (3 + (n4 = string.length())) < 0) {
            this.fastWriteRaw(' ');
            this.fastWriteRaw(string);
            this.fastWriteRaw('=', '\"');
        } else {
            int n5 = this.mOutputPtr;
            char[] cArray2 = this.mOutputBuffer;
            cArray2[n5++] = 32;
            string.getChars(0, n4, cArray2, n5);
            n5 += n4;
            cArray2[n5++] = 61;
            cArray2[n5++] = 34;
            this.mOutputPtr = n5;
        }
        if (n3 > 0) {
            if (this.mAttrValueWriter != null) {
                this.mAttrValueWriter.write(cArray, n2, n3);
            } else {
                this.writeAttrValue(cArray, n2, n3);
            }
        }
        this.fastWriteRaw('\"');
    }

    @Override
    public void writeAttribute(String string, String string2, String string3) throws IOException, XMLStreamException {
        if (this.mOut == null) {
            return;
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(string, this.mNsAware);
            this.verifyNameValidity(string2, this.mNsAware);
        }
        int n2 = string.length();
        if (this.mOutputBufLen - this.mOutputPtr - (4 + string2.length() + n2) < 0) {
            this.fastWriteRaw(' ');
            if (n2 > 0) {
                this.fastWriteRaw(string);
                this.fastWriteRaw(':');
            }
            this.fastWriteRaw(string2);
            this.fastWriteRaw('=', '\"');
        } else {
            int n3 = this.mOutputPtr;
            char[] cArray = this.mOutputBuffer;
            cArray[n3++] = 32;
            string.getChars(0, n2, cArray, n3);
            n3 += n2;
            cArray[n3++] = 58;
            n2 = string2.length();
            string2.getChars(0, n2, cArray, n3);
            n3 += n2;
            cArray[n3++] = 61;
            cArray[n3++] = 34;
            this.mOutputPtr = n3;
        }
        int n4 = n2 = string3 == null ? 0 : string3.length();
        if (n2 > 0) {
            if (this.mAttrValueWriter != null) {
                this.mAttrValueWriter.write(string3, 0, n2);
            } else {
                this.writeAttrValue(string3, n2);
            }
        }
        this.fastWriteRaw('\"');
    }

    @Override
    public void writeAttribute(String string, String string2, char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        if (this.mOut == null) {
            return;
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(string, this.mNsAware);
            this.verifyNameValidity(string2, this.mNsAware);
        }
        int n4 = string.length();
        if (this.mOutputBufLen - this.mOutputPtr - (4 + string2.length() + n4) < 0) {
            this.fastWriteRaw(' ');
            if (n4 > 0) {
                this.fastWriteRaw(string);
                this.fastWriteRaw(':');
            }
            this.fastWriteRaw(string2);
            this.fastWriteRaw('=', '\"');
        } else {
            int n5 = this.mOutputPtr;
            char[] cArray2 = this.mOutputBuffer;
            cArray2[n5++] = 32;
            string.getChars(0, n4, cArray2, n5);
            n5 += n4;
            cArray2[n5++] = 58;
            n4 = string2.length();
            string2.getChars(0, n4, cArray2, n5);
            n5 += n4;
            cArray2[n5++] = 61;
            cArray2[n5++] = 34;
            this.mOutputPtr = n5;
        }
        if (n3 > 0) {
            if (this.mAttrValueWriter != null) {
                this.mAttrValueWriter.write(cArray, n2, n3);
            } else {
                this.writeAttrValue(cArray, n2, n3);
            }
        }
        this.fastWriteRaw('\"');
    }

    private final void writeAttrValue(String string, int n2) throws IOException {
        int n3 = 0;
        char c2 = this.mEncQuoteChar;
        int n4 = this.mEncHighChar;
        block0: while (true) {
            String string2 = null;
            while (n3 < n2) {
                block11: {
                    char c3;
                    block10: {
                        block7: {
                            block13: {
                                block12: {
                                    block8: {
                                        block9: {
                                            if ((c3 = string.charAt(n3++)) > '<') break block7;
                                            if (c3 >= ' ') break block8;
                                            if (c3 != '\r') break block9;
                                            if (!this.mEscapeCR) break block10;
                                            break block11;
                                        }
                                        if (c3 == '\n' || c3 == '\t' || this.mXml11 && c3 != '\u0000') break block11;
                                        c3 = this.handleInvalidChar(c3);
                                        break block10;
                                    }
                                    if (c3 != c2) break block12;
                                    string2 = this.mEncQuoteEntity;
                                    break block11;
                                }
                                if (c3 != '<') break block13;
                                string2 = "&lt;";
                                break block11;
                            }
                            if (c3 != '&') break block10;
                            string2 = "&amp;";
                            break block11;
                        }
                        if (c3 >= n4) break block11;
                    }
                    if (this.mOutputPtr >= this.mOutputBufLen) {
                        this.flushBuffer();
                    }
                    this.mOutputBuffer[this.mOutputPtr++] = c3;
                    continue;
                }
                if (string2 != null) {
                    this.writeRaw(string2);
                    continue block0;
                }
                this.writeAsEntity(string.charAt(n3 - 1));
                continue block0;
            }
            break;
        }
    }

    private final void writeAttrValue(char[] cArray, int n2, int n3) throws IOException {
        n3 += n2;
        char c2 = this.mEncQuoteChar;
        int n4 = this.mEncHighChar;
        block0: while (true) {
            String string = null;
            while (n2 < n3) {
                block11: {
                    char c3;
                    block10: {
                        block7: {
                            block13: {
                                block12: {
                                    block8: {
                                        block9: {
                                            if ((c3 = cArray[n2++]) > '<') break block7;
                                            if (c3 >= ' ') break block8;
                                            if (c3 != '\r') break block9;
                                            if (!this.mEscapeCR) break block10;
                                            break block11;
                                        }
                                        if (c3 == '\n' || c3 == '\t' || this.mXml11 && c3 != '\u0000') break block11;
                                        c3 = this.handleInvalidChar(c3);
                                        break block10;
                                    }
                                    if (c3 != c2) break block12;
                                    string = this.mEncQuoteEntity;
                                    break block11;
                                }
                                if (c3 != '<') break block13;
                                string = "&lt;";
                                break block11;
                            }
                            if (c3 != '&') break block10;
                            string = "&amp;";
                            break block11;
                        }
                        if (c3 >= n4) break block11;
                    }
                    if (this.mOutputPtr >= this.mOutputBufLen) {
                        this.flushBuffer();
                    }
                    this.mOutputBuffer[this.mOutputPtr++] = c3;
                    continue;
                }
                if (string != null) {
                    this.writeRaw(string);
                    continue block0;
                }
                this.writeAsEntity(cArray[n2 - 1]);
                continue block0;
            }
            break;
        }
    }

    @Override
    public final void writeTypedElement(AsciiValueEncoder asciiValueEncoder) throws IOException {
        if (this.mOut == null) {
            return;
        }
        int n2 = this.mOutputBufLen - this.mOutputPtr;
        if (asciiValueEncoder.bufferNeedsFlush(n2)) {
            this.flush();
        }
        while (true) {
            this.mOutputPtr = asciiValueEncoder.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBufLen);
            if (asciiValueEncoder.isCompleted()) break;
            this.flush();
        }
    }

    @Override
    public final void writeTypedElement(AsciiValueEncoder asciiValueEncoder, XMLValidator xMLValidator, char[] cArray) throws IOException, XMLStreamException {
        if (this.mOut == null) {
            return;
        }
        int n2 = this.mOutputBufLen - this.mOutputPtr;
        if (asciiValueEncoder.bufferNeedsFlush(n2)) {
            this.flush();
        }
        int n3 = this.mOutputPtr;
        while (true) {
            this.mOutputPtr = asciiValueEncoder.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBufLen);
            xMLValidator.validateText(this.mOutputBuffer, n3, this.mOutputPtr, false);
            if (asciiValueEncoder.isCompleted()) break;
            this.flush();
            n3 = this.mOutputPtr;
        }
    }

    @Override
    public void writeTypedAttribute(String string, AsciiValueEncoder asciiValueEncoder) throws IOException, XMLStreamException {
        int n2;
        int n3;
        if (this.mOut == null) {
            return;
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(string, this.mNsAware);
        }
        if (this.mOutputPtr + 3 + (n3 = string.length()) > this.mOutputBufLen) {
            this.fastWriteRaw(' ');
            this.fastWriteRaw(string);
            this.fastWriteRaw('=', '\"');
        } else {
            n2 = this.mOutputPtr;
            char[] cArray = this.mOutputBuffer;
            cArray[n2++] = 32;
            string.getChars(0, n3, cArray, n2);
            n2 += n3;
            cArray[n2++] = 61;
            cArray[n2++] = 34;
            this.mOutputPtr = n2;
        }
        n2 = this.mOutputBufLen - this.mOutputPtr;
        if (asciiValueEncoder.bufferNeedsFlush(n2)) {
            this.flush();
        }
        while (true) {
            this.mOutputPtr = asciiValueEncoder.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBufLen);
            if (asciiValueEncoder.isCompleted()) break;
            this.flush();
        }
        this.fastWriteRaw('\"');
    }

    @Override
    public void writeTypedAttribute(String string, String string2, AsciiValueEncoder asciiValueEncoder) throws IOException, XMLStreamException {
        int n2;
        int n3;
        int n4;
        if (this.mOut == null) {
            return;
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(string, this.mNsAware);
            this.verifyNameValidity(string2, this.mNsAware);
        }
        if (this.mOutputPtr + 4 + (n4 = string.length()) + (n3 = string2.length()) > this.mOutputBufLen) {
            this.writePrefixedName(string, string2);
            this.fastWriteRaw('=', '\"');
        } else {
            n2 = this.mOutputPtr;
            char[] cArray = this.mOutputBuffer;
            cArray[n2++] = 32;
            if (n4 > 0) {
                string.getChars(0, n4, cArray, n2);
                n2 += n4;
                cArray[n2++] = 58;
            }
            string2.getChars(0, n3, cArray, n2);
            n2 += n3;
            cArray[n2++] = 61;
            cArray[n2++] = 34;
            this.mOutputPtr = n2;
        }
        n2 = this.mOutputBufLen - this.mOutputPtr;
        if (asciiValueEncoder.bufferNeedsFlush(n2)) {
            this.flush();
        }
        while (true) {
            this.mOutputPtr = asciiValueEncoder.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBufLen);
            if (asciiValueEncoder.isCompleted()) break;
            this.flush();
        }
        this.fastWriteRaw('\"');
    }

    @Override
    public void writeTypedAttribute(String string, String string2, String string3, AsciiValueEncoder asciiValueEncoder, XMLValidator xMLValidator, char[] cArray) throws IOException, XMLStreamException {
        int n2;
        if (this.mOut == null) {
            return;
        }
        if (string == null) {
            string = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        int n3 = string.length();
        if (this.mCheckNames) {
            if (n3 > 0) {
                this.verifyNameValidity(string, this.mNsAware);
            }
            this.verifyNameValidity(string2, this.mNsAware);
        }
        if (this.mOutputBufLen - this.mOutputPtr - (4 + string2.length() + n3) < 0) {
            this.writePrefixedName(string, string2);
            this.fastWriteRaw('=', '\"');
        } else {
            n2 = this.mOutputPtr;
            char[] cArray2 = this.mOutputBuffer;
            cArray2[n2++] = 32;
            if (n3 > 0) {
                string.getChars(0, n3, cArray2, n2);
                n2 += n3;
                cArray2[n2++] = 58;
            }
            int n4 = string2.length();
            string2.getChars(0, n4, cArray2, n2);
            n2 += n4;
            cArray2[n2++] = 61;
            cArray2[n2++] = 34;
            this.mOutputPtr = n2;
        }
        n2 = this.mOutputBufLen - this.mOutputPtr;
        if (asciiValueEncoder.bufferNeedsFlush(n2)) {
            this.flush();
        }
        int n5 = this.mOutputPtr;
        this.mOutputPtr = asciiValueEncoder.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBufLen);
        if (asciiValueEncoder.isCompleted()) {
            xMLValidator.validateAttribute(string2, string3, string, this.mOutputBuffer, n5, this.mOutputPtr);
            this.fastWriteRaw('\"');
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(this.mOutputBuffer.length << 1);
        stringBuilder.append(this.mOutputBuffer, n5, this.mOutputPtr - n5);
        do {
            this.flush();
            n5 = this.mOutputPtr;
            this.mOutputPtr = asciiValueEncoder.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBufLen);
            stringBuilder.append(this.mOutputBuffer, n5, this.mOutputPtr - n5);
        } while (!asciiValueEncoder.isCompleted());
        this.fastWriteRaw('\"');
        String string4 = stringBuilder.toString();
        xMLValidator.validateAttribute(string2, string3, string, string4);
    }

    protected final void writePrefixedName(String string, String string2) throws IOException {
        this.fastWriteRaw(' ');
        if (string.length() > 0) {
            this.fastWriteRaw(string);
            this.fastWriteRaw(':');
        }
        this.fastWriteRaw(string2);
    }

    private final void flushBuffer() throws IOException {
        if (this.mOutputPtr > 0 && this.mOutputBuffer != null) {
            int n2 = this.mOutputPtr;
            this.mLocPastChars += n2;
            this.mLocRowStartOffset -= n2;
            this.mOutputPtr = 0;
            this.mOut.write(this.mOutputBuffer, 0, n2);
        }
    }

    private final void fastWriteRaw(char c2) throws IOException {
        if (this.mOutputPtr >= this.mOutputBufLen) {
            if (this.mOut == null) {
                return;
            }
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputPtr++] = c2;
    }

    private final void fastWriteRaw(char c2, char c3) throws IOException {
        if (this.mOutputPtr + 1 >= this.mOutputBufLen) {
            if (this.mOut == null) {
                return;
            }
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputPtr++] = c2;
        this.mOutputBuffer[this.mOutputPtr++] = c3;
    }

    private final void fastWriteRaw(String string) throws IOException {
        int n2 = this.mOutputPtr;
        int n3 = string.length();
        if (n2 + n3 >= this.mOutputBufLen) {
            if (this.mOut == null) {
                return;
            }
            if (n3 > this.mOutputBufLen) {
                this.writeRaw(string);
                return;
            }
            this.flushBuffer();
            n2 = this.mOutputPtr;
        }
        string.getChars(0, n3, this.mOutputBuffer, n2);
        this.mOutputPtr = n2 + n3;
    }

    protected int verifyCDataContent(String string) {
        int n2;
        if (string != null && string.length() >= 3 && (n2 = string.indexOf(93)) >= 0) {
            return string.indexOf("]]>", n2);
        }
        return -1;
    }

    protected int verifyCDataContent(char[] cArray, int n2, int n3) {
        if (cArray != null) {
            n2 += 2;
            while (n2 < n3) {
                char c2 = cArray[n2];
                if (c2 == ']') {
                    ++n2;
                    continue;
                }
                if (c2 == '>' && cArray[n2 - 1] == ']' && cArray[n2 - 2] == ']') {
                    return n2 - 2;
                }
                n2 += 2;
            }
        }
        return -1;
    }

    protected int verifyCommentContent(String string) {
        int n2 = string.indexOf(45);
        if (n2 >= 0 && n2 < string.length() - 1) {
            n2 = string.indexOf("--", n2);
        }
        return n2;
    }

    protected void writeSegmentedCData(String string, int n2) throws IOException {
        int n3 = 0;
        while (n2 >= 0) {
            this.fastWriteRaw("<![CDATA[");
            this.writeRaw(string, n3, n2 + 2 - n3);
            this.fastWriteRaw("]]>");
            n3 = n2 + 2;
            n2 = string.indexOf("]]>", n3);
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(string, n3, string.length() - n3);
        this.fastWriteRaw("]]>");
    }

    protected void writeSegmentedCData(char[] cArray, int n2, int n3, int n4) throws IOException {
        int n5 = n2 + n3;
        while (n4 >= 0) {
            this.fastWriteRaw("<![CDATA[");
            this.writeRaw(cArray, n2, n4 + 2 - n2);
            this.fastWriteRaw("]]>");
            n2 = n4 + 2;
            n4 = this.verifyCDataContent(cArray, n2, n5);
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(cArray, n2, n5 - n2);
        this.fastWriteRaw("]]>");
    }

    protected void writeSegmentedComment(String string, int n2) throws IOException {
        int n3 = string.length();
        if (n2 == n3 - 1) {
            this.fastWriteRaw("<!--");
            this.writeRaw(string);
            this.fastWriteRaw(" -->");
            return;
        }
        this.fastWriteRaw("<!--");
        int n4 = 0;
        while (n2 >= 0) {
            this.writeRaw(string, n4, n2 + 1 - n4);
            this.fastWriteRaw(' ');
            n4 = n2 + 1;
            n2 = string.indexOf("--", n4);
        }
        this.writeRaw(string, n4, n3 - n4);
        if (string.charAt(n3 - 1) == '-') {
            this.fastWriteRaw(' ');
        }
        this.fastWriteRaw("-->");
    }

    public static int guessEncodingBitSize(String string) {
        if (string == null || string.length() == 0) {
            return 16;
        }
        if ((string = CharsetNames.normalize(string)) == "UTF-8") {
            return 16;
        }
        if (string == "ISO-8859-1") {
            return 8;
        }
        if (string == "US-ASCII") {
            return 7;
        }
        if (string == "UTF-16" || string == "UTF-16BE" || string == "UTF-16LE" || string == "UTF-32BE" || string == "UTF-32LE") {
            return 16;
        }
        return 8;
    }

    protected final void writeAsEntity(int n2) throws IOException {
        int n3 = this.mOutputPtr;
        char[] cArray = this.mOutputBuffer;
        if (n3 + 10 >= cArray.length) {
            this.flushBuffer();
            n3 = this.mOutputPtr;
        }
        cArray[n3++] = 38;
        if (n2 < 256) {
            if (n2 == 38) {
                cArray[n3++] = 97;
                cArray[n3++] = 109;
                cArray[n3++] = 112;
            } else if (n2 == 60) {
                cArray[n3++] = 108;
                cArray[n3++] = 116;
            } else if (n2 == 62) {
                cArray[n3++] = 103;
                cArray[n3++] = 116;
            } else if (n2 == 39) {
                cArray[n3++] = 97;
                cArray[n3++] = 112;
                cArray[n3++] = 111;
                cArray[n3++] = 115;
            } else if (n2 == 34) {
                cArray[n3++] = 113;
                cArray[n3++] = 117;
                cArray[n3++] = 111;
                cArray[n3++] = 116;
            } else {
                cArray[n3++] = 35;
                cArray[n3++] = 120;
                if (n2 >= 16) {
                    int n4 = n2 >> 4;
                    cArray[n3++] = (char)(n4 < 10 ? 48 + n4 : 87 + n4);
                    n2 &= 0xF;
                }
                cArray[n3++] = (char)(n2 < 10 ? 48 + n2 : 87 + n2);
            }
        } else {
            cArray[n3++] = 35;
            cArray[n3++] = 120;
            int n5 = 20;
            int n6 = n3;
            do {
                int n7;
                if ((n7 = n2 >> n5 & 0xF) <= 0 && n3 == n6) continue;
                cArray[n3++] = (char)(n7 < 10 ? 48 + n7 : 87 + n7);
            } while ((n5 -= 4) > 0);
            cArray[n3++] = (char)((n2 &= 0xF) < 10 ? 48 + n2 : 87 + n2);
        }
        cArray[n3++] = 59;
        this.mOutputPtr = n3;
    }

    static {
        int[] nArray = new int[4096];
        Arrays.fill(nArray, 0, 32, 1);
        Arrays.fill(nArray, 127, 160, 1);
        nArray[9] = 0;
        nArray[10] = 0;
        nArray[60] = 1;
        nArray[62] = 1;
        nArray[38] = 1;
        QUOTABLE_TEXT_CHARS = nArray;
    }
}

