/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.WriterConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.AttributeCollector;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputElementStack;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.TypedStreamWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.XmlWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.EmptyNamespaceContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.StringVector;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.typed.AsciiValueEncoder;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;

public class NonNsStreamWriter
extends TypedStreamWriter {
    final StringVector mElements = new StringVector(32);
    TreeSet<String> mAttrNames;

    public NonNsStreamWriter(XmlWriter xmlWriter, String string, WriterConfig writerConfig) {
        super(xmlWriter, string, writerConfig);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return EmptyNamespaceContext.getInstance();
    }

    @Override
    public String getPrefix(String string) {
        return null;
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        NonNsStreamWriter.reportIllegalArg("Can not set default namespace for non-namespace writer.");
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) {
        NonNsStreamWriter.reportIllegalArg("Can not set NamespaceContext for non-namespace writer.");
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        NonNsStreamWriter.reportIllegalArg("Can not set namespace prefix for non-namespace writer.");
    }

    @Override
    public void writeAttribute(String string, String string2) throws XMLStreamException {
        if (!this.mStartElementOpen && this.mCheckStructure) {
            NonNsStreamWriter.reportNwfStructure(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        if (this.mCheckAttrs) {
            if (this.mAttrNames == null) {
                this.mAttrNames = new TreeSet();
            }
            if (!this.mAttrNames.add(string)) {
                NonNsStreamWriter.reportNwfAttr("Trying to write attribute '" + string + "' twice");
            }
        }
        if (this.mValidator != null) {
            this.mValidator.validateAttribute(string, "", "", string2);
        }
        try {
            this.mWriter.writeAttribute(string, string2);
        }
        catch (IOException iOException) {
            NonNsStreamWriter.throwFromIOE(iOException);
        }
    }

    @Override
    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        this.writeAttribute(string2, string3);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        this.writeAttribute(string3, string4);
    }

    @Override
    public void writeDefaultNamespace(String string) throws XMLStreamException {
        NonNsStreamWriter.reportIllegalMethod("Can not call writeDefaultNamespace namespaces with non-namespace writer.");
    }

    @Override
    public void writeEmptyElement(String string) throws XMLStreamException {
        this.doWriteStartElement(string);
        this.mEmptyElement = true;
    }

    @Override
    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.writeEmptyElement(string2);
    }

    @Override
    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.writeEmptyElement(string2);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.doWriteEndTag(null, this.mCfgAutomaticEmptyElems);
    }

    @Override
    public void writeNamespace(String string, String string2) throws XMLStreamException {
        NonNsStreamWriter.reportIllegalMethod("Can not set write namespaces with non-namespace writer.");
    }

    @Override
    public void writeStartElement(String string) throws XMLStreamException {
        this.doWriteStartElement(string);
        this.mEmptyElement = false;
    }

    @Override
    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.writeStartElement(string2);
    }

    @Override
    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.writeStartElement(string2);
    }

    @Override
    public void writeFullEndElement() throws XMLStreamException {
        this.doWriteEndTag(null, false);
    }

    @Override
    public QName getCurrentElementName() {
        if (this.mElements.isEmpty()) {
            return null;
        }
        return new QName(this.mElements.getLastString());
    }

    @Override
    public String getNamespaceURI(String string) {
        return null;
    }

    @Override
    public void writeStartElement(StartElement startElement) throws XMLStreamException {
        QName qName = startElement.getName();
        this.writeStartElement(qName.getLocalPart());
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            qName = attribute.getName();
            this.writeAttribute(qName.getLocalPart(), attribute.getValue());
        }
    }

    @Override
    public void writeEndElement(QName qName) throws XMLStreamException {
        this.doWriteEndTag(this.mCheckStructure ? qName.getLocalPart() : null, this.mCfgAutomaticEmptyElems);
    }

    @Override
    protected void writeTypedAttribute(String string, String string2, String string3, AsciiValueEncoder asciiValueEncoder) throws XMLStreamException {
        if (!this.mStartElementOpen && this.mCheckStructure) {
            NonNsStreamWriter.reportNwfStructure(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        if (this.mCheckAttrs) {
            if (this.mAttrNames == null) {
                this.mAttrNames = new TreeSet();
            }
            if (!this.mAttrNames.add(string3)) {
                NonNsStreamWriter.reportNwfAttr("Trying to write attribute '" + string3 + "' twice");
            }
        }
        try {
            if (this.mValidator == null) {
                this.mWriter.writeTypedAttribute(string3, asciiValueEncoder);
            } else {
                this.mWriter.writeTypedAttribute(null, string3, null, asciiValueEncoder, this.mValidator, this.getCopyBuffer());
            }
        }
        catch (IOException iOException) {
            NonNsStreamWriter.throwFromIOE(iOException);
        }
    }

    @Override
    protected void closeStartElement(boolean bl2) throws XMLStreamException {
        this.mStartElementOpen = false;
        if (this.mAttrNames != null) {
            this.mAttrNames.clear();
        }
        try {
            if (bl2) {
                this.mWriter.writeStartTagEmptyEnd();
            } else {
                this.mWriter.writeStartTagEnd();
            }
        }
        catch (IOException iOException) {
            NonNsStreamWriter.throwFromIOE(iOException);
        }
        if (this.mValidator != null) {
            this.mVldContent = this.mValidator.validateElementAndAttributes();
        }
        if (bl2) {
            String string = this.mElements.removeLast();
            if (this.mElements.isEmpty()) {
                this.mState = 3;
            }
            if (this.mValidator != null) {
                this.mVldContent = this.mValidator.validateElementEnd(string, "", "");
            }
        }
    }

    @Override
    public void copyStartElement(InputElementStack inputElementStack, AttributeCollector attributeCollector) throws IOException, XMLStreamException {
        int n2;
        int n3;
        int n4;
        String string;
        String string2 = inputElementStack.getLocalName();
        boolean bl2 = inputElementStack.isNamespaceAware();
        if (bl2 && (string = inputElementStack.getPrefix()) != null && string.length() > 0) {
            string2 = string + ":" + string2;
        }
        this.writeStartElement(string2);
        if (bl2 && (n4 = inputElementStack.getCurrentNsCount()) > 0) {
            for (n3 = 0; n3 < n4; ++n3) {
                String string3 = inputElementStack.getLocalNsPrefix(n3);
                string3 = string3 == null || string3.length() == 0 ? "xml" : "xmlns:" + string3;
                this.writeAttribute(string3, inputElementStack.getLocalNsURI(n3));
            }
        }
        int n5 = n2 = this.mCfgCopyDefaultAttrs ? attributeCollector.getCount() : attributeCollector.getSpecifiedCount();
        if (n2 > 0) {
            for (n3 = 0; n3 < n2; ++n3) {
                attributeCollector.writeAttribute(n3, this.mWriter, this.mValidator);
            }
        }
    }

    @Override
    protected String getTopElementDesc() {
        return this.mElements.isEmpty() ? "#root" : this.mElements.getLastString();
    }

    @Override
    public String validateQNamePrefix(QName qName) {
        return qName.getPrefix();
    }

    private void doWriteStartElement(String string) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        } else if (this.mState == 1) {
            this.verifyRootElement(string, null);
        } else if (this.mState == 3) {
            if (this.mCheckStructure) {
                NonNsStreamWriter.reportNwfStructure(ErrorConsts.WERR_PROLOG_SECOND_ROOT, string);
            }
            this.mState = 2;
        }
        if (this.mValidator != null) {
            this.mValidator.validateElementStart(string, "", "");
        }
        this.mStartElementOpen = true;
        this.mElements.addString(string);
        try {
            this.mWriter.writeStartTagStart(string);
        }
        catch (IOException iOException) {
            NonNsStreamWriter.throwFromIOE(iOException);
        }
    }

    private void doWriteEndTag(String string, boolean bl2) throws XMLStreamException {
        if (this.mStartElementOpen && this.mEmptyElement) {
            this.mEmptyElement = false;
            this.closeStartElement(true);
        }
        if (this.mState != 2) {
            NonNsStreamWriter.reportNwfStructure("No open start element, when trying to write end element");
        }
        String string2 = this.mElements.removeLast();
        if (this.mCheckStructure && string != null && !string2.equals(string)) {
            NonNsStreamWriter.reportNwfStructure("Mismatching close element name, '" + string2 + "'; expected '" + string + "'.");
        }
        if (this.mStartElementOpen) {
            if (this.mValidator != null) {
                this.mVldContent = this.mValidator.validateElementAndAttributes();
            }
            this.mStartElementOpen = false;
            if (this.mAttrNames != null) {
                this.mAttrNames.clear();
            }
            try {
                if (bl2) {
                    this.mWriter.writeStartTagEmptyEnd();
                    if (this.mElements.isEmpty()) {
                        this.mState = 3;
                    }
                    if (this.mValidator != null) {
                        this.mVldContent = this.mValidator.validateElementEnd(string2, "", "");
                    }
                    return;
                }
                this.mWriter.writeStartTagEnd();
            }
            catch (IOException iOException) {
                NonNsStreamWriter.throwFromIOE(iOException);
            }
        }
        try {
            this.mWriter.writeEndTag(string2);
        }
        catch (IOException iOException) {
            NonNsStreamWriter.throwFromIOE(iOException);
        }
        if (this.mElements.isEmpty()) {
            this.mState = 3;
        }
        if (this.mValidator != null) {
            this.mVldContent = this.mValidator.validateElementEnd(string2, "", "");
        }
    }
}

