/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.WriterConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.AttributeCollector;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputElementStack;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.BaseNsStreamWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.SimpleOutputElement;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.XmlWriter;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.typed.AsciiValueEncoder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;

public final class RepairingNsStreamWriter
extends BaseNsStreamWriter {
    protected final String mAutomaticNsPrefix;
    protected int[] mAutoNsSeq = null;
    protected String mSuggestedDefNs = null;
    protected HashMap<String, String> mSuggestedPrefixes = null;

    public RepairingNsStreamWriter(XmlWriter xmlWriter, String string, WriterConfig writerConfig) {
        super(xmlWriter, string, writerConfig, true);
        this.mAutomaticNsPrefix = writerConfig.getAutomaticNsPrefix();
    }

    @Override
    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            RepairingNsStreamWriter.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        this.doWriteAttr(string2, string, this.findOrCreateAttrPrefix(null, string, this.mCurrElem), string3);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            RepairingNsStreamWriter.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        this.doWriteAttr(string3, string2, this.findOrCreateAttrPrefix(string, string2, this.mCurrElem), string4);
    }

    @Override
    public void writeDefaultNamespace(String string) throws XMLStreamException {
        String string2;
        if (!this.mStartElementOpen) {
            RepairingNsStreamWriter.throwOutputError("Trying to write a namespace declaration when there is no open start element.");
        }
        if ((string2 = this.mCurrElem.getPrefix()) != null && string2.length() > 0) {
            this.mCurrElem.setDefaultNsUri(string);
            this.doWriteDefaultNs(string);
        }
    }

    @Override
    public void writeNamespace(String string, String string2) throws XMLStreamException {
        int n2;
        if (string == null || string.length() == 0) {
            this.writeDefaultNamespace(string2);
            return;
        }
        if (!this.mStartElementOpen) {
            RepairingNsStreamWriter.throwOutputError("Trying to write a namespace declaration when there is no open start element.");
        }
        if ((n2 = this.mCurrElem.isPrefixValid(string, string2, true)) == 0) {
            this.mCurrElem.addPrefix(string, string2);
            this.doWriteNamespace(string, string2);
        }
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.mSuggestedDefNs = string == null || string.length() == 0 ? null : string;
    }

    @Override
    public void doSetPrefix(String string, String string2) throws XMLStreamException {
        if (string2 == null || string2.length() == 0) {
            if (this.mSuggestedPrefixes != null) {
                Iterator<Map.Entry<String, String>> iterator = this.mSuggestedPrefixes.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    String string3 = entry.getValue();
                    if (!string3.equals(string)) continue;
                    iterator.remove();
                }
            }
        } else {
            if (this.mSuggestedPrefixes == null) {
                this.mSuggestedPrefixes = new HashMap(16);
            }
            this.mSuggestedPrefixes.put(string2, string);
        }
    }

    @Override
    public void writeStartElement(StartElement startElement) throws XMLStreamException {
        QName qName = startElement.getName();
        this.writeStartElement(qName.getPrefix(), qName.getLocalPart(), qName.getNamespaceURI());
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            qName = attribute.getName();
            this.writeAttribute(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart(), attribute.getValue());
        }
    }

    @Override
    protected void writeTypedAttribute(String string, String string2, String string3, AsciiValueEncoder asciiValueEncoder) throws XMLStreamException {
        super.writeTypedAttribute(this.findOrCreateAttrPrefix(string, string2, this.mCurrElem), string2, string3, asciiValueEncoder);
    }

    @Override
    protected void writeStartOrEmpty(String string, String string2) throws XMLStreamException {
        this.checkStartElement(string, "");
        String string3 = this.findElemPrefix(string2, this.mCurrElem);
        if (this.mOutputElemPool != null) {
            SimpleOutputElement simpleOutputElement = this.mOutputElemPool;
            this.mOutputElemPool = simpleOutputElement.reuseAsChild(this.mCurrElem, string3, string, string2);
            --this.mPoolSize;
            this.mCurrElem = simpleOutputElement;
        } else {
            this.mCurrElem = this.mCurrElem.createChild(string3, string, string2);
        }
        if (string3 != null) {
            if (this.mValidator != null) {
                this.mValidator.validateElementStart(string, string2, string3);
            }
            this.doWriteStartTag(string3, string);
        } else {
            string3 = this.generateElemPrefix(null, string2, this.mCurrElem);
            if (this.mValidator != null) {
                this.mValidator.validateElementStart(string, string2, string3);
            }
            this.mCurrElem.setPrefix(string3);
            this.doWriteStartTag(string3, string);
            if (string3 == null || string3.length() == 0) {
                this.mCurrElem.setDefaultNsUri(string2);
                this.doWriteDefaultNs(string2);
            } else {
                this.mCurrElem.addPrefix(string3, string2);
                this.doWriteNamespace(string3, string2);
            }
        }
    }

    @Override
    protected void writeStartOrEmpty(String string, String string2, String string3) throws XMLStreamException {
        this.checkStartElement(string2, string);
        String string4 = this.validateElemPrefix(string, string3, this.mCurrElem);
        if (string4 != null) {
            if (this.mValidator != null) {
                this.mValidator.validateElementStart(string2, string3, string4);
            }
            if (this.mOutputElemPool != null) {
                SimpleOutputElement simpleOutputElement = this.mOutputElemPool;
                this.mOutputElemPool = simpleOutputElement.reuseAsChild(this.mCurrElem, string4, string2, string3);
                --this.mPoolSize;
                this.mCurrElem = simpleOutputElement;
            } else {
                this.mCurrElem = this.mCurrElem.createChild(string4, string2, string3);
            }
            this.doWriteStartTag(string4, string2);
        } else {
            if (string == null) {
                string = "";
            }
            string4 = this.generateElemPrefix(string, string3, this.mCurrElem);
            if (this.mValidator != null) {
                this.mValidator.validateElementStart(string2, string3, string4);
            }
            if (this.mOutputElemPool != null) {
                SimpleOutputElement simpleOutputElement = this.mOutputElemPool;
                this.mOutputElemPool = simpleOutputElement.reuseAsChild(this.mCurrElem, string4, string2, string3);
                --this.mPoolSize;
                this.mCurrElem = simpleOutputElement;
            } else {
                this.mCurrElem = this.mCurrElem.createChild(string4, string2, string3);
            }
            this.mCurrElem.setPrefix(string4);
            this.doWriteStartTag(string4, string2);
            if (string4 == null || string4.length() == 0) {
                this.mCurrElem.setDefaultNsUri(string3);
                this.doWriteDefaultNs(string3);
            } else {
                this.mCurrElem.addPrefix(string4, string3);
                this.doWriteNamespace(string4, string3);
            }
        }
    }

    @Override
    public final void copyStartElement(InputElementStack inputElementStack, AttributeCollector attributeCollector) throws IOException, XMLStreamException {
        int n2;
        String string = inputElementStack.getPrefix();
        String string2 = inputElementStack.getNsURI();
        this.writeStartElement(string, inputElementStack.getLocalName(), string2);
        int n3 = inputElementStack.getCurrentNsCount();
        if (n3 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                this.writeNamespace(inputElementStack.getLocalNsPrefix(n2), inputElementStack.getLocalNsURI(n2));
            }
        }
        int n4 = n2 = this.mCfgCopyDefaultAttrs ? attributeCollector.getCount() : attributeCollector.getSpecifiedCount();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                string2 = attributeCollector.getURI(i2);
                string = attributeCollector.getPrefix(i2);
                if (string != null && string.length() != 0) {
                    string = this.findOrCreateAttrPrefix(string, string2, this.mCurrElem);
                }
                if (string == null || string.length() == 0) {
                    this.mWriter.writeAttribute(attributeCollector.getLocalName(i2), attributeCollector.getValue(i2));
                    continue;
                }
                this.mWriter.writeAttribute(string, attributeCollector.getLocalName(i2), attributeCollector.getValue(i2));
            }
        }
    }

    @Override
    public String validateQNamePrefix(QName qName) throws XMLStreamException {
        String string = qName.getNamespaceURI();
        String string2 = qName.getPrefix();
        String string3 = this.validateElemPrefix(string2, string, this.mCurrElem);
        if (string3 == null) {
            if (string2 == null) {
                string2 = "";
            }
            if ((string3 = this.generateElemPrefix(string2, string, this.mCurrElem)) == null || string3.length() == 0) {
                this.writeDefaultNamespace(string);
            } else {
                this.writeNamespace(string3, string);
            }
        }
        return string3;
    }

    protected final String findElemPrefix(String string, SimpleOutputElement simpleOutputElement) throws XMLStreamException {
        if (string == null || string.length() == 0) {
            String string2 = simpleOutputElement.getDefaultNsUri();
            if (string2 != null && string2.length() > 0) {
                return null;
            }
            return "";
        }
        return this.mCurrElem.getPrefix(string);
    }

    protected final String generateElemPrefix(String string, String string2, SimpleOutputElement simpleOutputElement) throws XMLStreamException {
        if (string2 == null || string2.length() == 0) {
            return "";
        }
        if (string == null) {
            if (this.mSuggestedDefNs != null && this.mSuggestedDefNs.equals(string2)) {
                string = "";
            } else {
                String string3 = string = this.mSuggestedPrefixes == null ? null : this.mSuggestedPrefixes.get(string2);
                if (string == null) {
                    if (this.mAutoNsSeq == null) {
                        this.mAutoNsSeq = new int[1];
                        this.mAutoNsSeq[0] = 1;
                    }
                    string = simpleOutputElement.generateMapping(this.mAutomaticNsPrefix, string2, this.mAutoNsSeq);
                }
            }
        }
        return string;
    }

    protected final String findOrCreateAttrPrefix(String string, String string2, SimpleOutputElement simpleOutputElement) throws XMLStreamException {
        String string3;
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        if (string != null) {
            int n2 = simpleOutputElement.isPrefixValid(string, string2, false);
            if (n2 == 1) {
                return string;
            }
            if (n2 == 0) {
                simpleOutputElement.addPrefix(string, string2);
                this.doWriteNamespace(string, string2);
                return string;
            }
        }
        if ((string3 = simpleOutputElement.getExplicitPrefix(string2)) != null) {
            return string3;
        }
        if (string != null) {
            string3 = string;
        } else if (this.mSuggestedPrefixes != null) {
            string3 = this.mSuggestedPrefixes.get(string2);
        }
        if (string3 != null && (string3.length() == 0 || simpleOutputElement.getNamespaceURI(string3) != null)) {
            string3 = null;
        }
        if (string3 == null) {
            if (this.mAutoNsSeq == null) {
                this.mAutoNsSeq = new int[1];
                this.mAutoNsSeq[0] = 1;
            }
            string3 = this.mCurrElem.generateMapping(this.mAutomaticNsPrefix, string2, this.mAutoNsSeq);
        }
        simpleOutputElement.addPrefix(string3, string2);
        this.doWriteNamespace(string3, string2);
        return string3;
    }

    private final String validateElemPrefix(String string, String string2, SimpleOutputElement simpleOutputElement) throws XMLStreamException {
        if (string2 == null || string2.length() == 0) {
            String string3 = simpleOutputElement.getDefaultNsUri();
            if (string3 == null || string3.length() == 0) {
                return "";
            }
            return null;
        }
        int n2 = simpleOutputElement.isPrefixValid(string, string2, true);
        if (n2 == 1) {
            return string;
        }
        return null;
    }
}

