/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.InvalidCharHandler;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.WriterConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxIOException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputData;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.XmlWriterWrapper;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.io.EscapingWriterFactory;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.typed.AsciiValueEncoder;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.MessageFormat;
import javax.xml.stream.XMLStreamException;

public abstract class XmlWriter {
    protected static final int SURR1_FIRST = 55296;
    protected static final int SURR1_LAST = 56319;
    protected static final int SURR2_FIRST = 56320;
    protected static final int SURR2_LAST = 57343;
    protected static final char DEFAULT_QUOTE_CHAR = '\"';
    protected final WriterConfig mConfig;
    protected final String mEncoding;
    protected final boolean mNsAware;
    protected final boolean mCheckStructure;
    protected final boolean mCheckContent;
    protected final boolean mCheckNames;
    protected final boolean mFixContent;
    final boolean mEscapeCR;
    final boolean mAddSpaceAfterEmptyElem;
    final boolean mUseDoubleQuotesInXmlDecl;
    protected final boolean mAutoCloseOutput;
    protected Writer mTextWriter;
    protected Writer mAttrValueWriter;
    protected boolean mXml11 = false;
    protected XmlWriterWrapper mRawWrapper = null;
    protected XmlWriterWrapper mTextWrapper = null;
    protected int mLocPastChars = 0;
    protected int mLocRowNr = 1;
    protected int mLocRowStartOffset = 0;

    protected XmlWriter(WriterConfig writerConfig, String string, boolean bl2) throws IOException {
        String string2;
        this.mConfig = writerConfig;
        this.mEncoding = string;
        this.mAutoCloseOutput = bl2;
        int n2 = writerConfig.getConfigFlags();
        this.mNsAware = (n2 & 1) != 0;
        this.mCheckStructure = (n2 & 0x100) != 0;
        this.mCheckContent = (n2 & 0x200) != 0;
        this.mCheckNames = (n2 & 0x400) != 0;
        this.mFixContent = (n2 & 0x1000) != 0;
        this.mEscapeCR = (n2 & 0x20) != 0;
        this.mAddSpaceAfterEmptyElem = (n2 & 0x40) != 0;
        this.mUseDoubleQuotesInXmlDecl = (n2 & 0x4000) != 0;
        EscapingWriterFactory escapingWriterFactory = this.mConfig.getTextEscaperFactory();
        if (escapingWriterFactory == null) {
            this.mTextWriter = null;
        } else {
            string2 = this.mEncoding == null || this.mEncoding.length() == 0 ? "UTF-8" : this.mEncoding;
            this.mTextWriter = escapingWriterFactory.createEscapingWriterFor(this.wrapAsRawWriter(), string2);
        }
        escapingWriterFactory = this.mConfig.getAttrValueEscaperFactory();
        if (escapingWriterFactory == null) {
            this.mAttrValueWriter = null;
        } else {
            string2 = this.mEncoding == null || this.mEncoding.length() == 0 ? "UTF-8" : this.mEncoding;
            this.mAttrValueWriter = escapingWriterFactory.createEscapingWriterFor(this.wrapAsRawWriter(), string2);
        }
    }

    public void enableXml11() {
        this.mXml11 = true;
    }

    protected abstract OutputStream getOutputStream();

    protected abstract Writer getWriter();

    public abstract void close(boolean var1) throws IOException;

    public abstract void flush() throws IOException;

    public abstract void writeRaw(String var1, int var2, int var3) throws IOException;

    public void writeRaw(String string) throws IOException {
        this.writeRaw(string, 0, string.length());
    }

    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException;

    public abstract void writeRawAscii(char[] var1, int var2, int var3) throws IOException;

    public abstract void writeCDataStart() throws IOException;

    public abstract void writeCDataEnd() throws IOException;

    public abstract void writeCommentStart() throws IOException;

    public abstract void writeCommentEnd() throws IOException;

    public abstract void writePIStart(String var1, boolean var2) throws IOException;

    public abstract void writePIEnd() throws IOException;

    public abstract int writeCData(String var1) throws IOException, XMLStreamException;

    public abstract int writeCData(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract void writeCharacters(String var1) throws IOException;

    public abstract void writeCharacters(char[] var1, int var2, int var3) throws IOException;

    public abstract int writeComment(String var1) throws IOException, XMLStreamException;

    public abstract void writeDTD(String var1) throws IOException, XMLStreamException;

    public abstract void writeDTD(String var1, String var2, String var3, String var4) throws IOException, XMLStreamException;

    public abstract void writeEntityReference(String var1) throws IOException, XMLStreamException;

    public abstract int writePI(String var1, String var2) throws IOException, XMLStreamException;

    public abstract void writeXmlDeclaration(String var1, String var2, String var3) throws IOException;

    public abstract void writeStartTagStart(String var1) throws IOException, XMLStreamException;

    public abstract void writeStartTagStart(String var1, String var2) throws IOException, XMLStreamException;

    public abstract void writeStartTagEnd() throws IOException;

    public abstract void writeStartTagEmptyEnd() throws IOException;

    public abstract void writeEndTag(String var1) throws IOException;

    public abstract void writeEndTag(String var1, String var2) throws IOException;

    public abstract void writeAttribute(String var1, String var2) throws IOException, XMLStreamException;

    public abstract void writeAttribute(String var1, char[] var2, int var3, int var4) throws IOException, XMLStreamException;

    public abstract void writeAttribute(String var1, String var2, String var3) throws IOException, XMLStreamException;

    public abstract void writeAttribute(String var1, String var2, char[] var3, int var4, int var5) throws IOException, XMLStreamException;

    public abstract void writeTypedElement(AsciiValueEncoder var1) throws IOException;

    public abstract void writeTypedElement(AsciiValueEncoder var1, XMLValidator var2, char[] var3) throws IOException, XMLStreamException;

    public abstract void writeTypedAttribute(String var1, AsciiValueEncoder var2) throws IOException, XMLStreamException;

    public abstract void writeTypedAttribute(String var1, String var2, AsciiValueEncoder var3) throws IOException, XMLStreamException;

    public abstract void writeTypedAttribute(String var1, String var2, String var3, AsciiValueEncoder var4, XMLValidator var5, char[] var6) throws IOException, XMLStreamException;

    protected abstract int getOutputPtr();

    public int getRow() {
        return this.mLocRowNr;
    }

    public int getColumn() {
        return this.getOutputPtr() - this.mLocRowStartOffset + 1;
    }

    public int getAbsOffset() {
        return this.mLocPastChars + this.getOutputPtr();
    }

    public final Writer wrapAsRawWriter() {
        if (this.mRawWrapper == null) {
            this.mRawWrapper = XmlWriterWrapper.wrapWriteRaw(this);
        }
        return this.mRawWrapper;
    }

    public final Writer wrapAsTextWriter() {
        if (this.mTextWrapper == null) {
            this.mTextWrapper = XmlWriterWrapper.wrapWriteCharacters(this);
        }
        return this.mTextWrapper;
    }

    public final void verifyNameValidity(String string, boolean bl2) throws XMLStreamException {
        int n2;
        if (string == null || string.length() == 0) {
            this.reportNwfName(ErrorConsts.WERR_NAME_EMPTY);
        }
        if ((n2 = WstxInputData.findIllegalNameChar(string, bl2, this.mXml11)) >= 0) {
            String string2 = n2 == 0 ? MessageFormat.format(ErrorConsts.WERR_NAME_ILLEGAL_FIRST_CHAR, WstxInputData.getCharDesc(string.charAt(0)), string) : MessageFormat.format(ErrorConsts.WERR_NAME_ILLEGAL_CHAR, WstxInputData.getCharDesc(string.charAt(n2)), string, n2);
            this.reportNwfName(string2);
        }
    }

    protected void reportNwfName(String string) throws XMLStreamException {
        this.throwOutputError(string);
    }

    protected void reportNwfContent(String string) throws XMLStreamException {
        this.throwOutputError(string);
    }

    protected void throwOutputError(String string) throws XMLStreamException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
        throw new XMLStreamException(string);
    }

    protected void throwOutputError(String string, Object object) throws XMLStreamException {
        this.throwOutputError(MessageFormat.format(string, object));
    }

    protected char handleInvalidChar(int n2) throws IOException {
        this.flush();
        InvalidCharHandler invalidCharHandler = this.mConfig.getInvalidCharHandler();
        if (invalidCharHandler == null) {
            invalidCharHandler = InvalidCharHandler.FailingHandler.getInstance();
        }
        return invalidCharHandler.convertInvalidChar(n2);
    }
}

