/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.util;

import java.io.IOException;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static void throwRuntimeException(Throwable throwable) {
        ExceptionUtil.throwIfUnchecked(throwable);
        throw new RuntimeException("[was " + throwable.getClass() + "] " + throwable.getMessage(), throwable);
    }

    public static IOException constructIOException(String string, Throwable throwable) {
        IOException iOException = new IOException(string);
        ExceptionUtil.setInitCause(iOException, throwable);
        return iOException;
    }

    public static void throwAsIllegalArgument(Throwable throwable) {
        ExceptionUtil.throwIfUnchecked(throwable);
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("[was " + throwable.getClass() + "] " + throwable.getMessage());
        ExceptionUtil.setInitCause(illegalArgumentException, throwable);
        throw illegalArgumentException;
    }

    public static void throwIfUnchecked(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    public static void throwGenericInternal() {
        ExceptionUtil.throwInternal(null);
    }

    public static void throwInternal(String string) {
        if (string == null) {
            string = "[no description]";
        }
        throw new RuntimeException("Internal error: " + string);
    }

    public static void setInitCause(Throwable throwable, Throwable throwable2) {
        if (throwable.getCause() == null) {
            throwable.initCause(throwable2);
        }
    }
}

